/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.prepare;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.adapter.java.JavaTypeFactory;
import hive.org.apache.calcite.linq4j.Queryable;
import hive.org.apache.calcite.linq4j.tree.BlockStatement;
import hive.org.apache.calcite.linq4j.tree.Blocks;
import hive.org.apache.calcite.linq4j.tree.ConstantExpression;
import hive.org.apache.calcite.linq4j.tree.Expression;
import hive.org.apache.calcite.linq4j.tree.FunctionExpression;
import hive.org.apache.calcite.linq4j.tree.MethodCallExpression;
import hive.org.apache.calcite.linq4j.tree.NewExpression;
import hive.org.apache.calcite.linq4j.tree.Types;
import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelOptTable;
import hive.org.apache.calcite.prepare.CalcitePrepareImpl;
import hive.org.apache.calcite.prepare.Prepare;
import hive.org.apache.calcite.prepare.QueryableRelBuilder;
import hive.org.apache.calcite.prepare.RelOptTableImpl;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.logical.LogicalFilter;
import hive.org.apache.calcite.rel.logical.LogicalProject;
import hive.org.apache.calcite.rel.logical.LogicalTableScan;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rex.RexBuilder;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.schema.SchemaPlus;
import hive.org.apache.calcite.util.BuiltInMethod;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class LixToRelTranslator
implements RelOptTable.ToRelContext {
    final RelOptCluster cluster;
    private final Prepare preparingStmt;
    final JavaTypeFactory typeFactory;

    public LixToRelTranslator(RelOptCluster cluster, Prepare preparingStmt) {
        this.cluster = cluster;
        this.preparingStmt = preparingStmt;
        this.typeFactory = (JavaTypeFactory)cluster.getTypeFactory();
    }

    @Override
    public RelOptCluster getCluster() {
        return this.cluster;
    }

    @Override
    public RelNode expandView(RelDataType rowType, String queryString, List<String> schemaPath) {
        return this.preparingStmt.expandView(rowType, queryString, schemaPath);
    }

    @Override
    public RelNode expandView(RelDataType rowType, String queryString, SchemaPlus rootSchema, List<String> schemaPath) {
        return this.preparingStmt.expandView(rowType, queryString, rootSchema, schemaPath);
    }

    public <T> RelNode translate(Queryable<T> queryable) {
        QueryableRelBuilder<T> translatorQueryable = new QueryableRelBuilder<T>(this);
        return translatorQueryable.toRel(queryable);
    }

    public RelNode translate(Expression expression) {
        if (expression instanceof MethodCallExpression) {
            MethodCallExpression call = (MethodCallExpression)expression;
            BuiltInMethod method = BuiltInMethod.MAP.get(call.method);
            if (method == null) {
                throw new UnsupportedOperationException("unknown method " + call.method);
            }
            switch (method) {
                case SELECT: {
                    RelNode input = this.translate(call.targetExpression);
                    return LogicalProject.create(input, this.toRex(input, (FunctionExpression)call.expressions.get(0)), (List<String>)null);
                }
                case WHERE: {
                    RelNode input = this.translate(call.targetExpression);
                    return LogicalFilter.create(input, this.toRex((FunctionExpression)call.expressions.get(0), input));
                }
                case AS_QUERYABLE: {
                    return LogicalTableScan.create(this.cluster, RelOptTableImpl.create(null, this.typeFactory.createJavaType(Types.toClass((Type)Types.getElementType((Type)call.targetExpression.getType()))), ImmutableList.of(), call.targetExpression));
                }
                case SCHEMA_GET_TABLE: {
                    return LogicalTableScan.create(this.cluster, RelOptTableImpl.create(null, this.typeFactory.createJavaType((Class)((ConstantExpression)call.expressions.get((int)1)).value), ImmutableList.of(), call.targetExpression));
                }
            }
            throw new UnsupportedOperationException("unknown method " + call.method);
        }
        throw new UnsupportedOperationException("unknown expression type " + expression.getNodeType());
    }

    private List<RexNode> toRex(RelNode child, FunctionExpression expression) {
        RexBuilder rexBuilder = this.cluster.getRexBuilder();
        List<RexNode> list = Collections.singletonList(rexBuilder.makeRangeReference(child));
        CalcitePrepareImpl.ScalarTranslator translator = CalcitePrepareImpl.EmptyScalarTranslator.empty(rexBuilder).bind(expression.parameterList, list);
        ArrayList<RexNode> rexList = new ArrayList<RexNode>();
        Expression simple = Blocks.simple((BlockStatement)expression.body);
        for (Expression expression1 : this.fieldExpressions(simple)) {
            rexList.add(translator.toRex(expression1));
        }
        return rexList;
    }

    List<Expression> fieldExpressions(Expression expression) {
        if (expression instanceof NewExpression) {
            return ((NewExpression)expression).arguments;
        }
        throw new RuntimeException("unsupported expression type " + expression);
    }

    List<RexNode> toRexList(FunctionExpression expression, RelNode ... inputs) {
        ArrayList<RexNode> list = new ArrayList<RexNode>();
        RexBuilder rexBuilder = this.cluster.getRexBuilder();
        for (RelNode input : inputs) {
            list.add(rexBuilder.makeRangeReference(input));
        }
        return CalcitePrepareImpl.EmptyScalarTranslator.empty(rexBuilder).bind(expression.parameterList, list).toRexList(expression.body);
    }

    RexNode toRex(FunctionExpression expression, RelNode ... inputs) {
        ArrayList<RexNode> list = new ArrayList<RexNode>();
        RexBuilder rexBuilder = this.cluster.getRexBuilder();
        for (RelNode input : inputs) {
            list.add(rexBuilder.makeRangeReference(input));
        }
        return CalcitePrepareImpl.EmptyScalarTranslator.empty(rexBuilder).bind(expression.parameterList, list).toRex(expression.body);
    }
}

