/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.plan;

import hive.org.apache.calcite.DataContext;
import hive.org.apache.calcite.adapter.java.JavaTypeFactory;
import hive.org.apache.calcite.linq4j.QueryProvider;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.logical.LogicalFilter;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rex.RexCall;
import hive.org.apache.calcite.rex.RexInputRef;
import hive.org.apache.calcite.rex.RexLiteral;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.schema.SchemaPlus;
import hive.org.apache.calcite.sql.SqlOperator;
import hive.org.apache.calcite.sql.fun.SqlCastFunction;
import hive.org.apache.calcite.util.NlsString;
import hive.org.apache.calcite.util.Pair;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.Calendar;
import java.util.List;

public class VisitorDataContext
implements DataContext {
    private final Object[] values;

    public VisitorDataContext(Object[] values) {
        this.values = values;
    }

    @Override
    public SchemaPlus getRootSchema() {
        throw new RuntimeException("Unsupported");
    }

    @Override
    public JavaTypeFactory getTypeFactory() {
        throw new RuntimeException("Unsupported");
    }

    @Override
    public QueryProvider getQueryProvider() {
        throw new RuntimeException("Unsupported");
    }

    @Override
    public Object get(String name) {
        if (name.equals("inputRecord")) {
            return this.values;
        }
        return null;
    }

    public static DataContext of(RelNode targetRel, LogicalFilter queryRel) {
        return VisitorDataContext.of(targetRel.getRowType(), queryRel.getCondition());
    }

    public static DataContext of(RelDataType rowType, RexNode rex) {
        RexNode secondOperand;
        int size = rowType.getFieldList().size();
        Object[] values = new Object[size];
        List<RexNode> operands = ((RexCall)rex).getOperands();
        RexNode firstOperand = operands.get(0);
        Pair<Integer, ?> value = VisitorDataContext.getValue(firstOperand, secondOperand = operands.get(1));
        if (value != null) {
            int index = value.getKey();
            values[index] = value.getValue();
            return new VisitorDataContext(values);
        }
        return null;
    }

    public static DataContext of(RelDataType rowType, List<Pair<RexInputRef, RexNode>> usageList) {
        int size = rowType.getFieldList().size();
        Object[] values = new Object[size];
        for (Pair<RexInputRef, RexNode> elem : usageList) {
            Pair<Integer, ?> value = VisitorDataContext.getValue(elem.getKey(), elem.getValue());
            if (value == null) {
                return null;
            }
            int index = value.getKey();
            values[index] = value.getValue();
        }
        return new VisitorDataContext(values);
    }

    public static Pair<Integer, ?> getValue(RexNode inputRef, RexNode literal) {
        inputRef = VisitorDataContext.removeCast(inputRef);
        literal = VisitorDataContext.removeCast(literal);
        if (inputRef instanceof RexInputRef && literal instanceof RexLiteral) {
            int index = ((RexInputRef)inputRef).getIndex();
            Object value = ((RexLiteral)literal).getValue();
            RelDataType type = inputRef.getType();
            switch (type.getSqlTypeName()) {
                case INTEGER: {
                    if (value instanceof BigDecimal) {
                        return Pair.of(index, ((BigDecimal)value).intValue());
                    }
                }
                case DOUBLE: {
                    if (value instanceof BigDecimal) {
                        return Pair.of(index, ((BigDecimal)value).doubleValue());
                    }
                }
                case REAL: {
                    if (value instanceof BigDecimal) {
                        return Pair.of(index, Float.valueOf(((BigDecimal)value).floatValue()));
                    }
                }
                case BIGINT: {
                    if (value instanceof BigDecimal) {
                        return Pair.of(index, ((BigDecimal)value).longValue());
                    }
                }
                case SMALLINT: {
                    if (value instanceof BigDecimal) {
                        return Pair.of(index, ((BigDecimal)value).shortValue());
                    }
                }
                case TINYINT: {
                    if (value instanceof BigDecimal) {
                        return Pair.of(index, Short.valueOf(((BigDecimal)value).byteValue()));
                    }
                }
                case DECIMAL: {
                    if (value instanceof BigDecimal) {
                        return Pair.of(index, value);
                    }
                }
                case DATE: {
                    if (value instanceof NlsString) {
                        value = ((RexLiteral)literal).getValue2();
                        Date dateValue = Date.valueOf((String)value);
                        return Pair.of(index, dateValue);
                    }
                    if (value instanceof Calendar) {
                        long timeInMillis = ((Calendar)value).getTimeInMillis();
                        return Pair.of(index, new Date(timeInMillis));
                    }
                }
                case CHAR: {
                    if (!(value instanceof NlsString)) break;
                    NlsString nl = (NlsString)value;
                    return Pair.of(index, Character.valueOf(nl.getValue().charAt(0)));
                }
            }
            return Pair.of(index, value);
        }
        return null;
    }

    private static RexNode removeCast(RexNode inputRef) {
        RexCall castedRef;
        SqlOperator operator;
        if (inputRef instanceof RexCall && (operator = (castedRef = (RexCall)inputRef).getOperator()) instanceof SqlCastFunction) {
            inputRef = castedRef.getOperands().get(0);
        }
        return inputRef;
    }
}

