/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.plan;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.linq4j.tree.Expression;
import hive.org.apache.calcite.plan.RelOptSchema;
import hive.org.apache.calcite.plan.RelOptTable;
import hive.org.apache.calcite.rel.RelCollation;
import hive.org.apache.calcite.rel.RelDistribution;
import hive.org.apache.calcite.rel.RelDistributions;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.logical.LogicalTableScan;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeField;
import hive.org.apache.calcite.util.ImmutableBitSet;
import java.util.Collections;
import java.util.List;

public abstract class RelOptAbstractTable
implements RelOptTable {
    protected final RelOptSchema schema;
    protected final RelDataType rowType;
    protected final String name;

    protected RelOptAbstractTable(RelOptSchema schema, String name, RelDataType rowType) {
        this.schema = schema;
        this.name = name;
        this.rowType = rowType;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getQualifiedName() {
        return ImmutableList.of(this.name);
    }

    @Override
    public double getRowCount() {
        return 100.0;
    }

    @Override
    public RelDataType getRowType() {
        return this.rowType;
    }

    @Override
    public RelOptSchema getRelOptSchema() {
        return this.schema;
    }

    @Override
    public List<RelCollation> getCollationList() {
        return Collections.emptyList();
    }

    @Override
    public RelDistribution getDistribution() {
        return RelDistributions.BROADCAST_DISTRIBUTED;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        return clazz.isInstance(this) ? (T)clazz.cast(this) : null;
    }

    @Override
    public boolean isKey(ImmutableBitSet columns) {
        return false;
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context) {
        return LogicalTableScan.create(context.getCluster(), this);
    }

    @Override
    public Expression getExpression(Class clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RelOptTable extend(List<RelDataTypeField> extendedFields) {
        throw new UnsupportedOperationException();
    }
}

