/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.avatica;

import hive.org.apache.calcite.avatica.AvaticaDatabaseMetaData;
import hive.org.apache.calcite.avatica.AvaticaFactory;
import hive.org.apache.calcite.avatica.AvaticaResultSet;
import hive.org.apache.calcite.avatica.AvaticaStatement;
import hive.org.apache.calcite.avatica.ConnectionConfig;
import hive.org.apache.calcite.avatica.ConnectionConfigImpl;
import hive.org.apache.calcite.avatica.ConnectionPropertiesImpl;
import hive.org.apache.calcite.avatica.Helper;
import hive.org.apache.calcite.avatica.InternalProperty;
import hive.org.apache.calcite.avatica.Meta;
import hive.org.apache.calcite.avatica.UnregisteredDriver;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;

public abstract class AvaticaConnection
implements Connection {
    protected int statementCount;
    private boolean closed;
    private int holdability;
    private int networkTimeout;
    public final String id;
    public final Meta.ConnectionHandle handle;
    protected final UnregisteredDriver driver;
    protected final AvaticaFactory factory;
    final String url;
    protected final Properties info;
    protected final Meta meta;
    protected final AvaticaDatabaseMetaData metaData;
    public final Helper helper = Helper.INSTANCE;
    public final Map<InternalProperty, Object> properties = new HashMap<InternalProperty, Object>();
    public final Map<Integer, AvaticaStatement> statementMap = new ConcurrentHashMap<Integer, AvaticaStatement>();

    protected AvaticaConnection(UnregisteredDriver driver, AvaticaFactory factory, String url, Properties info) {
        this.id = UUID.randomUUID().toString();
        this.handle = new Meta.ConnectionHandle(this.id);
        this.driver = driver;
        this.factory = factory;
        this.url = url;
        this.info = info;
        this.meta = driver.createMeta(this);
        this.metaData = factory.newDatabaseMetaData(this);
        this.holdability = this.metaData.getResultSetHoldability();
    }

    public ConnectionConfig config() {
        return new ConnectionConfigImpl(this.info);
    }

    @Override
    public AvaticaStatement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, this.holdability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007, this.holdability);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.meta.connectionSync(this.handle, new ConnectionPropertiesImpl().setAutoCommit(autoCommit));
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.meta.connectionSync(this.handle, new ConnectionPropertiesImpl()).isAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rollback() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws SQLException {
        if (!this.closed) {
            this.closed = true;
            try {
                this.meta.closeConnection(this.handle);
                this.driver.handler.onConnectionClose(this);
            }
            catch (RuntimeException e) {
                throw this.helper.createException("While closing connection", e);
            }
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.metaData;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.meta.connectionSync(this.handle, new ConnectionPropertiesImpl().setReadOnly(readOnly));
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.meta.connectionSync(this.handle, new ConnectionPropertiesImpl()).isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.meta.connectionSync(this.handle, new ConnectionPropertiesImpl().setCatalog(catalog));
    }

    @Override
    public String getCatalog() {
        return this.meta.connectionSync(this.handle, new ConnectionPropertiesImpl()).getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.meta.connectionSync(this.handle, new ConnectionPropertiesImpl().setTransactionIsolation(level));
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.meta.connectionSync(this.handle, new ConnectionPropertiesImpl()).getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, this.holdability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, this.holdability);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        if (holdability != 2 && holdability != 1) {
            throw new SQLException("invalid value");
        }
        this.holdability = holdability;
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.holdability;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public AvaticaStatement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.factory.newStatement(this, null, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            Meta.ConnectionHandle ch = new Meta.ConnectionHandle(this.id);
            Meta.StatementHandle h = this.meta.prepare(ch, sql, -1);
            return this.factory.newPreparedStatement(this, h, h.signature, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (RuntimeException e) {
            throw this.helper.createException("while preparing SQL: " + sql, e);
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.meta.connectionSync(this.handle, new ConnectionPropertiesImpl().setSchema(schema));
    }

    @Override
    public String getSchema() {
        return this.meta.connectionSync(this.handle, new ConnectionPropertiesImpl()).getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.networkTimeout = milliseconds;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.networkTimeout;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return iface.cast(this);
        }
        throw this.helper.createException("does not implement '" + iface + "'");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    public TimeZone getTimeZone() {
        String timeZoneName = this.config().timeZone();
        return timeZoneName == null ? TimeZone.getDefault() : TimeZone.getTimeZone(timeZoneName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultSet executeQueryInternal(AvaticaStatement statement, Meta.Signature signature, Meta.Frame firstFrame) throws SQLException {
        AvaticaStatement avaticaStatement = statement;
        synchronized (avaticaStatement) {
            if (statement.openResultSet != null) {
                AvaticaResultSet rs = statement.openResultSet;
                statement.openResultSet = null;
                try {
                    rs.close();
                }
                catch (Exception e) {
                    throw this.helper.createException("Error while closing previous result set", e);
                }
            }
            TimeZone timeZone = this.getTimeZone();
            statement.openResultSet = this.factory.newResultSet(statement, signature, timeZone, firstFrame);
        }
        try {
            statement.openResultSet.execute();
        }
        catch (Exception e) {
            throw this.helper.createException("exception while executing query: " + e.getMessage(), e);
        }
        return statement.openResultSet;
    }

    protected Meta.ExecuteResult prepareAndExecuteInternal(final AvaticaStatement statement, String sql, int maxRowCount) throws SQLException {
        Meta.PrepareCallback callback = new Meta.PrepareCallback(){

            @Override
            public Object getMonitor() {
                return statement;
            }

            @Override
            public void clear() throws SQLException {
                if (statement.openResultSet != null) {
                    AvaticaResultSet rs = statement.openResultSet;
                    statement.openResultSet = null;
                    try {
                        rs.close();
                    }
                    catch (Exception e) {
                        throw AvaticaConnection.this.helper.createException("Error while closing previous result set", e);
                    }
                }
            }

            @Override
            public void assign(Meta.Signature signature, Meta.Frame firstFrame, int updateCount) throws SQLException {
                if (updateCount != -1) {
                    statement.updateCount = updateCount;
                } else {
                    TimeZone timeZone = AvaticaConnection.this.getTimeZone();
                    statement.openResultSet = AvaticaConnection.this.factory.newResultSet(statement, signature, timeZone, firstFrame);
                }
            }

            @Override
            public void execute() throws SQLException {
                if (statement.openResultSet != null) {
                    statement.openResultSet.execute();
                }
            }
        };
        return this.meta.prepareAndExecute(this.handle, sql, maxRowCount, callback);
    }

    protected ResultSet createResultSet(Meta.MetaResultSet metaResultSet) throws SQLException {
        Meta.StatementHandle h = new Meta.StatementHandle(metaResultSet.connectionId, metaResultSet.statementId, null);
        AvaticaStatement statement = this.lookupStatement(h);
        return this.executeQueryInternal(statement, metaResultSet.signature.sanitize(), metaResultSet.firstFrame);
    }

    protected AvaticaStatement lookupStatement(Meta.StatementHandle h) throws SQLException {
        AvaticaStatement statement = this.statementMap.get(h.id);
        if (statement != null) {
            return statement;
        }
        return this.factory.newStatement(this, Objects.requireNonNull(h), 1003, 1007, this.holdability);
    }

    protected static Trojan createTrojan() {
        return new Trojan();
    }

    public static class Trojan {
        private Trojan() {
        }

        public ResultSet execute(AvaticaResultSet resultSet) throws SQLException {
            return resultSet.execute();
        }

        public List<Object> getParameterValues(AvaticaStatement statement) {
            return statement.getParameterValues();
        }

        public Meta getMeta(AvaticaConnection connection) {
            return connection.meta;
        }
    }
}

