/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.adapter.enumerable;

import hive.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import hive.org.apache.calcite.adapter.enumerable.EnumerableRel;
import hive.org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import hive.org.apache.calcite.adapter.enumerable.PhysType;
import hive.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import hive.org.apache.calcite.linq4j.tree.BlockBuilder;
import hive.org.apache.calcite.linq4j.tree.Expression;
import hive.org.apache.calcite.linq4j.tree.Expressions;
import hive.org.apache.calcite.linq4j.tree.Statement;
import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelTrait;
import hive.org.apache.calcite.plan.RelTraitSet;
import hive.org.apache.calcite.rel.RelCollation;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Sort;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.util.BuiltInMethod;
import hive.org.apache.calcite.util.Pair;
import java.lang.reflect.Method;

public class EnumerableSort
extends Sort
implements EnumerableRel {
    public EnumerableSort(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RelCollation collation, RexNode offset, RexNode fetch) {
        super(cluster, traitSet, input, collation, offset, fetch);
        assert (this.getConvention() instanceof EnumerableConvention);
        assert (this.getConvention() == input.getConvention());
    }

    public static EnumerableSort create(RelNode child, RelCollation collation, RexNode offset, RexNode fetch) {
        RelOptCluster cluster = child.getCluster();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE).replace(collation);
        return new EnumerableSort(cluster, traitSet, child, collation, offset, fetch);
    }

    @Override
    public EnumerableSort copy(RelTraitSet traitSet, RelNode newInput, RelCollation newCollation, RexNode offset, RexNode fetch) {
        return new EnumerableSort(this.getCluster(), traitSet, newInput, newCollation, offset, fetch);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        BlockBuilder builder = new BlockBuilder();
        EnumerableRel child = (EnumerableRel)this.getInput();
        EnumerableRel.Result result = implementor.visitChild(this, 0, child, pref);
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), result.format);
        Expression childExp = builder.append("child", result.block);
        PhysType inputPhysType = result.physType;
        Pair<Expression, Expression> pair = inputPhysType.generateCollationKey(this.collation.getFieldCollations());
        builder.add((Statement)Expressions.return_(null, (Expression)Expressions.call((Expression)childExp, (Method)BuiltInMethod.ORDER_BY.method, (Iterable)Expressions.list((Object[])new Expression[]{builder.append("keySelector", (Expression)pair.left)}).appendIfNotNull((Object)builder.appendIfNotNull("comparator", (Expression)pair.right)))));
        return implementor.result(physType, builder.toBlock());
    }
}

