/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.adapter.enumerable;

import hive.com.google.common.collect.Lists;
import hive.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import hive.org.apache.calcite.adapter.enumerable.EnumerableFilter;
import hive.org.apache.calcite.adapter.enumerable.EnumerableMergeJoin;
import hive.org.apache.calcite.adapter.enumerable.EnumerableRules;
import hive.org.apache.calcite.linq4j.Ord;
import hive.org.apache.calcite.plan.Convention;
import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelTraitSet;
import hive.org.apache.calcite.rel.AbstractRelNode;
import hive.org.apache.calcite.rel.InvalidRelException;
import hive.org.apache.calcite.rel.RelCollation;
import hive.org.apache.calcite.rel.RelCollations;
import hive.org.apache.calcite.rel.RelFieldCollation;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.convert.ConverterRule;
import hive.org.apache.calcite.rel.core.JoinInfo;
import hive.org.apache.calcite.rel.core.JoinRelType;
import hive.org.apache.calcite.rel.logical.LogicalJoin;
import java.util.ArrayList;

class EnumerableMergeJoinRule
extends ConverterRule {
    EnumerableMergeJoinRule() {
        super(LogicalJoin.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableMergeJoinRule");
    }

    @Override
    public RelNode convert(RelNode rel) {
        AbstractRelNode newRel;
        LogicalJoin join = (LogicalJoin)rel;
        JoinInfo info = JoinInfo.of(join.getLeft(), join.getRight(), join.getCondition());
        if (join.getJoinType() != JoinRelType.INNER) {
            return null;
        }
        if (info.pairs().size() == 0) {
            return null;
        }
        ArrayList<RelNode> newInputs = Lists.newArrayList();
        ArrayList<RelCollation> collations = Lists.newArrayList();
        int offset = 0;
        for (Ord ord : Ord.zip(join.getInputs())) {
            RelTraitSet traits = ((RelNode)ord.e).getTraitSet().replace(EnumerableConvention.INSTANCE);
            if (!info.pairs().isEmpty()) {
                ArrayList<RelFieldCollation> fieldCollations = Lists.newArrayList();
                for (int key : info.keys().get(ord.i)) {
                    fieldCollations.add(new RelFieldCollation(key, RelFieldCollation.Direction.ASCENDING, RelFieldCollation.NullDirection.LAST));
                }
                RelCollation collation = RelCollations.of(fieldCollations);
                collations.add(RelCollations.shift(collation, offset));
                traits = traits.replace(collation);
            }
            newInputs.add(EnumerableMergeJoinRule.convert((RelNode)ord.e, traits));
            offset += ((RelNode)ord.e).getRowType().getFieldCount();
        }
        RelNode left = (RelNode)newInputs.get(0);
        RelNode right = (RelNode)newInputs.get(1);
        RelOptCluster cluster = join.getCluster();
        try {
            RelTraitSet traits = join.getTraitSet().replace(EnumerableConvention.INSTANCE);
            if (!collations.isEmpty()) {
                traits = traits.replace(collations);
            }
            newRel = new EnumerableMergeJoin(cluster, traits, left, right, info.getEquiCondition(left, right, cluster.getRexBuilder()), info.leftKeys, info.rightKeys, join.getJoinType(), join.getVariablesStopped());
        }
        catch (InvalidRelException e) {
            EnumerableRules.LOGGER.fine(e.toString());
            return null;
        }
        if (!info.isEqui()) {
            newRel = new EnumerableFilter(cluster, newRel.getTraitSet(), newRel, info.getRemaining(cluster.getRexBuilder()));
        }
        return newRel;
    }
}

