/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.adapter.enumerable;

import hive.com.google.common.base.Supplier;
import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.DataContext;
import hive.org.apache.calcite.adapter.enumerable.EnumUtils;
import hive.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import hive.org.apache.calcite.adapter.enumerable.EnumerableRel;
import hive.org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import hive.org.apache.calcite.adapter.enumerable.PhysType;
import hive.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import hive.org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import hive.org.apache.calcite.adapter.java.JavaTypeFactory;
import hive.org.apache.calcite.linq4j.Enumerator;
import hive.org.apache.calcite.linq4j.tree.BlockBuilder;
import hive.org.apache.calcite.linq4j.tree.BlockStatement;
import hive.org.apache.calcite.linq4j.tree.Blocks;
import hive.org.apache.calcite.linq4j.tree.Expression;
import hive.org.apache.calcite.linq4j.tree.Expressions;
import hive.org.apache.calcite.linq4j.tree.MemberDeclaration;
import hive.org.apache.calcite.linq4j.tree.NewExpression;
import hive.org.apache.calcite.linq4j.tree.Node;
import hive.org.apache.calcite.linq4j.tree.ParameterExpression;
import hive.org.apache.calcite.linq4j.tree.Statement;
import hive.org.apache.calcite.linq4j.tree.Types;
import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelTraitSet;
import hive.org.apache.calcite.rel.RelCollation;
import hive.org.apache.calcite.rel.RelCollationTraitDef;
import hive.org.apache.calcite.rel.RelDistribution;
import hive.org.apache.calcite.rel.RelDistributionTraitDef;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Calc;
import hive.org.apache.calcite.rel.metadata.RelMdCollation;
import hive.org.apache.calcite.rel.metadata.RelMdDistribution;
import hive.org.apache.calcite.rex.RexProgram;
import hive.org.apache.calcite.util.BuiltInMethod;
import hive.org.apache.calcite.util.Pair;
import hive.org.apache.calcite.util.Util;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;

public class EnumerableCalc
extends Calc
implements EnumerableRel {
    public EnumerableCalc(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RexProgram program) {
        super(cluster, traitSet, input, program);
        assert (this.getConvention() instanceof EnumerableConvention);
        assert (!program.containsAggs());
    }

    @Deprecated
    public EnumerableCalc(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RexProgram program, List<RelCollation> collationList) {
        this(cluster, traitSet, input, program);
        Util.discard(collationList);
    }

    public static EnumerableCalc create(final RelNode input, final RexProgram program) {
        RelOptCluster cluster = input.getCluster();
        RelTraitSet traitSet = cluster.traitSet().replace(EnumerableConvention.INSTANCE).replaceIfs(RelCollationTraitDef.INSTANCE, new Supplier<List<RelCollation>>(){

            @Override
            public List<RelCollation> get() {
                return RelMdCollation.calc(input, program);
            }
        }).replaceIf(RelDistributionTraitDef.INSTANCE, new Supplier<RelDistribution>(){

            @Override
            public RelDistribution get() {
                return RelMdDistribution.calc(input, program);
            }
        });
        return new EnumerableCalc(cluster, traitSet, input, program);
    }

    @Override
    public EnumerableCalc copy(RelTraitSet traitSet, RelNode child, RexProgram program) {
        return new EnumerableCalc(this.getCluster(), traitSet, child, program);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        BlockStatement moveNextBody;
        JavaTypeFactory typeFactory = implementor.getTypeFactory();
        BlockBuilder builder = new BlockBuilder();
        EnumerableRel child = (EnumerableRel)this.getInput();
        EnumerableRel.Result result = implementor.visitChild(this, 0, child, pref);
        PhysType physType = PhysTypeImpl.of(typeFactory, this.getRowType(), pref.prefer(result.format));
        Type outputJavaType = physType.getJavaRowType();
        Type enumeratorType = Types.of(Enumerator.class, (Type[])new Type[]{outputJavaType});
        Type inputJavaType = result.physType.getJavaRowType();
        ParameterExpression inputEnumerator = Expressions.parameter((Type)Types.of(Enumerator.class, (Type[])new Type[]{inputJavaType}), (String)"inputEnumerator");
        Expression input = RexToLixTranslator.convert((Expression)Expressions.call((Expression)inputEnumerator, (Method)BuiltInMethod.ENUMERATOR_CURRENT.method, (Expression[])new Expression[0]), inputJavaType);
        if (this.program.getCondition() == null) {
            moveNextBody = Blocks.toFunctionBlock((Node)Expressions.call((Expression)inputEnumerator, (Method)BuiltInMethod.ENUMERATOR_MOVE_NEXT.method, (Expression[])new Expression[0]));
        } else {
            BlockBuilder builder2 = new BlockBuilder();
            Expression condition = RexToLixTranslator.translateCondition(this.program, typeFactory, builder2, new RexToLixTranslator.InputGetterImpl(Collections.singletonList(Pair.of(input, result.physType))), implementor.allCorrelateVariables);
            builder2.add((Statement)Expressions.ifThen((Expression)condition, (Node)Expressions.return_(null, (Expression)Expressions.constant((Object)true))));
            moveNextBody = Expressions.block((Statement[])new Statement[]{Expressions.while_((Expression)Expressions.call((Expression)inputEnumerator, (Method)BuiltInMethod.ENUMERATOR_MOVE_NEXT.method, (Expression[])new Expression[0]), (Statement)builder2.toBlock()), Expressions.return_(null, (Expression)Expressions.constant((Object)false))});
        }
        BlockBuilder builder3 = new BlockBuilder();
        List<Expression> expressions = RexToLixTranslator.translateProjects(this.program, typeFactory, builder3, physType, (Expression)DataContext.ROOT, new RexToLixTranslator.InputGetterImpl(Collections.singletonList(Pair.of(input, result.physType))), implementor.allCorrelateVariables);
        builder3.add((Statement)Expressions.return_(null, (Expression)physType.record(expressions)));
        BlockStatement currentBody = builder3.toBlock();
        Expression inputEnumerable = builder.append("inputEnumerable", result.block, false);
        NewExpression body = Expressions.new_((Type)enumeratorType, EnumUtils.NO_EXPRS, (Iterable)Expressions.list((Object[])new MemberDeclaration[]{Expressions.fieldDecl((int)17, (ParameterExpression)inputEnumerator, (Expression)Expressions.call((Expression)inputEnumerable, (Method)BuiltInMethod.ENUMERABLE_ENUMERATOR.method, (Expression[])new Expression[0])), EnumUtils.overridingMethodDecl(BuiltInMethod.ENUMERATOR_RESET.method, EnumUtils.NO_PARAMS, Blocks.toFunctionBlock((Node)Expressions.call((Expression)inputEnumerator, (Method)BuiltInMethod.ENUMERATOR_RESET.method, (Expression[])new Expression[0]))), EnumUtils.overridingMethodDecl(BuiltInMethod.ENUMERATOR_MOVE_NEXT.method, EnumUtils.NO_PARAMS, moveNextBody), EnumUtils.overridingMethodDecl(BuiltInMethod.ENUMERATOR_CLOSE.method, EnumUtils.NO_PARAMS, Blocks.toFunctionBlock((Node)Expressions.call((Expression)inputEnumerator, (Method)BuiltInMethod.ENUMERATOR_CLOSE.method, (Expression[])new Expression[0]))), Expressions.methodDecl((int)1, Object.class, (String)"current", EnumUtils.NO_PARAMS, (BlockStatement)currentBody)}));
        builder.add((Statement)Expressions.return_(null, (Expression)Expressions.new_((Constructor)BuiltInMethod.ABSTRACT_ENUMERABLE_CTOR.constructor, EnumUtils.NO_EXPRS, ImmutableList.of(Expressions.methodDecl((int)1, (Type)enumeratorType, (String)BuiltInMethod.ENUMERABLE_ENUMERATOR.method.getName(), EnumUtils.NO_PARAMS, (BlockStatement)Blocks.toFunctionBlock((Node)body))))));
        return implementor.result(physType, builder.toBlock());
    }

    @Override
    public RexProgram getProgram() {
        return this.program;
    }
}

