/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.cfg.context;

import java.lang.reflect.Method;
import org.hibernate.validator.cfg.ConstraintDef;
import org.hibernate.validator.cfg.context.ParameterConstraintMappingContext;
import org.hibernate.validator.cfg.context.ReturnValueConstraintMappingContext;
import org.hibernate.validator.internal.cfg.context.ConfiguredConstraint;
import org.hibernate.validator.internal.cfg.context.ConstraintMappingContext;
import org.hibernate.validator.internal.cfg.context.ConstraintMappingContextImplBase;
import org.hibernate.validator.internal.cfg.context.ReturnValueConstraintMappingContextImpl;
import org.hibernate.validator.internal.metadata.location.MethodConstraintLocation;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public final class ParameterConstraintMappingContextImpl
extends ConstraintMappingContextImplBase
implements ParameterConstraintMappingContext {
    private static final Log log = LoggerFactory.make();
    private final Method method;
    private final int parameterIndex;

    public ParameterConstraintMappingContextImpl(Class<?> beanClass, Method method, int parameterIndex, ConstraintMappingContext mapping) {
        super(beanClass, mapping);
        if (parameterIndex < 0 || parameterIndex >= method.getParameterTypes().length) {
            throw log.getInvalidMethodParameterIndexException(method.getName());
        }
        this.method = method;
        this.parameterIndex = parameterIndex;
    }

    @Override
    public ParameterConstraintMappingContext constraint(ConstraintDef<?, ?> definition) {
        this.mapping.addMethodConstraintConfig(ConfiguredConstraint.forParameter(definition, this.method, this.parameterIndex));
        return this;
    }

    @Override
    public ParameterConstraintMappingContext valid() {
        this.mapping.addMethodCascadeConfig(new MethodConstraintLocation(this.method, this.parameterIndex));
        return this;
    }

    @Override
    public ParameterConstraintMappingContext parameter(int index) {
        return new ParameterConstraintMappingContextImpl(this.beanClass, this.method, index, this.mapping);
    }

    @Override
    public ReturnValueConstraintMappingContext returnValue() {
        return new ReturnValueConstraintMappingContextImpl(this.beanClass, this.method, this.mapping);
    }
}

