/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive.schema;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.apache.calcite.schema.Table;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.hive.schema.HiveSchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveDatabaseSchema
extends AbstractSchema {
    static final Logger logger = LoggerFactory.getLogger(HiveDatabaseSchema.class);
    private final HiveSchemaFactory.HiveSchema hiveSchema;
    private final Set<String> tables;

    public HiveDatabaseSchema(List<String> tableList, HiveSchemaFactory.HiveSchema hiveSchema, String name) {
        super(hiveSchema.getSchemaPath(), name);
        this.hiveSchema = hiveSchema;
        this.tables = Sets.newHashSet(tableList);
    }

    public Table getTable(String tableName) {
        return this.hiveSchema.getDrillTable(this.name, tableName);
    }

    public Set<String> getTableNames() {
        return this.tables;
    }

    public String getTypeName() {
        return "hive";
    }
}

