/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.drill.common.JSONOptions;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.ops.OptimizerRulesContext;
import org.apache.drill.exec.planner.sql.logical.ConvertHiveParquetScanToDrillParquetScan;
import org.apache.drill.exec.planner.sql.logical.HivePushPartitionFilterIntoScan;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.store.AbstractStoragePlugin;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.StoragePluginOptimizerRule;
import org.apache.drill.exec.store.hive.HiveReadEntry;
import org.apache.drill.exec.store.hive.HiveScan;
import org.apache.drill.exec.store.hive.HiveStoragePluginConfig;
import org.apache.drill.exec.store.hive.HiveUtilities;
import org.apache.drill.exec.store.hive.schema.HiveSchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveStoragePlugin
extends AbstractStoragePlugin {
    static final Logger logger = LoggerFactory.getLogger(HiveStoragePlugin.class);
    private final HiveStoragePluginConfig config;
    private final HiveSchemaFactory schemaFactory;
    private final DrillbitContext context;
    private final String name;

    public HiveStoragePlugin(HiveStoragePluginConfig config, DrillbitContext context, String name) throws ExecutionSetupException {
        this.config = config;
        this.context = context;
        this.schemaFactory = new HiveSchemaFactory(this, name, config.getHiveConfigOverride());
        this.name = name;
    }

    public HiveStoragePluginConfig getConfig() {
        return this.config;
    }

    public String getName() {
        return this.name;
    }

    public DrillbitContext getContext() {
        return this.context;
    }

    public HiveScan getPhysicalScan(String userName, JSONOptions selection, List<SchemaPath> columns) throws IOException {
        HiveReadEntry hiveReadEntry = (HiveReadEntry)selection.getListWith(new ObjectMapper(), (TypeReference)new TypeReference<HiveReadEntry>(){});
        try {
            if (hiveReadEntry.getJdbcTableType() == Schema.TableType.VIEW) {
                throw new UnsupportedOperationException("Querying views created in Hive from Drill is not supported in current version.");
            }
            return new HiveScan(userName, hiveReadEntry, this, columns);
        }
        catch (ExecutionSetupException e) {
            throw new IOException(e);
        }
    }

    public void registerSchemas(SchemaConfig schemaConfig, SchemaPlus parent) throws IOException {
        this.schemaFactory.registerSchemas(schemaConfig, parent);
    }

    public Set<StoragePluginOptimizerRule> getOptimizerRules(OptimizerRulesContext optimizerRulesContext) {
        String defaultPartitionValue = HiveUtilities.getDefaultPartitionValue(this.config.getHiveConfigOverride());
        ImmutableSet.Builder ruleBuilder = ImmutableSet.builder();
        ruleBuilder.add((Object)HivePushPartitionFilterIntoScan.getFilterOnProject(optimizerRulesContext, defaultPartitionValue));
        ruleBuilder.add((Object)HivePushPartitionFilterIntoScan.getFilterOnScan(optimizerRulesContext, defaultPartitionValue));
        if (optimizerRulesContext.getPlannerSettings().getOptions().getOption((String)"store.hive.optimize_scan_with_native_readers").bool_val.booleanValue()) {
            ruleBuilder.add((Object)ConvertHiveParquetScanToDrillParquetScan.INSTANCE);
        }
        return ruleBuilder.build();
    }
}

