/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.store.hive.HiveAuthorizationHelper;
import org.apache.drill.exec.store.hive.HiveReadEntry;
import org.apache.drill.exec.store.hive.HiveTable;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAccessControlException;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DrillHiveMetaStoreClient
extends HiveMetaStoreClient {
    private static final Logger logger = LoggerFactory.getLogger(DrillHiveMetaStoreClient.class);
    protected final Map<String, String> hiveConfigOverride;

    public static DrillHiveMetaStoreClient createClientWithAuthz(DrillHiveMetaStoreClient processUserMetaStoreClient, HiveConf hiveConf, final Map<String, String> hiveConfigOverride, final String userName, final boolean ignoreAuthzErrors) throws MetaException {
        try {
            HiveConf hiveConfForClient;
            UserGroupInformation ugiForRpc;
            boolean delegationTokenGenerated = false;
            if (!hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS)) {
                ugiForRpc = ImpersonationUtil.getProcessUserUGI();
            } else {
                ugiForRpc = ImpersonationUtil.createProxyUgi((String)userName);
                if (hiveConf.getBoolVar(HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL)) {
                    String delegationToken = processUserMetaStoreClient.getDelegationToken(userName, userName);
                    try {
                        Utils.setTokenStr((UserGroupInformation)ugiForRpc, (String)delegationToken, (String)"DrillDelegationTokenForHiveMetaStoreServer");
                    }
                    catch (IOException e) {
                        throw new DrillRuntimeException("Couldn't setup delegation token in the UGI for Hive MetaStoreClient", (Throwable)e);
                    }
                    delegationTokenGenerated = true;
                }
            }
            if (delegationTokenGenerated) {
                hiveConfForClient = new HiveConf(hiveConf);
                hiveConfForClient.set("hive.metastore.token.signature", "DrillDelegationTokenForHiveMetaStoreServer");
            } else {
                hiveConfForClient = hiveConf;
            }
            return (DrillHiveMetaStoreClient)((Object)ugiForRpc.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<DrillHiveMetaStoreClient>(){

                @Override
                public DrillHiveMetaStoreClient run() throws Exception {
                    return new HiveClientWithAuthz(hiveConfForClient, hiveConfigOverride, ugiForRpc, userName, ignoreAuthzErrors);
                }
            }));
        }
        catch (Exception e) {
            throw new DrillRuntimeException("Failure setting up HiveMetaStore client.", (Throwable)e);
        }
    }

    public static DrillHiveMetaStoreClient createNonCloseableClientWithCaching(HiveConf hiveConf, Map<String, String> hiveConfigOverride) throws MetaException {
        return new NonCloseableHiveClientWithCaching(hiveConf, hiveConfigOverride);
    }

    private DrillHiveMetaStoreClient(HiveConf hiveConf, Map<String, String> hiveConfigOverride) throws MetaException {
        super(hiveConf);
        this.hiveConfigOverride = hiveConfigOverride;
    }

    public abstract List<String> getDatabases() throws TException;

    public abstract List<String> getTableNames(String var1) throws TException;

    public abstract HiveReadEntry getHiveReadEntry(String var1, String var2) throws TException;

    protected static List<String> getDatabasesHelper(IMetaStoreClient mClient) throws TException {
        try {
            return mClient.getAllDatabases();
        }
        catch (TException e) {
            logger.warn("Failure while attempting to get hive databases", (Throwable)e);
            mClient.reconnect();
            return mClient.getAllDatabases();
        }
    }

    protected static List<String> getTableNamesHelper(IMetaStoreClient mClient, String dbName) throws TException {
        try {
            return mClient.getAllTables(dbName);
        }
        catch (TException e) {
            logger.warn("Failure while attempting to get hive tables", (Throwable)e);
            mClient.reconnect();
            return mClient.getAllTables(dbName);
        }
    }

    protected static HiveReadEntry getHiveReadEntryHelper(IMetaStoreClient mClient, String dbName, String tableName, Map<String, String> hiveConfigOverride) throws TException {
        List partitions;
        Table t = null;
        try {
            t = mClient.getTable(dbName, tableName);
        }
        catch (TException e) {
            mClient.reconnect();
            t = mClient.getTable(dbName, tableName);
        }
        if (t == null) {
            throw new UnknownTableException(String.format("Unable to find table '%s'.", tableName));
        }
        try {
            partitions = mClient.listPartitions(dbName, tableName, (short)-1);
        }
        catch (TException e) {
            mClient.reconnect();
            partitions = mClient.listPartitions(dbName, tableName, (short)-1);
        }
        ArrayList hivePartitions = Lists.newArrayList();
        for (Partition part : partitions) {
            hivePartitions.add(new HiveTable.HivePartition(part));
        }
        if (hivePartitions.size() == 0) {
            hivePartitions = null;
        }
        return new HiveReadEntry(new HiveTable(t), hivePartitions, hiveConfigOverride);
    }

    private static class NonCloseableHiveClientWithCaching
    extends DrillHiveMetaStoreClient {
        private final LoadingCache<String, List<String>> databases = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new DatabaseLoader());
        private final LoadingCache<String, List<String>> tableNameLoader = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new TableNameLoader());
        private final LoadingCache<String, LoadingCache<String, HiveReadEntry>> tableLoaders = CacheBuilder.newBuilder().expireAfterAccess(4L, TimeUnit.HOURS).maximumSize(20L).build((CacheLoader)new TableLoaderLoader());

        private NonCloseableHiveClientWithCaching(HiveConf hiveConf, Map<String, String> hiveConfigOverride) throws MetaException {
            super(hiveConf, hiveConfigOverride);
        }

        @Override
        public List<String> getDatabases() throws TException {
            try {
                return (List)this.databases.get((Object)"databases");
            }
            catch (ExecutionException e) {
                throw new TException((Throwable)e);
            }
        }

        @Override
        public List<String> getTableNames(String dbName) throws TException {
            try {
                return (List)this.tableNameLoader.get((Object)dbName);
            }
            catch (ExecutionException e) {
                throw new TException((Throwable)e);
            }
        }

        @Override
        public HiveReadEntry getHiveReadEntry(String dbName, String tableName) throws TException {
            try {
                return (HiveReadEntry)((LoadingCache)this.tableLoaders.get((Object)dbName)).get((Object)tableName);
            }
            catch (ExecutionException e) {
                throw new TException((Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getDelegationToken(String owner, String renewerKerberosPrincipalName) throws TException {
            NonCloseableHiveClientWithCaching nonCloseableHiveClientWithCaching = this;
            synchronized (nonCloseableHiveClientWithCaching) {
                return super.getDelegationToken(owner, renewerKerberosPrincipalName);
            }
        }

        public void close() {
        }

        private class TableLoader
        extends CacheLoader<String, HiveReadEntry> {
            private final String dbName;

            public TableLoader(String dbName) {
                this.dbName = dbName;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public HiveReadEntry load(String key) throws Exception {
                NonCloseableHiveClientWithCaching nonCloseableHiveClientWithCaching = NonCloseableHiveClientWithCaching.this;
                synchronized (nonCloseableHiveClientWithCaching) {
                    return DrillHiveMetaStoreClient.getHiveReadEntryHelper((IMetaStoreClient)NonCloseableHiveClientWithCaching.this, this.dbName, key, NonCloseableHiveClientWithCaching.this.hiveConfigOverride);
                }
            }
        }

        private class TableLoaderLoader
        extends CacheLoader<String, LoadingCache<String, HiveReadEntry>> {
            private TableLoaderLoader() {
            }

            public LoadingCache<String, HiveReadEntry> load(String key) throws Exception {
                return CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new TableLoader(key));
            }
        }

        private class TableNameLoader
        extends CacheLoader<String, List<String>> {
            private TableNameLoader() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<String> load(String dbName) throws Exception {
                NonCloseableHiveClientWithCaching nonCloseableHiveClientWithCaching = NonCloseableHiveClientWithCaching.this;
                synchronized (nonCloseableHiveClientWithCaching) {
                    return DrillHiveMetaStoreClient.getTableNamesHelper((IMetaStoreClient)NonCloseableHiveClientWithCaching.this, dbName);
                }
            }
        }

        private class DatabaseLoader
        extends CacheLoader<String, List<String>> {
            private DatabaseLoader() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<String> load(String key) throws Exception {
                if (!"databases".equals(key)) {
                    throw new UnsupportedOperationException();
                }
                NonCloseableHiveClientWithCaching nonCloseableHiveClientWithCaching = NonCloseableHiveClientWithCaching.this;
                synchronized (nonCloseableHiveClientWithCaching) {
                    return DrillHiveMetaStoreClient.getDatabasesHelper((IMetaStoreClient)NonCloseableHiveClientWithCaching.this);
                }
            }
        }
    }

    private static class HiveClientWithAuthz
    extends DrillHiveMetaStoreClient {
        public static final String DRILL2HMS_TOKEN = "DrillDelegationTokenForHiveMetaStoreServer";
        private final UserGroupInformation ugiForRpc;
        private final boolean ignoreAuthzErrors;
        private HiveAuthorizationHelper authorizer;

        private HiveClientWithAuthz(HiveConf hiveConf, Map<String, String> hiveConfigOverride, UserGroupInformation ugiForRpc, String userName, boolean ignoreAuthzErrors) throws TException {
            super(hiveConf, hiveConfigOverride);
            this.ugiForRpc = ugiForRpc;
            this.ignoreAuthzErrors = ignoreAuthzErrors;
            this.authorizer = new HiveAuthorizationHelper((IMetaStoreClient)this, hiveConf, userName);
        }

        public void reconnect() throws MetaException {
            try {
                this.ugiForRpc.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        HiveClientWithAuthz.this.reconnectSuper();
                        return null;
                    }
                });
            }
            catch (IOException | InterruptedException e) {
                throw new DrillRuntimeException("Failed to reconnect to HiveMetaStore: " + e.getMessage(), (Throwable)e);
            }
        }

        private void reconnectSuper() throws MetaException {
            super.reconnect();
        }

        @Override
        public List<String> getDatabases() throws TException {
            try {
                this.authorizer.authorizeShowDatabases();
            }
            catch (HiveAccessControlException e) {
                if (this.ignoreAuthzErrors) {
                    return Collections.emptyList();
                }
                throw UserException.permissionError((Throwable)e).build(logger);
            }
            return HiveClientWithAuthz.getDatabasesHelper((IMetaStoreClient)this);
        }

        @Override
        public List<String> getTableNames(String dbName) throws TException {
            try {
                this.authorizer.authorizeShowTables(dbName);
            }
            catch (HiveAccessControlException e) {
                if (this.ignoreAuthzErrors) {
                    return Collections.emptyList();
                }
                throw UserException.permissionError((Throwable)e).build(logger);
            }
            return HiveClientWithAuthz.getTableNamesHelper((IMetaStoreClient)this, dbName);
        }

        @Override
        public HiveReadEntry getHiveReadEntry(String dbName, String tableName) throws TException {
            block2: {
                try {
                    this.authorizer.authorizeReadTable(dbName, tableName);
                }
                catch (HiveAccessControlException e) {
                    if (this.ignoreAuthzErrors) break block2;
                    throw UserException.permissionError((Throwable)e).build(logger);
                }
            }
            return HiveClientWithAuthz.getHiveReadEntryHelper((IMetaStoreClient)this, dbName, tableName, this.hiveConfigOverride);
        }
    }
}

