/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.logical;

import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.drill.exec.ops.OptimizerRulesContext;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.planner.PartitionDescriptor;
import org.apache.drill.exec.planner.logical.DrillFilterRel;
import org.apache.drill.exec.planner.logical.DrillProjectRel;
import org.apache.drill.exec.planner.logical.DrillScanRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.logical.partition.PruneScanRule;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.sql.HivePartitionDescriptor;
import org.apache.drill.exec.store.StoragePluginOptimizerRule;
import org.apache.drill.exec.store.hive.HiveScan;

public abstract class HivePushPartitionFilterIntoScan {
    public static final StoragePluginOptimizerRule getFilterOnProject(OptimizerRulesContext optimizerRulesContext, final String defaultPartitionValue) {
        return new PruneScanRule(RelOptHelper.some(DrillFilterRel.class, (RelOptRuleOperand)RelOptHelper.some(DrillProjectRel.class, (RelOptRuleOperand)RelOptHelper.any(DrillScanRel.class), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "HivePushPartitionFilterIntoScan:Filter_On_Project_Hive", optimizerRulesContext){

            public PartitionDescriptor getPartitionDescriptor(PlannerSettings settings, DrillScanRel scanRel) {
                return new HivePartitionDescriptor(settings, scanRel, this.getOptimizerRulesContext().getManagedBuffer(), defaultPartitionValue);
            }

            public boolean matches(RelOptRuleCall call) {
                DrillScanRel scan = (DrillScanRel)call.rel(2);
                GroupScan groupScan = scan.getGroupScan();
                return groupScan instanceof HiveScan && groupScan.supportsPartitionFilterPushdown();
            }

            public void onMatch(RelOptRuleCall call) {
                DrillFilterRel filterRel = (DrillFilterRel)call.rel(0);
                DrillProjectRel projectRel = (DrillProjectRel)call.rel(1);
                DrillScanRel scanRel = (DrillScanRel)call.rel(2);
                this.doOnMatch(call, filterRel, projectRel, scanRel);
            }
        };
    }

    public static final StoragePluginOptimizerRule getFilterOnScan(OptimizerRulesContext optimizerRulesContext, final String defaultPartitionValue) {
        return new PruneScanRule(RelOptHelper.some(DrillFilterRel.class, (RelOptRuleOperand)RelOptHelper.any(DrillScanRel.class), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "HivePushPartitionFilterIntoScan:Filter_On_Scan_Hive", optimizerRulesContext){

            public PartitionDescriptor getPartitionDescriptor(PlannerSettings settings, DrillScanRel scanRel) {
                return new HivePartitionDescriptor(settings, scanRel, this.getOptimizerRulesContext().getManagedBuffer(), defaultPartitionValue);
            }

            public boolean matches(RelOptRuleCall call) {
                DrillScanRel scan = (DrillScanRel)call.rel(1);
                GroupScan groupScan = scan.getGroupScan();
                return groupScan instanceof HiveScan && groupScan.supportsPartitionFilterPushdown();
            }

            public void onMatch(RelOptRuleCall call) {
                DrillFilterRel filterRel = (DrillFilterRel)call.rel(0);
                DrillScanRel scanRel = (DrillScanRel)call.rel(1);
                this.doOnMatch(call, filterRel, null, scanRel);
            }
        };
    }
}

