/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.hive;

import org.apache.drill.exec.expr.fn.impl.hive.AbstractDrillPrimitiveObjectInspector;
import org.apache.drill.exec.expr.holders.NullableTinyIntHolder;
import org.apache.drill.exec.expr.holders.TinyIntHolder;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class DrillTinyIntObjectInspector {

    public static class Optional
    extends AbstractDrillPrimitiveObjectInspector
    implements ByteObjectInspector {
        public Optional() {
            super(TypeInfoFactory.byteTypeInfo);
        }

        public byte get(Object o) {
            return ((NullableTinyIntHolder)o).value;
        }

        public Byte getPrimitiveJavaObject(Object o) {
            if (o == null) {
                return null;
            }
            return new Byte(((NullableTinyIntHolder)o).value);
        }

        public ByteWritable getPrimitiveWritableObject(Object o) {
            if (o == null) {
                return null;
            }
            NullableTinyIntHolder h = (NullableTinyIntHolder)o;
            return new ByteWritable(h.value);
        }
    }

    public static class Required
    extends AbstractDrillPrimitiveObjectInspector
    implements ByteObjectInspector {
        public Required() {
            super(TypeInfoFactory.byteTypeInfo);
        }

        public byte get(Object o) {
            return ((TinyIntHolder)o).value;
        }

        public Byte getPrimitiveJavaObject(Object o) {
            return new Byte(((TinyIntHolder)o).value);
        }

        public ByteWritable getPrimitiveWritableObject(Object o) {
            TinyIntHolder h = (TinyIntHolder)o;
            return new ByteWritable(h.value);
        }
    }
}

