/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.values.bitpacking;

import java.io.IOException;
import java.nio.ByteBuffer;
import parquet.Log;
import parquet.bytes.BytesUtils;
import parquet.column.values.ValuesReader;
import parquet.column.values.bitpacking.BytePacker;
import parquet.column.values.bitpacking.Packer;

public class ByteBitPackingValuesReader
extends ValuesReader {
    private static final int VALUES_AT_A_TIME = 8;
    private static final Log LOG = Log.getLog(ByteBitPackingValuesReader.class);
    private final int bitWidth;
    private final BytePacker packer;
    private final int[] decoded = new int[8];
    private int decodedPosition = 7;
    private ByteBuffer encoded;
    private int encodedPos;
    private int nextOffset;

    public ByteBitPackingValuesReader(int bound, Packer packer) {
        this.bitWidth = BytesUtils.getWidthFromMaxInt((int)bound);
        this.packer = packer.newBytePacker(this.bitWidth);
    }

    @Override
    public int readInteger() {
        ++this.decodedPosition;
        if (this.decodedPosition == this.decoded.length) {
            this.encoded.position(this.encodedPos);
            if (this.encodedPos + this.bitWidth > this.encoded.limit()) {
                byte[] tempEncode = new byte[this.bitWidth];
                this.encoded.get(tempEncode, 0, this.encoded.limit() - this.encodedPos);
                this.packer.unpack8Values(ByteBuffer.wrap(tempEncode), 0, this.decoded, 0);
            } else {
                this.packer.unpack8Values(this.encoded, this.encodedPos, this.decoded, 0);
            }
            this.encodedPos += this.bitWidth;
            this.decodedPosition = 0;
        }
        return this.decoded[this.decodedPosition];
    }

    @Override
    public void initFromPage(int valueCount, ByteBuffer page, int offset) throws IOException {
        int effectiveBitLength = valueCount * this.bitWidth;
        int length = BytesUtils.paddedByteCountFromBits((int)effectiveBitLength);
        if (Log.DEBUG) {
            LOG.debug((Object)("reading " + length + " bytes for " + valueCount + " values of size " + this.bitWidth + " bits."));
        }
        this.encoded = page;
        this.encodedPos = offset;
        this.decodedPosition = 7;
        this.nextOffset = offset + length;
    }

    @Override
    public void initFromPage(int valueCount, byte[] page, int offset) throws IOException {
        this.initFromPage(valueCount, ByteBuffer.wrap(page), offset);
    }

    @Override
    public int getNextOffset() {
        return this.nextOffset;
    }

    @Override
    public void skip() {
        this.readInteger();
    }
}

