/*
 * Decompiled with CFR 0.152.
 */
package parquet.column;

import parquet.bytes.ByteBufferAllocator;
import parquet.bytes.BytesUtils;
import parquet.bytes.HeapByteBufferAllocator;
import parquet.column.ColumnDescriptor;
import parquet.column.ColumnWriteStore;
import parquet.column.Encoding;
import parquet.column.impl.ColumnWriteStoreV1;
import parquet.column.impl.ColumnWriteStoreV2;
import parquet.column.page.PageWriteStore;
import parquet.column.values.ValuesWriter;
import parquet.column.values.boundedint.DevNullValuesWriter;
import parquet.column.values.delta.DeltaBinaryPackingValuesWriter;
import parquet.column.values.deltastrings.DeltaByteArrayWriter;
import parquet.column.values.dictionary.DictionaryValuesWriter;
import parquet.column.values.fallback.FallbackValuesWriter;
import parquet.column.values.plain.BooleanPlainValuesWriter;
import parquet.column.values.plain.FixedLenByteArrayPlainValuesWriter;
import parquet.column.values.plain.PlainValuesWriter;
import parquet.column.values.rle.RunLengthBitPackingHybridValuesWriter;
import parquet.schema.MessageType;

public class ParquetProperties {
    private final int dictionaryPageSizeThreshold;
    private final WriterVersion writerVersion;
    private final boolean enableDictionary;
    private ByteBufferAllocator allocator;

    public ParquetProperties(int dictPageSize, WriterVersion writerVersion, boolean enableDict) {
        this(dictPageSize, writerVersion, enableDict, (ByteBufferAllocator)new HeapByteBufferAllocator());
    }

    public ParquetProperties(int dictPageSize, WriterVersion writerVersion, boolean enableDict, ByteBufferAllocator allocator) {
        this.dictionaryPageSizeThreshold = dictPageSize;
        this.writerVersion = writerVersion;
        this.enableDictionary = enableDict;
        this.allocator = allocator;
    }

    public static ValuesWriter getColumnDescriptorValuesWriter(int maxLevel, int initialSizePerCol, ByteBufferAllocator allocator) {
        if (maxLevel == 0) {
            return new DevNullValuesWriter();
        }
        return new RunLengthBitPackingHybridValuesWriter(BytesUtils.getWidthFromMaxInt((int)maxLevel), initialSizePerCol, (ByteBufferAllocator)(allocator != null ? allocator : new HeapByteBufferAllocator()));
    }

    private ValuesWriter plainWriter(ColumnDescriptor path, int initialSizePerCol) {
        switch (path.getType()) {
            case BOOLEAN: {
                return new BooleanPlainValuesWriter(this.allocator);
            }
            case INT96: {
                return new FixedLenByteArrayPlainValuesWriter(12, initialSizePerCol, this.allocator);
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return new FixedLenByteArrayPlainValuesWriter(path.getTypeLength(), initialSizePerCol, this.allocator);
            }
            case BINARY: 
            case INT32: 
            case INT64: 
            case DOUBLE: 
            case FLOAT: {
                return new PlainValuesWriter(initialSizePerCol, this.allocator);
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)path.getType()));
    }

    private DictionaryValuesWriter dictionaryWriter(ColumnDescriptor path, int initialSizePerCol) {
        Encoding encodingForDictionaryPage;
        Encoding encodingForDataPage;
        switch (this.writerVersion) {
            case PARQUET_1_0: {
                encodingForDataPage = Encoding.PLAIN_DICTIONARY;
                encodingForDictionaryPage = Encoding.PLAIN_DICTIONARY;
                break;
            }
            case PARQUET_2_0: {
                encodingForDataPage = Encoding.RLE_DICTIONARY;
                encodingForDictionaryPage = Encoding.PLAIN;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown version: " + (Object)((Object)this.writerVersion));
            }
        }
        switch (path.getType()) {
            case BOOLEAN: {
                throw new IllegalArgumentException("no dictionary encoding for BOOLEAN");
            }
            case BINARY: {
                return new DictionaryValuesWriter.PlainBinaryDictionaryValuesWriter(this.dictionaryPageSizeThreshold, encodingForDataPage, encodingForDictionaryPage, this.allocator);
            }
            case INT32: {
                return new DictionaryValuesWriter.PlainIntegerDictionaryValuesWriter(this.dictionaryPageSizeThreshold, encodingForDataPage, encodingForDictionaryPage, this.allocator);
            }
            case INT64: {
                return new DictionaryValuesWriter.PlainLongDictionaryValuesWriter(this.dictionaryPageSizeThreshold, encodingForDataPage, encodingForDictionaryPage, this.allocator);
            }
            case INT96: {
                return new DictionaryValuesWriter.PlainFixedLenArrayDictionaryValuesWriter(this.dictionaryPageSizeThreshold, 12, encodingForDataPage, encodingForDictionaryPage, this.allocator);
            }
            case DOUBLE: {
                return new DictionaryValuesWriter.PlainDoubleDictionaryValuesWriter(this.dictionaryPageSizeThreshold, encodingForDataPage, encodingForDictionaryPage, this.allocator);
            }
            case FLOAT: {
                return new DictionaryValuesWriter.PlainFloatDictionaryValuesWriter(this.dictionaryPageSizeThreshold, encodingForDataPage, encodingForDictionaryPage, this.allocator);
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return new DictionaryValuesWriter.PlainFixedLenArrayDictionaryValuesWriter(this.dictionaryPageSizeThreshold, path.getTypeLength(), encodingForDataPage, encodingForDictionaryPage, this.allocator);
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)path.getType()));
    }

    private ValuesWriter writerToFallbackTo(ColumnDescriptor path, int initialSizePerCol) {
        switch (this.writerVersion) {
            case PARQUET_1_0: {
                return this.plainWriter(path, initialSizePerCol);
            }
            case PARQUET_2_0: {
                switch (path.getType()) {
                    case BOOLEAN: {
                        return new RunLengthBitPackingHybridValuesWriter(1, initialSizePerCol, this.allocator);
                    }
                    case FIXED_LEN_BYTE_ARRAY: 
                    case BINARY: {
                        return new DeltaByteArrayWriter(initialSizePerCol, this.allocator);
                    }
                    case INT32: {
                        return new DeltaBinaryPackingValuesWriter(initialSizePerCol, this.allocator);
                    }
                    case INT96: 
                    case INT64: 
                    case DOUBLE: 
                    case FLOAT: {
                        return this.plainWriter(path, initialSizePerCol);
                    }
                }
                throw new IllegalArgumentException("Unknown type " + (Object)((Object)path.getType()));
            }
        }
        throw new IllegalArgumentException("Unknown version: " + (Object)((Object)this.writerVersion));
    }

    private ValuesWriter dictWriterWithFallBack(ColumnDescriptor path, int initialSizePerCol) {
        ValuesWriter writerToFallBackTo = this.writerToFallbackTo(path, initialSizePerCol);
        if (this.enableDictionary) {
            return FallbackValuesWriter.of(this.dictionaryWriter(path, initialSizePerCol), writerToFallBackTo);
        }
        return writerToFallBackTo;
    }

    public ValuesWriter getValuesWriter(ColumnDescriptor path, int initialSizePerCol) {
        switch (path.getType()) {
            case BOOLEAN: {
                return this.writerToFallbackTo(path, initialSizePerCol);
            }
            case FIXED_LEN_BYTE_ARRAY: {
                if (this.writerVersion == WriterVersion.PARQUET_2_0) {
                    return this.dictWriterWithFallBack(path, initialSizePerCol);
                }
                return this.writerToFallbackTo(path, initialSizePerCol);
            }
            case INT96: 
            case BINARY: 
            case INT32: 
            case INT64: 
            case DOUBLE: 
            case FLOAT: {
                return this.dictWriterWithFallBack(path, initialSizePerCol);
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)path.getType()));
    }

    public int getDictionaryPageSizeThreshold() {
        return this.dictionaryPageSizeThreshold;
    }

    public WriterVersion getWriterVersion() {
        return this.writerVersion;
    }

    public boolean isEnableDictionary() {
        return this.enableDictionary;
    }

    public ColumnWriteStore newColumnWriteStore(MessageType schema, PageWriteStore pageStore, int pageSize, int initialPageBufferSize) {
        switch (this.writerVersion) {
            case PARQUET_1_0: {
                return new ColumnWriteStoreV1(pageStore, pageSize, initialPageBufferSize, this.dictionaryPageSizeThreshold, this.enableDictionary, this.writerVersion);
            }
            case PARQUET_2_0: {
                return new ColumnWriteStoreV2(schema, pageStore, pageSize, initialPageBufferSize, new ParquetProperties(this.dictionaryPageSizeThreshold, this.writerVersion, this.enableDictionary));
            }
        }
        throw new IllegalArgumentException("unknown version " + (Object)((Object)this.writerVersion));
    }

    public static enum WriterVersion {
        PARQUET_1_0("v1"),
        PARQUET_2_0("v2");

        private final String shortName;

        private WriterVersion(String shortname) {
            this.shortName = shortname;
        }

        public static WriterVersion fromString(String name) {
            for (WriterVersion v : WriterVersion.values()) {
                if (!v.shortName.equals(name)) continue;
                return v;
            }
            return WriterVersion.valueOf(name);
        }
    }
}

