/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.commons.compiler.jdk;

import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.Cookable;
import org.codehaus.commons.compiler.ErrorHandler;
import org.codehaus.commons.compiler.ISimpleCompiler;
import org.codehaus.commons.compiler.Location;
import org.codehaus.commons.compiler.WarningHandler;
import org.codehaus.commons.compiler.jdk.ByteArrayJavaFileManager;
import org.codehaus.commons.compiler.jdk.JavaFileManagerClassLoader;

public class SimpleCompiler
extends Cookable
implements ISimpleCompiler {
    private ClassLoader parentClassLoader = Thread.currentThread().getContextClassLoader();
    private ClassLoader result;
    private boolean debugSource;
    private boolean debugLines;
    private boolean debugVars;
    private ErrorHandler optionalCompileErrorHandler;
    private WarningHandler optionalWarningHandler;

    public ClassLoader getClassLoader() {
        this.assertCooked();
        return this.result;
    }

    public void cook(String optionalFileName, final Reader r) throws CompileException, IOException {
        URI uri;
        this.assertNotCooked();
        try {
            uri = new URI("simplecompiler");
        }
        catch (URISyntaxException use) {
            throw new RuntimeException(use);
        }
        SimpleJavaFileObject compilationUnit = new SimpleJavaFileObject(uri, JavaFileObject.Kind.SOURCE){

            @Override
            public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
                return true;
            }

            @Override
            public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
                return r;
            }

            @Override
            public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
                return Cookable.readString((Reader)this.openReader(ignoreEncodingErrors));
            }

            @Override
            public String toString() {
                return String.valueOf(this.uri);
            }
        };
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            throw new CompileException("JDK Java compiler not available - probably you're running a JRE, not a JDK", null);
        }
        StandardJavaFileManager fm = compiler.getStandardFileManager(null, null, null);
        final ByteArrayJavaFileManager<StandardJavaFileManager> fileManager = new ByteArrayJavaFileManager<StandardJavaFileManager>(fm);
        try {
            final CompileException[] caughtCompileException = new CompileException[1];
            if (!compiler.getTask(null, fileManager, (DiagnosticListener<? super JavaFileObject>)new DiagnosticListener<JavaFileObject>(){

                @Override
                public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                    block7: {
                        Location loc = new Location(null, (short)diagnostic.getLineNumber(), (short)diagnostic.getColumnNumber());
                        String message = diagnostic.getMessage(null) + " (" + diagnostic.getCode() + ")";
                        try {
                            switch (diagnostic.getKind()) {
                                case ERROR: {
                                    if (SimpleCompiler.this.optionalCompileErrorHandler == null) {
                                        throw new CompileException(message, loc);
                                    }
                                    SimpleCompiler.this.optionalCompileErrorHandler.handleError(message, loc);
                                    break;
                                }
                                case MANDATORY_WARNING: 
                                case WARNING: {
                                    if (SimpleCompiler.this.optionalWarningHandler == null) break;
                                    SimpleCompiler.this.optionalWarningHandler.handleWarning(null, message, loc);
                                    break;
                                }
                            }
                        }
                        catch (CompileException ce) {
                            if (caughtCompileException[0] != null) break block7;
                            caughtCompileException[0] = ce;
                        }
                    }
                }
            }, Collections.singletonList(this.debugSource ? "-g:source" + (this.debugLines ? ",lines" : "") + (this.debugVars ? ",vars" : "") : (this.debugLines ? "-g:lines" + (this.debugVars ? ",vars" : "") : (this.debugVars ? "-g:vars" : "-g:none"))), null, Collections.singleton(compilationUnit)).call().booleanValue()) {
                if (caughtCompileException[0] != null) {
                    throw caughtCompileException[0];
                }
                throw new CompileException("Compilation failed", null);
            }
        }
        catch (RuntimeException rte) {
            for (Throwable t = rte.getCause(); t != null; t = t.getCause()) {
                if (t instanceof CompileException) {
                    throw (CompileException)t;
                }
                if (!(t instanceof IOException)) continue;
                throw (IOException)t;
            }
            throw rte;
        }
        this.result = AccessController.doPrivileged(new PrivilegedAction<JavaFileManagerClassLoader>(){

            @Override
            public JavaFileManagerClassLoader run() {
                return new JavaFileManagerClassLoader(fileManager, SimpleCompiler.this.parentClassLoader);
            }
        });
    }

    public void setDebuggingInformation(boolean debugSource, boolean debugLines, boolean debugVars) {
        this.debugSource = debugSource;
        this.debugLines = debugLines;
        this.debugVars = debugVars;
    }

    public void setParentClassLoader(ClassLoader optionalParentClassLoader) {
        this.assertNotCooked();
        this.parentClassLoader = optionalParentClassLoader != null ? optionalParentClassLoader : Thread.currentThread().getContextClassLoader();
    }

    @Deprecated
    public void setParentClassLoader(ClassLoader optionalParentClassLoader, Class<?>[] auxiliaryClasses) {
        this.setParentClassLoader(optionalParentClassLoader);
    }

    public void setCompileErrorHandler(ErrorHandler optionalCompileErrorHandler) {
        this.optionalCompileErrorHandler = optionalCompileErrorHandler;
    }

    public void setWarningHandler(WarningHandler optionalWarningHandler) {
        this.optionalWarningHandler = optionalWarningHandler;
    }

    protected void assertCooked() {
        if (this.result == null) {
            throw new IllegalStateException("Not yet cooked");
        }
    }

    protected void assertNotCooked() {
        if (this.result != null) {
            throw new IllegalStateException("Already cooked");
        }
    }
}

