/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gis;

import org.apache.drill.BaseTestQuery;
import org.junit.Test;

public class TestGeometryFunctions
extends BaseTestQuery {
    String wktPoint = "POINT (-121.895 37.339)";

    @Test
    public void testGeometryFromTextCreation() throws Exception {
        TestGeometryFunctions.testBuilder().sqlQuery("select ST_AsText(ST_GeomFromText('" + this.wktPoint + "')) " + "from cp.`/sample-data/CA-cities.csv` limit 1").ordered().baselineColumns(new String[]{"EXPR$0"}).baselineValues(new Object[]{this.wktPoint}).build().run();
    }

    @Test
    public void testGeometryPointCreation() throws Exception {
        TestGeometryFunctions.testBuilder().sqlQuery("select ST_AsText(ST_Point(-121.895, 37.339)) from cp.`/sample-data/CA-cities.csv` limit 1").ordered().baselineColumns(new String[]{"EXPR$0"}).baselineValues(new Object[]{this.wktPoint}).build().run();
    }

    @Test
    public void testSTWithinQuery() throws Exception {
        TestGeometryFunctions.testBuilder().sqlQuery("select ST_Within(ST_Point(columns[4], columns[3]),ST_GeomFromText('POLYGON((-121.95 37.28, -121.94 37.35, -121.84 37.35, -121.84 37.28, -121.95 37.28))')) from cp.`/sample-data/CA-cities.csv` where columns[2] = 'San Jose'").ordered().baselineColumns(new String[]{"EXPR$0"}).baselineValues(new Object[]{true}).build().run();
        TestGeometryFunctions.testBuilder().sqlQuery("select ST_Within(ST_Point(columns[4], columns[3]),ST_GeomFromText('POLYGON((-121.95 37.28, -121.94 37.35, -121.84 37.35, -121.84 37.28, -121.95 37.28))')) from cp.`/sample-data/CA-cities.csv` where columns[2] = 'San Francisco'").ordered().baselineColumns(new String[]{"EXPR$0"}).baselineValues(new Object[]{false}).build().run();
    }
}

