/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.log4j;

import com.mapr.log4j.CentralTaskLogAppender;
import java.io.File;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.log4j.helpers.LogLog;

public class MR1CentralTaskLogAppender
extends CentralTaskLogAppender
implements TaskLog.LogdirSwitchable {
    private static final String LOGSIZE_PROPERTY = "hadoop.tasklog.totalLogFileSize";

    @Override
    protected String getFrameworkType() {
        return "mapred";
    }

    public synchronized void switchLogdir(String dirname) {
        super.setFile(new File(dirname, TaskLog.LogName.SYSLOG.toString()).toString());
        super.activateOptions();
    }

    public TaskLog.LogName getLogname() {
        return TaskLog.LogName.SYSLOG;
    }

    @Override
    protected synchronized Long getFileSizeLimit() {
        try {
            String propValue = System.getProperty(LOGSIZE_PROPERTY, "100");
            return Long.parseLong(propValue);
        }
        catch (NumberFormatException e) {
            LogLog.error((String)"Log size property should be a number", (Throwable)e);
            return null;
        }
    }
}

