/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.log4j;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.PatternConverter;
import org.apache.log4j.spi.LoggingEvent;

public class PatternLayoutByLevelWithHeader
extends PatternLayout {
    private Map<Level, PatternConverter> logLevelConverterMap = new HashMap<Level, PatternConverter>();
    private StringBuffer sbuf = new StringBuffer(256);

    public PatternLayoutByLevelWithHeader() {
    }

    public PatternLayoutByLevelWithHeader(String conversionPattern) {
        super(conversionPattern);
    }

    public void setConversionPattern(String conversionPattern) {
        super.setConversionPattern(conversionPattern);
    }

    public void setDebugPattern(String pattern) {
        this.logLevelConverterMap.put(Level.DEBUG, this.createPatternParser(pattern).parse());
    }

    public void setInfoPattern(String pattern) {
        this.logLevelConverterMap.put(Level.INFO, this.createPatternParser(pattern).parse());
    }

    public void setWarnPattern(String pattern) {
        this.logLevelConverterMap.put(Level.WARN, this.createPatternParser(pattern).parse());
    }

    public void setErrorPattern(String pattern) {
        this.logLevelConverterMap.put(Level.ERROR, this.createPatternParser(pattern).parse());
    }

    public void setFatalPattern(String pattern) {
        this.logLevelConverterMap.put(Level.FATAL, this.createPatternParser(pattern).parse());
    }

    public String format(LoggingEvent event) {
        if (this.logLevelConverterMap.containsKey(event.getLevel())) {
            if (this.sbuf.capacity() > 1024) {
                this.sbuf = new StringBuffer(256);
            } else {
                this.sbuf.setLength(0);
            }
            PatternConverter c = this.logLevelConverterMap.get(event.getLevel());
            while (c != null) {
                c.format(this.sbuf, event);
                c = c.next;
            }
            return this.sbuf.toString();
        }
        return super.format(event);
    }

    public String getHeader() {
        return this.getApplicationInfo("Header: ");
    }

    public String getFooter() {
        return this.getApplicationInfo("Footer: ");
    }

    private String getApplicationInfo(String prefix) {
        StringBuilder sb = new StringBuilder(prefix);
        try {
            InetAddress addr = InetAddress.getLocalHost();
            String hostName = addr.getCanonicalHostName();
            sb.append("hostName: " + hostName);
        }
        catch (UnknownHostException e) {
            LogLog.error((String)"Host Info cannot be found", (Throwable)e);
        }
        sb.append(", Time Zone: ");
        sb.append(Calendar.getInstance().getTimeZone().getDisplayName());
        String processName = System.getProperty("pname");
        sb.append(", processName: " + processName);
        String pid = System.getProperty("pid");
        sb.append(", processId: " + pid);
        String maprHomeDir = System.getProperty("mapr.home.dir");
        if (maprHomeDir != null) {
            try {
                File maprVersion = new File(maprHomeDir + "/MapRBuildVersion");
                if (maprVersion.isFile()) {
                    BufferedReader fis = new BufferedReader(new FileReader(maprVersion));
                    String buildVersion = fis.readLine();
                    sb.append(", MapR Build Version: " + buildVersion);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        sb.append('\n');
        return sb.toString();
    }
}

