/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.cldbutils;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.BaseUtilsHelper;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtilsException;
import com.mapr.fs.Rpc;
import com.mapr.fs.ShimLoader;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import com.mapr.login.client.MapRLoginHttpsClient;
import com.mapr.security.JNISecurity;
import com.mapr.security.MaprSecurityException;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class CLDBRpcCommonUtils {
    private static final Logger LOG = Logger.getLogger(CLDBRpcCommonUtils.class);
    private static final String MAPR_CLUSTER_FILE_NAME = "/conf/mapr-clusters.conf";
    private static final String MAPR_SERVER_TICKET_FILE_NAME = "/conf/maprserverticket";
    private static final int CLDB_PORT_DEFAULT = 7222;
    private static final String CLDB_LOCAL_HOST = "127.0.0.1";
    static Pattern patternIP = Pattern.compile("[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}");
    private Map<String, List<IpPort>> clustersMap = new ConcurrentHashMap<String, List<IpPort>>();
    private static CLDBRpcCommonUtils s_instance;
    private volatile String defaultClusterName = "default";
    private String origClusterName;
    private Map<String, String> zkConnectStringMap = new HashMap<String, String>();

    private CLDBRpcCommonUtils() {
        this.init();
    }

    public static CLDBRpcCommonUtils getInstance() {
        return s_instance;
    }

    public synchronized String getZkConnect() {
        if (this.defaultClusterName == null) {
            LOG.error((Object)"Default cluster name is null. Can not get ZK string");
            return null;
        }
        return this.getZkConnect(this.defaultClusterName);
    }

    public synchronized String getZkConnect(String clusterName) {
        if (clusterName == null || !this.clustersMap.containsKey(clusterName)) {
            LOG.error((Object)("Invalid cluster name specified: " + clusterName));
            return null;
        }
        String zkConnectString = this.zkConnectStringMap.get(clusterName);
        if (zkConnectString != null) {
            return zkConnectString;
        }
        try {
            byte[] responseData = this.sendRequest(clusterName, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.IsCLDBMasterProc.getNumber(), (MessageLite)CLDBProto.isCLDBMasterRequest.newBuilder().build(), CLDBProto.isCLDBMasterResponse.class);
            if (responseData == null) {
                LOG.error((Object)"No data is received from any cldb");
                return null;
            }
            try {
                CLDBProto.isCLDBMasterResponse response = CLDBProto.isCLDBMasterResponse.parseFrom((byte[])responseData);
                if (response.getStatus() != 0) {
                    LOG.error((Object)("Non-valid status received from isCLDBMasterResponse: " + Errno.toString(response.getStatus())));
                }
                zkConnectString = response.getZkconnect();
                this.zkConnectStringMap.put(clusterName, zkConnectString);
                LOG.info((Object)("ZKConnect: " + zkConnectString));
                return zkConnectString;
            }
            catch (InvalidProtocolBufferException e) {
                LOG.error((Object)"Exception while parsing response from isCLDBMasterResponse", (Throwable)e);
                return null;
            }
        }
        catch (Throwable t) {
            LOG.error((Object)"Exception while trying to send RPC to CLDB", t);
            return null;
        }
    }

    public synchronized void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"init");
        }
        String tempClusterName = null;
        HashMap tempMap = new HashMap();
        String maprHome = BaseUtilsHelper.getPathToMaprHome();
        String clusterConfFile = maprHome + MAPR_CLUSTER_FILE_NAME;
        try {
            String strLine;
            BufferedReader bfr = new BufferedReader(new FileReader(clusterConfFile));
            while ((strLine = bfr.readLine()) != null) {
                String[] tokens;
                if (strLine.matches("^\\s*#.*") || (tokens = strLine.split("[\\s]+")).length < 2) continue;
                String clusterName = tokens[0];
                ArrayList<IpPort> ipList = new ArrayList<IpPort>();
                for (int i = 1; i < tokens.length; ++i) {
                    if (tokens[i].contains("=")) {
                        String[] arr = tokens[i].split("=");
                        if (arr.length == 2 && JNISecurity.SetClusterOption(clusterName, arr[0], arr[1]) == 0) continue;
                        LOG.error((Object)("Invalid Conf options:" + tokens[i] + " for cluster " + clusterName));
                        continue;
                    }
                    String[] cldbIps = tokens[i].split(";");
                    IpPort ipPort = new IpPort();
                    for (int j = 0; j < cldbIps.length; ++j) {
                        int port = 7222;
                        String[] arr = cldbIps[j].split(":");
                        String host = arr[0];
                        int index = host.indexOf(44);
                        if (index != -1) {
                            host = index < host.length() - 1 ? host.substring(index + 1) : host.substring(0, index);
                        }
                        if (arr.length >= 2) {
                            try {
                                port = Integer.valueOf(arr[1]);
                            }
                            catch (NumberFormatException nfe) {
                                LOG.error((Object)("Port is not Integer: " + arr[1] + ". Using default CLDB port: " + 7222));
                            }
                            if (port < 0 || port > 65535) {
                                LOG.error((Object)("Port is invalid number: " + port + ". Skipping " + cldbIps[j]));
                                continue;
                            }
                        }
                        ipPort.addIPOrHost(host, port);
                    }
                    if (ipPort.getNumIPs() <= 0) continue;
                    ipList.add(ipPort);
                }
                if (ipList.isEmpty()) {
                    LOG.error((Object)("No CLDBs defined for cluster: " + clusterName));
                    continue;
                }
                tempMap.put(clusterName, ipList);
                if (tempClusterName != null) continue;
                this.defaultClusterName = clusterName;
                tempClusterName = clusterName;
            }
            this.clustersMap.putAll(tempMap);
            for (Map.Entry<String, List<IpPort>> entry : this.clustersMap.entrySet()) {
                if (tempMap.containsKey(entry.getKey())) continue;
                this.clustersMap.remove(entry.getKey());
            }
        }
        catch (FileNotFoundException fex) {
        }
        catch (Throwable t) {
            LOG.error((Object)"Exception during init", t);
        }
        JNISecurity.SetParsingDone();
        if (this.clustersMap.size() == 0) {
            this.defaultClusterName = "default";
            ArrayList<IpPort> ipList = new ArrayList<IpPort>();
            IpPort ipPort = new IpPort();
            ipPort.addIPOrHost(CLDB_LOCAL_HOST, 7222);
            ipList.add(ipPort);
            this.clustersMap.put(this.defaultClusterName, ipList);
        }
    }

    public static int ipToInt(String addr) {
        if (addr.equals("localhost")) {
            addr = CLDB_LOCAL_HOST;
        }
        String[] addrArray = addr.split("\\.");
        long num = 0L;
        for (int i = 0; i < addrArray.length; ++i) {
            int power = 3 - i;
            num = (long)((double)num + (double)(Integer.parseInt(addrArray[i]) % 256) * Math.pow(256.0, power));
        }
        return (int)num;
    }

    private long init(int cldbPort, List<String> cldbHostString, String clusterName, Security.ServerKeyType keyType, int srcPort) throws CLDBRpcCommonUtilsException {
        MutableInt mutableerr;
        Security.TicketAndKey ticket;
        if (cldbHostString == null || cldbHostString.size() == 0) {
            return 0L;
        }
        int[] cldbIps = new int[cldbHostString.size()];
        int idx = 0;
        for (String cldbIp : cldbHostString) {
            cldbIps[idx] = CLDBRpcCommonUtils.ipToInt(cldbIp);
            ++idx;
        }
        try {
            int port = Rpc.initialize(0, 0, clusterName);
            if (port < 0) {
                throw new IOException("Error in RPC init");
            }
        }
        catch (Exception e) {
            throw new CLDBRpcCommonUtilsException("Exception in Rpc.initialize " + e);
        }
        if (JNISecurity.IsSecurityEnabled(clusterName) && (ticket = Security.GetTicketAndKeyForCluster(keyType, clusterName, mutableerr = new MutableInt())) == null) {
            int err = Security.SetTicketAndKeyFile(this.getPathToServerTicketFile());
            if (err != 0) {
                LOG.error((Object)("Error " + err + " in loading " + this.getPathToServerTicketFile()));
            }
            ticket = Security.GetTicketAndKeyForCluster(keyType, clusterName, mutableerr);
        }
        long binding = srcPort > 0 ? Rpc.createBindingForIpsWithSrcPort(cldbIps, cldbPort, srcPort, clusterName, keyType.getNumber()) : Rpc.createBindingForIps(cldbIps, cldbPort, clusterName, keyType.getNumber());
        return binding;
    }

    public byte[] sendRequest(int programId, int procedureId, MessageLite request, Class<? extends MessageLite> responseClass) throws Exception {
        return this.sendRequest(this.defaultClusterName, programId, procedureId, request, responseClass, Security.ServerKeyType.ServerKey);
    }

    public byte[] sendRequest(String clusterName, int programId, int procedureId, MessageLite request, Class<? extends MessageLite> responseClass) throws Exception {
        return this.sendRequest(clusterName, programId, procedureId, request, responseClass, Security.ServerKeyType.ServerKey);
    }

    public byte[] sendRequest(String clusterName, int programId, int procedureId, MessageLite request, Class<? extends MessageLite> responseClass, Security.ServerKeyType keyType) throws Exception {
        return this.sendRequest(clusterName, programId, procedureId, request, responseClass, keyType, 0);
    }

    public byte[] sendRequest(String clusterName, int programId, int procedureId, MessageLite request, Class<? extends MessageLite> responseClass, Security.ServerKeyType keyType, int srcPort) throws Exception {
        if (this.clustersMap.get(clusterName) == null) {
            this.init();
            if (this.clustersMap.get(clusterName) == null) {
                try {
                    Method newBuilder = responseClass.getMethod("newBuilder", new Class[0]);
                    Object returnObject = newBuilder.invoke(null, new Object[0]);
                    Method statusMethod = returnObject.getClass().getMethod("setStatus", Integer.TYPE);
                    returnObject = statusMethod.invoke(returnObject, 133);
                    Method build = returnObject.getClass().getMethod("build", new Class[0]);
                    MessageLite buildObject = (MessageLite)build.invoke(returnObject, new Object[0]);
                    byte[] bytes = buildObject.toByteArray();
                    LOG.error((Object)("Unable to reach cluster with name: " + clusterName + ". No entry found in file " + MAPR_CLUSTER_FILE_NAME + " for cluster " + clusterName + ". Failing the CLDB RPC with status " + 133));
                    return bytes;
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while trying to construct erroneous response", (Throwable)e);
                    LOG.error((Object)("Cluster with name: " + clusterName + " is not found. Can not proceed with CLDB RPC"));
                    return null;
                }
            }
        }
        if (this.clustersMap.get(clusterName).isEmpty()) {
            this.init();
        }
        ArrayList clusterCredentials = new ArrayList(this.clustersMap.get(clusterName));
        int origSize = clusterCredentials.size();
        Iterator iter = clusterCredentials.iterator();
        while (iter.hasNext()) {
            IpPort cldbCredentials = (IpPort)iter.next();
            byte[] retBytes = this.getDataForParticularCLDB(clusterName, cldbCredentials, programId, procedureId, request, responseClass, keyType, srcPort);
            if (retBytes != null) {
                if (clusterCredentials.size() != origSize) {
                    this.clustersMap.put(clusterName, clusterCredentials);
                }
                return retBytes;
            }
            iter.remove();
            LOG.info((Object)("Bad CLDB credentials removed: " + cldbCredentials));
        }
        this.clustersMap.put(clusterName, clusterCredentials);
        return null;
    }

    public boolean isValidClusterName(String clusterName) {
        if (this.clustersMap.get(clusterName) != null) {
            return true;
        }
        this.init();
        if (this.clustersMap.get(clusterName) != null) {
            return true;
        }
        LOG.error((Object)("Cluster with name: " + clusterName + " not found"));
        return false;
    }

    public String getPathToClustersConfFile() {
        String maprHome = BaseUtilsHelper.getPathToMaprHome();
        return maprHome + MAPR_CLUSTER_FILE_NAME;
    }

    public String getPathToServerTicketFile() {
        String maprHome = BaseUtilsHelper.getPathToMaprHome();
        return maprHome + MAPR_SERVER_TICKET_FILE_NAME;
    }

    private byte[] getDataForParticularCLDB(String clusterName, IpPort cldbCredentials, int programId, int procedureId, MessageLite request, Class<? extends MessageLite> responseClass, Security.ServerKeyType keyType, int srcPort) throws Exception {
        try {
            byte[] retBytes;
            MapRLoginHttpsClient loginClient = new MapRLoginHttpsClient();
            loginClient.quietAuthenticateIfNeeded(clusterName);
            long binding = this.init(cldbCredentials.getPort(), cldbCredentials.getAddr(), clusterName, keyType, srcPort);
            if (binding == 0L) {
                return null;
            }
            Method parseFromMethod = responseClass.getMethod("parseFrom", ByteString.class);
            int MAX_ATTEMPTS = 6;
            int nAttempt = 0;
            Integer status = 0;
            do {
                if ((retBytes = Rpc.sendRequest(binding, programId, procedureId, request)) != null) {
                    Object returnObject = parseFromMethod.invoke(null, ByteString.copyFrom((byte[])retBytes));
                    Method statusMethod = returnObject.getClass().getMethod("getStatus", new Class[0]);
                    status = (Integer)statusMethod.invoke(returnObject, new Object[0]);
                    if (status == null) {
                        LOG.error((Object)("Return Status is not Integer: " + status));
                        continue;
                    }
                    if (status == 30) {
                        LOG.error((Object)(cldbCredentials.toString() + " is READ_ONLY CLDB. Trying another one"));
                        continue;
                    }
                    if (status == 3) {
                        if (++nAttempt == 1) {
                            LOG.error((Object)(cldbCredentials.toString() + " is attempting to become a master. Retrying !"));
                        }
                        if (nAttempt >= 6) continue;
                        Thread.sleep((2 * nAttempt + 1) * 1000);
                        continue;
                    }
                    return retBytes;
                }
                LOG.error((Object)("No data returned in RPC: " + cldbCredentials.toString() + ". Continue searching for correct CLDB"));
            } while (retBytes != null && status == 3 && nAttempt < 6);
        }
        catch (CLDBRpcCommonUtilsException e) {
            LOG.error((Object)("Exception while trying to bind on: " + cldbCredentials.toString()));
        }
        catch (MaprSecurityException se) {
            LOG.error((Object)se);
            throw se;
        }
        catch (Exception ex) {
            LOG.error((Object)("Exception while trying to send RPC to CLDB: " + cldbCredentials.toString() + ". Trying another host/port"), (Throwable)ex);
        }
        return null;
    }

    public synchronized IpPort getCurrentValidIpPort(String clusterName) {
        if (this.clustersMap.get(clusterName) != null && this.clustersMap.containsKey(clusterName)) {
            return this.clustersMap.get(clusterName).get(0);
        }
        return null;
    }

    public IpPort getCurrentValidIpPort() {
        return this.getCurrentValidIpPort(this.defaultClusterName);
    }

    public String getCurrentClusterName() {
        return this.defaultClusterName;
    }

    public synchronized void setCurrentClusterName(String clusterName) {
        if (!this.clustersMap.containsKey(clusterName)) {
            throw new IllegalArgumentException("Cluster " + clusterName + " is not known");
        }
        if (this.origClusterName == null) {
            this.origClusterName = this.defaultClusterName;
        }
        this.defaultClusterName = clusterName;
    }

    public synchronized void resetCurrentClusterName() {
        if (this.origClusterName != null) {
            this.defaultClusterName = this.origClusterName;
        }
    }

    public Map<String, List<IpPort>> getClusterMap() {
        return this.clustersMap;
    }

    public List<IpPort> getDefaultClusterIpPort() {
        return this.clustersMap.get(this.defaultClusterName);
    }

    public static String convertHostToIp(String host) {
        try {
            InetAddress ia = InetAddress.getByName(host);
            String ip = ia.getHostAddress();
            return ip;
        }
        catch (UnknownHostException e) {
            LOG.error((Object)("Can not find IP for host: " + host), (Throwable)e);
            return null;
        }
    }

    public synchronized long[] getCldbBindings(String clusterName) throws CLDBRpcCommonUtilsException {
        List<IpPort> ipPorts = this.clustersMap.get(clusterName);
        if (ipPorts == null || ipPorts.isEmpty()) {
            this.init();
        }
        if ((ipPorts = this.clustersMap.get(clusterName)) == null || ipPorts.isEmpty()) {
            LOG.error((Object)("Unable to get CLDB bindings for cluster " + clusterName));
            return null;
        }
        long[] cldbBindings = new long[ipPorts.size()];
        Iterator<IpPort> itr = ipPorts.iterator();
        int index = 0;
        while (itr.hasNext()) {
            IpPort ipPort = itr.next();
            cldbBindings[index++] = this.init(ipPort.getPort(), ipPort.getAddr(), clusterName, Security.ServerKeyType.ServerKey, 0);
        }
        return cldbBindings;
    }

    static {
        ShimLoader.load();
        s_instance = new CLDBRpcCommonUtils();
    }

    public static class IpPort {
        private List<String> ips = new ArrayList<String>();
        private List<String> originalAddr = new ArrayList<String>();
        private int port = 7222;

        public void addIPOrHost(String addr, int port) {
            String ip = addr;
            if (!patternIP.matcher(addr).matches() && (ip = CLDBRpcCommonUtils.convertHostToIp(addr)) == null) {
                LOG.error((Object)("Can not find non-local IP based on provided hostname: " + addr));
            }
            if (ip != null) {
                this.ips.add(ip);
                this.originalAddr.add(addr);
                this.port = port;
            }
        }

        public int getNumIPs() {
            return this.ips.size();
        }

        public List<String> getAddr() {
            return this.ips;
        }

        public List<String> getOriginalAddr() {
            return this.originalAddr;
        }

        public int getPort() {
            return this.port;
        }

        public String toString() {
            String ipStr = "";
            for (String ip : this.ips) {
                ipStr = ipStr + ip + "-";
            }
            return "CLDB Ips: " + ipStr + ", Port: " + this.port;
        }
    }
}

