/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class LogDirectoryFindingUtils {
    private static final Logger LOG = Logger.getLogger(LogDirectoryFindingUtils.class);
    private static final String hadoopVersionFile = "/conf/hadoop_version";

    private static String getHadoopVersion(String maprHome, String version) {
        Properties hadoopVersionProp = new Properties();
        try {
            FileInputStream inputStream = new FileInputStream(maprHome + hadoopVersionFile);
            hadoopVersionProp.load(inputStream);
            ((InputStream)inputStream).close();
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)"Error while tring to get hadoop version", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)"Error while tring to get hadoop version", (Throwable)e);
        }
        String key = version == null ? hadoopVersionProp.getProperty("default_mode") : version;
        return hadoopVersionProp.getProperty(key + "_version", "");
    }

    public static String getHadoopLogsDirectory(String maprHome, String version) {
        File hadoopDir = new File(maprHome + "/hadoop");
        String currentVersion = LogDirectoryFindingUtils.getHadoopVersion(maprHome, version);
        final String currentHadoopDir = "hadoop-" + currentVersion;
        if (hadoopDir.isDirectory()) {
            File[] hadoopVersions;
            for (File hadoopVersion : hadoopVersions = hadoopDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() && pathname.getName().equals(currentHadoopDir);
                }
            })) {
                try {
                    return hadoopVersion.getCanonicalPath() + "/logs";
                }
                catch (IOException e) {
                    LOG.error((Object)"Error while tring to get path for hadoop logs dir", (Throwable)e);
                }
            }
        }
        return null;
    }

    public static String getHbaseLogsDirectory(String maprHome) {
        File hadoopDir = new File(maprHome + "/hbase");
        if (hadoopDir.isDirectory()) {
            File[] hadoopVersions;
            for (File hadoopVersion : hadoopVersions = hadoopDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() && pathname.getName().startsWith("hbase");
                }
            })) {
                try {
                    return hadoopVersion.getCanonicalPath() + "/logs";
                }
                catch (IOException e) {
                    LOG.error((Object)"Error while tring to get path for hbase logs dir", (Throwable)e);
                }
            }
        }
        return null;
    }
}

