/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.apache.log4j.Logger;

public class BaseUtilsHelper {
    private static final String MAPR_ENV_VAR = "MAPR_HOME";
    private static final String MAPR_PROPERTY_HOME = "mapr.home.dir";
    private static final String MAPR_HOME_PATH_DEFAULT = "/opt/mapr";
    private static final Logger LOG = Logger.getLogger(BaseUtilsHelper.class);
    public static String clusterId = null;

    public static synchronized String getClusterId() {
        if (clusterId != null) {
            return clusterId;
        }
        String maprHome = BaseUtilsHelper.getPathToMaprHome();
        if (maprHome != null) {
            BufferedReader fis = null;
            try {
                fis = new BufferedReader(new FileReader(maprHome + "/conf/clusterid"));
                String clusterString = fis.readLine();
                String[] clusterNames = clusterString.split("\\s");
                clusterId = clusterNames[0];
                fis.close();
            }
            catch (FileNotFoundException fne) {
                LOG.error((Object)"Exception while trying to get info from clusterid file", (Throwable)fne);
            }
            catch (IOException ioe) {
                LOG.error((Object)("Exception while trying to read file: " + maprHome + "/conf/clusterid"), (Throwable)ioe);
            }
        }
        return clusterId;
    }

    public static String getPathToMaprHome() {
        String maprHome = System.getenv(MAPR_ENV_VAR);
        if (maprHome == null && (maprHome = System.getProperty(MAPR_PROPERTY_HOME)) == null) {
            maprHome = MAPR_HOME_PATH_DEFAULT;
        }
        return maprHome;
    }
}

