/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.cldbutils;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtilsException;
import com.mapr.fs.Rpc;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class CLDBRpcCommonUtils {
    private static final Logger LOG = Logger.getLogger(CLDBRpcCommonUtils.class);
    private static final String MAPR_CLUSTER_FILE_PATH_DEFAULT = "/opt/mapr";
    private static final String MAPR_CLUSTER_FILE_NAME = "/conf/mapr-clusters.conf";
    private static final int CLDB_PORT_DEFAULT = 7222;
    private static final String CLDB_LOCAL_HOST = "127.0.0.1";
    public static final String MAPR_ENV_VAR = "MAPR_HOME";
    public static final String MAPR_PROPERTY_HOME = "mapr.home.dir";
    static Pattern patternIP = Pattern.compile("[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}");
    private Map<String, List<IpPort>> clustersMap = new ConcurrentHashMap<String, List<IpPort>>();
    private static CLDBRpcCommonUtils s_instance = new CLDBRpcCommonUtils();
    private volatile String defaultClusterName = null;
    private Map<String, String> zkConnectStringMap = new HashMap<String, String>();

    private CLDBRpcCommonUtils() {
        this.init();
    }

    public static CLDBRpcCommonUtils getInstance() {
        return s_instance;
    }

    public synchronized String getZkConnect() {
        if (this.defaultClusterName == null) {
            LOG.error((Object)"Default cluster name is null. Can not get ZK string");
            return null;
        }
        return this.getZkConnect(this.defaultClusterName);
    }

    public synchronized String getZkConnect(String clusterName) {
        if (clusterName == null || !this.clustersMap.containsKey(clusterName)) {
            LOG.error((Object)("Invalid cluster name specified: " + clusterName));
            return null;
        }
        String zkConnectString = this.zkConnectStringMap.get(clusterName);
        if (zkConnectString != null) {
            return zkConnectString;
        }
        try {
            byte[] responseData = this.sendRequest(clusterName, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.IsCLDBMasterProc.getNumber(), (MessageLite)CLDBProto.isCLDBMasterRequest.newBuilder().build(), CLDBProto.isCLDBMasterResponse.class);
            if (responseData == null) {
                LOG.error((Object)"No data is received from any cldb");
                return null;
            }
            try {
                CLDBProto.isCLDBMasterResponse response = CLDBProto.isCLDBMasterResponse.parseFrom((byte[])responseData);
                if (response.getStatus() != 0) {
                    LOG.error((Object)("Non-valid status received from isCLDBMasterResponse: " + Errno.toString(response.getStatus())));
                }
                zkConnectString = response.getZkconnect();
                this.zkConnectStringMap.put(clusterName, zkConnectString);
                LOG.info((Object)("ZKConnect: " + zkConnectString));
                return zkConnectString;
            }
            catch (InvalidProtocolBufferException e) {
                LOG.error((Object)"Exception while parsing response from isCLDBMasterResponse", (Throwable)e);
                return null;
            }
        }
        catch (Throwable t) {
            LOG.error((Object)"Exception while trying to send RPC to CLDB", t);
            return null;
        }
    }

    protected synchronized void init() {
        this.defaultClusterName = null;
        this.clustersMap.clear();
        String maprHome = System.getenv(MAPR_ENV_VAR);
        if (maprHome == null && (maprHome = System.getProperty(MAPR_PROPERTY_HOME)) == null) {
            maprHome = MAPR_CLUSTER_FILE_PATH_DEFAULT;
        }
        String clusterConfFile = maprHome + MAPR_CLUSTER_FILE_NAME;
        try {
            String strLine;
            BufferedReader bfr = new BufferedReader(new FileReader(clusterConfFile));
            while ((strLine = bfr.readLine()) != null) {
                String[] tokens;
                if (strLine.matches("^\\s*#.*") || (tokens = strLine.split("[\\s]+")).length < 2) continue;
                String clusterName = tokens[0];
                ArrayList<IpPort> ipList = new ArrayList<IpPort>();
                for (int i = 1; i < tokens.length; ++i) {
                    String[] cldbIps = tokens[i].split(";");
                    IpPort ipPort = new IpPort();
                    for (int j = 0; j < cldbIps.length; ++j) {
                        int port = 7222;
                        String[] arr = cldbIps[j].split(":");
                        String host = arr[0];
                        int index = host.indexOf(44);
                        if (index != -1) {
                            host = index < host.length() - 1 ? host.substring(index + 1) : host.substring(0, index);
                        }
                        if (arr.length >= 2) {
                            try {
                                port = Integer.valueOf(arr[1]);
                            }
                            catch (NumberFormatException nfe) {
                                LOG.error((Object)("Port is not Integer: " + arr[1] + ". Using default CLDB port: " + 7222));
                            }
                            if (port < 0 || port > 65535) {
                                LOG.error((Object)("Port is invalid number: " + port + ". Skipping " + cldbIps[j]));
                                continue;
                            }
                        }
                        ipPort.addIPOrHost(host, port);
                    }
                    if (ipPort.getNumIPs() <= 0) continue;
                    ipList.add(ipPort);
                }
                if (ipList.isEmpty()) {
                    LOG.error((Object)("No CLDBs defined for cluster: " + clusterName));
                    continue;
                }
                this.clustersMap.put(clusterName, ipList);
                if (this.defaultClusterName != null) continue;
                this.defaultClusterName = clusterName;
            }
        }
        catch (FileNotFoundException fex) {
            LOG.error((Object)("File is not found: " + clusterConfFile), (Throwable)fex);
        }
        catch (Throwable t) {
            LOG.error((Object)"Exception during init", t);
        }
        if (this.clustersMap.size() == 0) {
            this.defaultClusterName = "default";
            ArrayList<IpPort> ipList = new ArrayList<IpPort>();
            IpPort ipPort = new IpPort();
            ipPort.addIPOrHost(CLDB_LOCAL_HOST, 7222);
            ipList.add(ipPort);
            this.clustersMap.put(this.defaultClusterName, ipList);
        }
    }

    public static int ipToInt(String addr) {
        if (addr.equals("localhost")) {
            addr = CLDB_LOCAL_HOST;
        }
        String[] addrArray = addr.split("\\.");
        long num = 0L;
        for (int i = 0; i < addrArray.length; ++i) {
            int power = 3 - i;
            num = (long)((double)num + (double)(Integer.parseInt(addrArray[i]) % 256) * Math.pow(256.0, power));
        }
        return (int)num;
    }

    public long init(int cldbPort, List<String> cldbHostString) throws CLDBRpcCommonUtilsException {
        if (cldbHostString == null || cldbHostString.size() == 0) {
            return 0L;
        }
        int[] cldbIps = new int[cldbHostString.size()];
        int idx = 0;
        for (String cldbIp : cldbHostString) {
            cldbIps[idx] = CLDBRpcCommonUtils.ipToInt(cldbIp);
            ++idx;
        }
        try {
            int port = Rpc.initialize(0, 0);
            if (port < 0) {
                throw new IOException("Error in RPC init");
            }
        }
        catch (Exception e) {
            throw new CLDBRpcCommonUtilsException("Exception in Rpc.initialize " + e);
        }
        long binding = Rpc.createBindingForIps(cldbIps, cldbPort);
        return binding;
    }

    public byte[] sendRequest(String clusterName, int programId, int procedureId, MessageLite request, Class<? extends MessageLite> responseClass, boolean isHardMount) throws InterruptedException {
        byte[] resp;
        int sleepTimeMillis = 5000;
        int i = 0;
        do {
            resp = clusterName != null ? this.sendRequest(clusterName, programId, procedureId, request, responseClass) : this.sendRequest(programId, procedureId, request, responseClass);
            if (!isHardMount) {
                return resp;
            }
            if (resp != null) continue;
            if (++i > 6) {
                i = 6;
            }
            Thread.sleep(sleepTimeMillis * (1 << i));
        } while (resp == null);
        return resp;
    }

    public byte[] sendRequest(int programId, int procedureId, MessageLite request, Class<? extends MessageLite> responseClass) {
        return this.sendRequest(this.defaultClusterName, programId, procedureId, request, responseClass);
    }

    public byte[] sendRequest(String clusterName, int programId, int procedureId, MessageLite request, Class<? extends MessageLite> responseClass) {
        if (this.clustersMap.get(clusterName) == null) {
            this.init();
            if (this.clustersMap.get(clusterName) == null) {
                try {
                    Method newBuilder = responseClass.getMethod("newBuilder", new Class[0]);
                    Object returnObject = newBuilder.invoke(null, new Object[0]);
                    Method statusMethod = returnObject.getClass().getMethod("setStatus", Integer.TYPE);
                    returnObject = statusMethod.invoke(returnObject, 133);
                    Method build = returnObject.getClass().getMethod("build", new Class[0]);
                    MessageLite buildObject = (MessageLite)build.invoke(returnObject, new Object[0]);
                    byte[] bytes = buildObject.toByteArray();
                    LOG.error((Object)("Unable to reach cluster with name: " + clusterName + ". No entry found in file " + MAPR_CLUSTER_FILE_NAME + " for cluster " + clusterName + ". Failing the CLDB RPC with status " + 133));
                    return bytes;
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while trying to construct erroneous response", (Throwable)e);
                    LOG.error((Object)("Cluster with name: " + clusterName + " is not found. Can not proceed with CLDB RPC"));
                    return null;
                }
            }
        }
        if (this.clustersMap.get(clusterName).isEmpty()) {
            this.init();
        }
        ArrayList clusterCredentials = new ArrayList(this.clustersMap.get(clusterName));
        int origSize = clusterCredentials.size();
        Iterator iter = clusterCredentials.iterator();
        while (iter.hasNext()) {
            IpPort cldbCredentials = (IpPort)iter.next();
            byte[] retBytes = this.getDataForParticularCLDB(clusterName, cldbCredentials, programId, procedureId, request, responseClass);
            if (retBytes != null) {
                if (clusterCredentials.size() != origSize) {
                    this.clustersMap.put(clusterName, clusterCredentials);
                }
                return retBytes;
            }
            iter.remove();
            LOG.info((Object)("Bad CLDB credentials removed: " + cldbCredentials));
        }
        this.clustersMap.put(clusterName, clusterCredentials);
        return null;
    }

    public boolean isValidClusterName(String clusterName) {
        if (this.clustersMap.get(clusterName) != null) {
            return true;
        }
        this.init();
        if (this.clustersMap.get(clusterName) != null) {
            return true;
        }
        LOG.error((Object)("Cluster with name: " + clusterName + " not found"));
        return false;
    }

    private byte[] getDataForParticularCLDB(String clusterName, IpPort cldbCredentials, int programId, int procedureId, MessageLite request, Class<? extends MessageLite> responseClass) {
        try {
            byte[] retBytes;
            long binding = this.init(cldbCredentials.getPort(), cldbCredentials.getAddr());
            if (binding == 0L) {
                return null;
            }
            Method parseFromMethod = responseClass.getMethod("parseFrom", ByteString.class);
            int MAX_ATTEMPTS = 6;
            int nAttempt = 0;
            Integer status = 0;
            do {
                if ((retBytes = Rpc.sendRequest(binding, programId, procedureId, request)) != null) {
                    Object returnObject = parseFromMethod.invoke(null, ByteString.copyFrom((byte[])retBytes));
                    Method statusMethod = returnObject.getClass().getMethod("getStatus", new Class[0]);
                    status = (Integer)statusMethod.invoke(returnObject, new Object[0]);
                    if (status == null) {
                        LOG.error((Object)("Return Status is not Integer: " + status));
                        continue;
                    }
                    if (status == 30) {
                        LOG.error((Object)(cldbCredentials.toString() + " is READ_ONLY CLDB. Trying another one"));
                        continue;
                    }
                    if (status == 3) {
                        if (++nAttempt == 1) {
                            LOG.error((Object)(cldbCredentials.toString() + " is attempting to become a master. Retrying !"));
                        }
                        if (nAttempt >= 6) continue;
                        Thread.sleep((2 * nAttempt + 1) * 1000);
                        continue;
                    }
                    return retBytes;
                }
                LOG.error((Object)("No data returned in RPC: " + cldbCredentials.toString() + ". Continue searching for correct CLDB"));
            } while (retBytes != null && status == 3 && nAttempt < 6);
        }
        catch (CLDBRpcCommonUtilsException e) {
            LOG.error((Object)("Exception while trying to bind on: " + cldbCredentials.toString()));
        }
        catch (Exception ex) {
            LOG.error((Object)("Exception while trying to send RPC to CLDB: " + cldbCredentials.toString() + ". Trying another host/port"), (Throwable)ex);
        }
        return null;
    }

    public synchronized IpPort getCurrentValidIpPort(String clusterName) {
        if (this.clustersMap.get(clusterName) != null && this.clustersMap.containsKey(clusterName)) {
            return this.clustersMap.get(clusterName).get(0);
        }
        return null;
    }

    public IpPort getCurrentValidIpPort() {
        return this.getCurrentValidIpPort(this.defaultClusterName);
    }

    public String getCurrentClusterName() {
        return this.defaultClusterName;
    }

    public Map<String, List<IpPort>> getClusterMap() {
        return this.clustersMap;
    }

    public static String convertHostToIp(String host) {
        try {
            InetAddress ia = InetAddress.getByName(host);
            String ip = ia.getHostAddress();
            return ip;
        }
        catch (UnknownHostException e) {
            LOG.error((Object)("Can not find IP for host: " + host), (Throwable)e);
            return null;
        }
    }

    public static class IpPort {
        private List<String> ips = new ArrayList<String>();
        private int port = 7222;

        public void addIPOrHost(String addr, int port) {
            String ip = addr;
            if (!patternIP.matcher(addr).matches() && (ip = CLDBRpcCommonUtils.convertHostToIp(addr)) == null) {
                LOG.error((Object)("Can not find non-local IP based on provided hostname: " + addr));
            }
            if (ip != null) {
                this.ips.add(ip);
                this.port = port;
            }
        }

        public int getNumIPs() {
            return this.ips.size();
        }

        public List<String> getAddr() {
            return this.ips;
        }

        public int getPort() {
            return this.port;
        }

        public String toString() {
            String ipStr = "";
            for (String ip : this.ips) {
                ipStr = ipStr + ip + "-";
            }
            return "CLDB Ips: " + ipStr + ", Port: " + this.port;
        }
    }
}

