/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce.tools.impl;

import com.mapr.db.MapRDB;
import com.mapr.db.Table;
import com.mapr.db.TabletInfo;
import com.mapr.db.mapreduce.impl.DiffTableUtils;
import com.mapr.db.mapreduce.tools.impl.DiffTableComparator;
import com.mapr.db.mapreduce.tools.impl.DiffTableCounterCollector;
import com.mapr.db.mapreduce.tools.impl.DocScanner;
import com.mapr.db.mapreduce.tools.impl.FailureTracker;
import com.mapr.db.rowcol.DBDocumentImpl;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.ojai.store.QueryCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiffTableNonMR
implements FailureTracker {
    private String table1Path;
    private String table2Path;
    private String[] fields;
    private int numThreads;
    private boolean exitOnFirstMismatch;
    private boolean excludedEmbeddedFamily;
    private Path outDir;
    private FileSystem fs;
    private Configuration conf;
    private Path opsForTable1Dir;
    private Path opsForTable2Dir;
    private boolean shouldExit;
    private static final Logger logger = LoggerFactory.getLogger(DiffTableNonMR.class);

    public DiffTableNonMR(Configuration conf, String table1Path, String table2Path, String[] fields, int numThreads, boolean exitOnFirstMismatch, boolean excludedEmbeddedFamily, String outDir) throws IOException {
        this.table1Path = table1Path;
        this.table2Path = table2Path;
        this.fields = fields;
        this.numThreads = numThreads;
        this.exitOnFirstMismatch = exitOnFirstMismatch;
        this.excludedEmbeddedFamily = excludedEmbeddedFamily;
        this.outDir = new Path(outDir);
        this.conf = conf;
        this.fs = FileSystem.get((Configuration)conf);
    }

    public int runWithoutMapReduce() throws Exception {
        int i;
        int err = 0;
        Path[] outPaths = DiffTableUtils.validateAndCreateDirs((FileSystem)this.fs, (Path)this.outDir);
        if (outPaths == null) {
            err = -1;
            return err;
        }
        this.opsForTable1Dir = outPaths[0];
        this.opsForTable2Dir = outPaths[1];
        Table table1 = MapRDB.getTable((String)this.table1Path);
        TabletInfo[] tablets = table1.getTabletInfos();
        ExecutorService executor = Executors.newFixedThreadPool(this.numThreads);
        CompareThread[] threads = new CompareThread[tablets.length];
        for (i = 0; i < tablets.length; ++i) {
            Path p1 = new Path(this.opsForTable1Dir, "opsforsrc_" + i + ".diff");
            Path p2 = new Path(this.opsForTable2Dir, "opsfordst_" + i + ".diff");
            DiffTableCounterCollector c = new DiffTableCounterCollector(this.fs, p1, p2, this.conf, this);
            threads[i] = new CompareThread(tablets[i].getCondition(), c);
            executor.execute(threads[i]);
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
        for (i = 0; i < threads.length; ++i) {
            if (threads[i].completed()) continue;
            logger.error("Thread '{}' didnot finish successfully. Exiting...", (Object)i);
            System.exit(-1);
        }
        long numTable1Rows = 0L;
        long numTable2Rows = 0L;
        long numTable1DiffRows = 0L;
        long numTable2DiffRows = 0L;
        for (int i2 = 0; i2 < threads.length; ++i2) {
            numTable1Rows += threads[i2].counter.getTable1TotalRows();
            numTable2Rows += threads[i2].counter.getTable2TotalRows();
            numTable1DiffRows += threads[i2].counter.getTable1DiffRows();
            numTable2DiffRows += threads[i2].counter.getTable2DiffRows();
        }
        if (numTable1DiffRows == 0L && numTable2DiffRows == 0L) {
            System.out.println("tables '" + this.table1Path + "', and '" + this.table2Path + "' matched");
            System.out.println("Total number of rows processed " + numTable1Rows);
            return 0;
        }
        System.out.println("tables '" + this.table1Path + "', and '" + this.table2Path + "' didn't match");
        if (this.exitOnFirstMismatch) {
            System.out.println("Exiting after finding first mismatch");
        } else {
            System.out.println("Number of rows processed in '" + this.table1Path + "' : " + numTable1Rows);
            System.out.println("Number of rows processed in '" + this.table2Path + "' : " + numTable2Rows);
            System.out.println("Mismatch row count in '" + this.table1Path + "' : " + numTable1DiffRows);
            System.out.println("Mismatch row count in '" + this.table2Path + "' : " + numTable2DiffRows);
            System.out.println("Rows with mismatch are stored in " + this.outDir);
        }
        return -1;
    }

    @Override
    public void notifyMismatch() {
        if (this.exitOnFirstMismatch) {
            this.shouldExit = true;
        }
    }

    @Override
    public boolean shouldExit() {
        return this.shouldExit;
    }

    class CompareThread
    implements Runnable {
        DocScanner scan1;
        DocScanner scan2;
        DiffTableCounterCollector counter;
        DiffTableComparator comparator;
        private boolean completed;

        public CompareThread(QueryCondition keyCondition, DiffTableCounterCollector counter) throws Exception {
            this.scan1 = new DocScanner(DiffTableNonMR.this.table1Path, keyCondition, DiffTableNonMR.this.fields, DiffTableNonMR.this.excludedEmbeddedFamily);
            this.scan2 = new DocScanner(DiffTableNonMR.this.table2Path, keyCondition, DiffTableNonMR.this.fields, DiffTableNonMR.this.excludedEmbeddedFamily);
            this.counter = counter;
            this.comparator = new DiffTableComparator(DiffTableNonMR.this.table1Path, DiffTableNonMR.this.table2Path, counter);
        }

        public boolean completed() {
            return this.completed;
        }

        @Override
        public void run() {
            DBDocumentImpl doc1 = this.scan1.getNext();
            boolean foundMismatch = false;
            try {
                while (doc1 != null) {
                    this.counter.incTable1Rows();
                    foundMismatch = this.comparator.processNextRow(doc1, this.scan2);
                    if (foundMismatch && DiffTableNonMR.this.exitOnFirstMismatch) {
                        this.comparator.counter.close();
                        this.completed = true;
                        return;
                    }
                    doc1 = this.scan1.getNext();
                }
                foundMismatch = this.processRemainingRows(this.scan2);
                this.scan1.close();
                this.scan2.close();
                this.comparator.counter.close();
                this.completed = true;
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(-1);
            }
        }

        private boolean processRemainingRows(DocScanner scan) throws IOException {
            boolean foundMismatch = false;
            DBDocumentImpl doc = scan.getNext();
            while (doc != null) {
                foundMismatch = true;
                this.counter.incTable2Rows();
                this.counter.incTable2RowsMismatch(doc);
                if (DiffTableNonMR.this.exitOnFirstMismatch) {
                    return foundMismatch;
                }
                doc = scan.getNext();
            }
            return foundMismatch;
        }
    }
}

