/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.streams.impl;

import com.mapr.fs.proto.Marlinserver;
import com.mapr.streams.impl.MarlinRowKeyDecoder;
import com.mapr.streams.impl.StreamsDocument;
import java.util.List;
import java.util.NoSuchElementException;
import org.ojai.Document;
import org.ojai.FieldPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamsDocumentTranslator {
    static final Logger LOG = LoggerFactory.getLogger(StreamsDocumentTranslator.class);
    private List<Object> rowValueDocs;
    private String rowIdStr;
    private int indexInRow;
    private int msgsCount;
    private int rowPartition;
    private String rowTopic;
    private long rowOffset;
    private String producer;
    private List<Integer> projectedPathIds;
    private static final FieldPath ROW_PARTITION_PATH = FieldPath.parseFrom((String)MarlinRowKeyDecoder.PARTITION);
    private static final FieldPath ROW_TOPIC_PATH = FieldPath.parseFrom((String)MarlinRowKeyDecoder.TOPIC);
    private static final FieldPath ROW_OFFSET_PATH = FieldPath.parseFrom((String)MarlinRowKeyDecoder.OFFSET);
    private static final Marlinserver.MarlinInternalDefaults MDEF = Marlinserver.MarlinInternalDefaults.getDefaultInstance();
    private static final FieldPath ROW_PRODUCER_PATH = FieldPath.parseFrom((String)MDEF.getFMsgsProd());
    private static final FieldPath ROW_MSGS_LIST_PATH = FieldPath.parseFrom((String)MDEF.getFMsgsList());
    private static final FieldPath ROW_MSGS_COUNT_PATH = FieldPath.parseFrom((String)MDEF.getFMsgsCount());

    public StreamsDocumentTranslator(Document dbRecord, List<Integer> pathIds) throws Exception {
        this.rowIdStr = dbRecord.getIdString();
        Document rowKeyDoc = MarlinRowKeyDecoder.decodeMsgKey(this.rowIdStr);
        this.rowPartition = rowKeyDoc.getInt(ROW_PARTITION_PATH);
        this.rowTopic = rowKeyDoc.getString(ROW_TOPIC_PATH);
        this.rowOffset = rowKeyDoc.getLong(ROW_OFFSET_PATH);
        this.rowValueDocs = dbRecord.getList(ROW_MSGS_LIST_PATH);
        this.indexInRow = 0;
        this.msgsCount = dbRecord.getByte(ROW_MSGS_COUNT_PATH);
        this.producer = dbRecord.getString(ROW_PRODUCER_PATH);
        this.projectedPathIds = pathIds;
    }

    public boolean hasNext() {
        return this.indexInRow < this.msgsCount;
    }

    public Document next() {
        if (this.hasNext()) {
            int cur = this.indexInRow++;
            Document valueDoc = null;
            if (this.rowValueDocs != null && this.rowValueDocs.size() > 0) {
                valueDoc = (Document)this.rowValueDocs.get(cur);
            }
            return new StreamsDocument(this.rowIdStr, this.rowPartition, this.rowTopic, this.rowOffset, this.producer, valueDoc, cur, this.projectedPathIds);
        }
        throw new NoSuchElementException("next() called after hasNext() returned false.");
    }
}

