/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.streams.impl.listener;

import com.mapr.fs.jni.ListenerRecord;
import com.mapr.fs.jni.NativeData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.NoOffsetForPartitionException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.RecordTooLargeException;

public class NativeDataParser {
    private NativeData nativeData;

    NativeDataParser(NativeData nativeData) {
        this.nativeData = nativeData;
        this.nativeData.startParser();
    }

    public boolean HasData() {
        return this.nativeData.HasData();
    }

    public TopicPartition getNextTopicPartition() {
        int size = (int)this.getLongData();
        int offset = (int)this.getLongData();
        String stream = new String(this.nativeData.byte_data, offset, size);
        size = (int)this.getLongData();
        offset = (int)this.getLongData();
        String topic = new String(this.nativeData.byte_data, offset, size);
        int partition = (int)this.getLongData();
        return new TopicPartition(stream + ":" + topic, partition);
    }

    public Map<TopicPartition, List<ListenerRecord>> parseListenerRecords(boolean stripStreamPath) throws NoOffsetForPartitionException, RecordTooLargeException {
        HashMap<TopicPartition, List<ListenerRecord>> result = new HashMap<TopicPartition, List<ListenerRecord>>();
        while (this.HasData()) {
            String topicFullName;
            int idx;
            TopicPartition p = this.getNextTopicPartition();
            int error = (int)this.getLongData();
            if (error != 0) {
                if (error == 7) {
                    throw new RecordTooLargeException("There are some messages at " + p + " whose size is larger than the fetch size");
                }
                throw new NoOffsetForPartitionException(p);
            }
            long numMsgs = this.getLongData();
            ArrayList<ListenerRecord> recs = new ArrayList<ListenerRecord>();
            String topicName = p.topic();
            if (stripStreamPath && (idx = (topicFullName = topicName).lastIndexOf(58)) >= 0) {
                topicName = topicFullName.substring(idx + 1);
            }
            int prevProducerOff = 0;
            String prevProducer = null;
            int i = 0;
            while ((long)i < numMsgs) {
                long msgSeq = this.getLongData();
                long timestamp = this.getLongData();
                int keySz = (int)this.getLongData();
                int keyOff = (int)this.getLongData();
                int valSz = (int)this.getLongData();
                int valOff = (int)this.getLongData();
                int producerSz = (int)this.getLongData();
                int producerOff = (int)this.getLongData();
                byte[] key = null;
                byte[] value = null;
                String producer = null;
                if (keySz > 0) {
                    key = new byte[keySz];
                    System.arraycopy(this.nativeData.byte_data, keyOff, key, 0, keySz);
                }
                if (valSz > 0) {
                    value = new byte[valSz];
                    System.arraycopy(this.nativeData.byte_data, valOff, value, 0, valSz);
                }
                if (producerSz > 0) {
                    if (producerOff == prevProducerOff) {
                        producer = prevProducer;
                    } else {
                        producer = new String(this.nativeData.byte_data, producerOff, producerSz);
                        prevProducerOff = producerOff;
                        prevProducer = producer;
                    }
                }
                recs.add(new ListenerRecord(topicName, p.partition(), msgSeq, timestamp, key, value, producer));
                ++i;
            }
            result.put(p, recs);
        }
        return result;
    }

    long getLongData() {
        return this.nativeData.long_data[this.nativeData.longArrIndex++];
    }
}

