/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.streams.impl.admin;

import com.mapr.fs.ShimLoader;
import com.mapr.fs.proto.Marlinserver;
import com.mapr.streams.impl.admin.AssignInfo;
import com.mapr.streams.impl.admin.CursorInfo;
import com.mapr.streams.impl.admin.MStreamDescriptor;
import com.mapr.streams.impl.admin.MarlinAdminImpl;
import com.mapr.streams.impl.admin.TopicFeedInfo;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.ojai.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarlinAdmin {
    private static final Logger LOG = LoggerFactory.getLogger(MarlinAdmin.class);
    private final MarlinAdminImpl _admin;

    public MarlinAdmin(Configuration conf) throws IOException {
        this._admin = new MarlinAdminImpl(conf);
    }

    public void createStream(String streamName, MStreamDescriptor sdesc) throws IOException, IllegalArgumentException {
        this._admin.createStream(streamName, sdesc);
    }

    public void editStream(String streamName, MStreamDescriptor sdesc) throws IOException, IllegalArgumentException {
        this._admin.editStream(streamName, sdesc);
    }

    public MStreamDescriptor getStreamDescriptor(String streamName) throws IOException, IllegalArgumentException {
        return this._admin.getStreamDescriptor(streamName);
    }

    public static void createStreamForCopy(String replicaStreamName, String srcStreamName) throws IOException, IllegalArgumentException {
        MarlinAdminImpl.createStreamForCopy(replicaStreamName, srcStreamName);
    }

    public void deleteStream(String streamName) throws IOException, IllegalArgumentException {
        this._admin.deleteStream(streamName);
    }

    public int countTopics(String streamName) throws IOException, IllegalArgumentException {
        return this._admin.countTopics(streamName);
    }

    public void createTopic(String topicFullName) throws IOException {
        this._admin.createTopic(topicFullName);
    }

    public void createTopic(String topicFullName, int nfeeds) throws IOException {
        this._admin.createTopic(topicFullName, nfeeds);
    }

    public void editTopic(String topicFullName, int nfeeds) throws IOException {
        this._admin.editTopic(topicFullName, nfeeds);
    }

    public void deleteTopic(String topicFullName) throws IOException {
        this._admin.deleteTopic(topicFullName);
    }

    public Marlinserver.MarlinTopicMetaEntry getTopicMetaEntry(String topicFullName) throws IOException {
        return this._admin.getTopicMetaEntry(topicFullName);
    }

    public List<TopicFeedInfo> infoTopicCommon(String topicFullName, boolean headOnly) throws IOException {
        return this._admin.infoTopicCommon(topicFullName, headOnly);
    }

    public List<TopicFeedInfo> infoTopic(String topicFullName) throws IOException {
        return this.infoTopicCommon(topicFullName, false);
    }

    public Map<String, List<TopicFeedInfo>> listTopics(String streamName) throws IOException, IllegalArgumentException {
        return this._admin.listTopics(streamName);
    }

    public List<CursorInfo> listCursors(String streamName, String listenerGID, String topicName, int feedId) throws IOException {
        return this._admin.listCursors(streamName, listenerGID, topicName, feedId);
    }

    public List<CursorInfo> listAllCursors(String streamName) throws IOException {
        return this._admin.listAllCursors(streamName);
    }

    public List<CursorInfo> listCursorsForTopic(String topicFullName) throws IOException {
        return this._admin.listCursorsForTopic(topicFullName);
    }

    public void deleteCursors(String streamName, String listenerGID, String topicName, int feedId) throws IOException {
        this._admin.deleteCursors(streamName, listenerGID, topicName, feedId);
    }

    public boolean FilterResult(Document rec, String streamName, String listenerGID, String topic, AssignInfo ai, Map<String, Marlinserver.MarlinTopicMetaEntry> topicMetaMap) throws IOException {
        return this._admin.FilterResult(rec, streamName, listenerGID, topic, ai, topicMetaMap);
    }

    public List<AssignInfo> listAssigns(String streamName, String listenerGID, String topicName) throws IOException {
        return this._admin.listAssigns(streamName, listenerGID, topicName);
    }

    public void close() {
        this._admin.close();
    }

    static {
        ShimLoader.load();
    }
}

