/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.Inode;
import com.mapr.fs.LoggerProxy;
import com.mapr.fs.MapRClientImpl;
import com.mapr.fs.jni.InodeAttributes;
import com.mapr.fs.jni.Page;
import com.mapr.fs.jni.SFid;
import java.io.EOFException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FidInfo;
import org.apache.hadoop.fs.FileSystem;

public class MapRFsInStream
extends FSInputStream {
    public static final Log LOG = LogFactory.getLog(MapRFsInStream.class);
    int READ_SIZE = 65536;
    int RA_SIZE = 2 * this.READ_SIZE;
    int NUM_RA = 2;
    FileSystem.Statistics stats_;
    Inode inode_;
    SFid sfid_;
    Page curPage_;
    long curPos_;
    long prevPageOff_;
    int raHits_;
    int raReverse_;
    long raPos_;
    RAThread raThread_;
    long raCurrentReadStartPos_;
    int raCurrentReadLength_;

    protected MapRFsInStream(long clntPtr, long filePtr, String filename, FileSystem.Statistics stats, InodeAttributes attr) throws IOException {
        this.inode_ = new Inode(clntPtr, filePtr, filename, this, attr, LoggerProxy.InodeLogger);
        this.sfid_ = new SFid();
        this.curPage_ = null;
        this.curPos_ = 0L;
        this.prevPageOff_ = -1L;
        this.raPos_ = 0L;
        this.raHits_ = 3;
        this.raReverse_ = 0;
        this.stats_ = stats;
        this.raCurrentReadStartPos_ = 0L;
        this.raCurrentReadLength_ = 0;
    }

    public MapRFsInStream(long clntPtr, long filePtr, String filename, FileSystem.Statistics stats) throws IOException {
        this(clntPtr, filePtr, filename, stats, null);
    }

    public String getFidStr() {
        return this.inode_.getFidStr();
    }

    public long[] getFidServers() {
        return this.inode_.getFidServers();
    }

    public long getChunkSize() {
        return this.inode_.getChunkSize();
    }

    public void openAndRead(FidInfo pfid, String file, int length) throws IOException {
        this.curPage_ = this.inode_.getDataIntoCache(0L, length, this.sfid_, pfid, file);
    }

    void saveReadRequestParamsForRA(long pos, int len) {
        this.raCurrentReadStartPos_ = pos;
        this.raCurrentReadLength_ = len;
    }

    public int getCacheSize(InodeAttributes iattr) {
        if (MapRClientImpl.readBuffering()) {
            if (iattr.filesize > 0x800000L) {
                this.raThread_ = new RAThread();
                Thread t = new Thread(null, this.raThread_, "MapR RA", 16384L);
                t.setDaemon(true);
                t.start();
                return this.RA_SIZE * (2 * this.NUM_RA + 1) / 8192;
            }
            this.raThread_ = null;
            this.READ_SIZE = 524288;
            this.NUM_RA = 1;
            this.RA_SIZE = this.NUM_RA * this.READ_SIZE;
            return this.RA_SIZE / 8192 + 1;
        }
        this.raThread_ = null;
        this.READ_SIZE = 65536;
        this.NUM_RA = 1;
        this.RA_SIZE = this.NUM_RA * this.READ_SIZE;
        return 2 * (this.READ_SIZE / 8192) + 1;
    }

    void pr(String s) {
        LOG.error((Object)(this.inode_ + s));
    }

    void dropCurrentPage() {
        if (this.curPage_ != null) {
            Page p = this.curPage_;
            this.curPage_ = null;
            this.inode_.returnPageToCache(p);
        }
    }

    void dropAndRefillCurrentPage() throws IOException {
        this.dropCurrentPage();
        this.updateReadAhead();
        this.curPage_ = this.inode_.getDataIntoCache(this.curPos_, 1, this.sfid_, null, null);
    }

    boolean outsideCurrentPage() {
        long pageOff = this.curPage_.pageId << 13;
        return this.curPos_ < pageOff || this.curPos_ >= pageOff + 8192L;
    }

    public long getPos() {
        return this.curPos_;
    }

    public long getFileLength() {
        return this.inode_.eof();
    }

    public boolean seekToNewSource(long pos) {
        return false;
    }

    public synchronized int read(byte[] buffer, int bufOffset, int length) throws IOException {
        int start = -1;
        int lenInPage = -1;
        int bytesRead = 0;
        if (this.curPos_ + (long)length > this.inode_.eof()) {
            length = (int)(this.inode_.eof() - this.curPos_);
        }
        if (length <= 0) {
            this.curPos_ = this.inode_.eof();
            return -1;
        }
        this.saveReadRequestParamsForRA(this.curPos_, length);
        while (length > 0) {
            if (this.curPage_ == null || this.outsideCurrentPage()) {
                this.dropAndRefillCurrentPage();
            }
            if (this.curPage_ == null || this.curPos_ == this.inode_.eof()) {
                return this.incrementStats(bytesRead);
            }
            Page p = this.curPage_;
            start = (int)(this.curPos_ % 8192L);
            lenInPage = 8192 - start;
            if (lenInPage > length) {
                lenInPage = length;
            }
            p.bbuf.position(start);
            p.bbuf.get(buffer, bufOffset, lenInPage);
            this.curPos_ += (long)lenInPage;
            length -= lenInPage;
            bytesRead += lenInPage;
            bufOffset += lenInPage;
        }
        return this.incrementStats(bytesRead);
    }

    public synchronized int read() throws IOException {
        if (this.curPage_ == null || this.outsideCurrentPage()) {
            this.dropAndRefillCurrentPage();
        }
        if (this.curPage_ == null || this.curPos_ >= this.inode_.eof()) {
            this.curPos_ = this.inode_.eof();
            this.dropCurrentPage();
            return -1;
        }
        int posInBuf = (int)(this.curPos_ % 8192L);
        ++this.curPos_;
        if (this.stats_ != null) {
            this.stats_.incrementBytesRead(1L);
        }
        return this.curPage_.bbuf.get(posInBuf) & 0xFF;
    }

    public synchronized void seek(long pos) throws IOException {
        if (pos > this.inode_.eof()) {
            throw new EOFException("Seeking beyond EOF, file: " + this.inode_.filename() + ", file length: " + this.inode_.eof() + ", seeking to: " + pos);
        }
        if (pos == this.curPos_) {
            return;
        }
        if (pos < this.curPos_) {
            this.curPos_ = pos;
            ++this.raReverse_;
            if (this.raReverse_ > 1) {
                this.raPos_ = 0L;
                this.prevPageOff_ = -2L;
                this.raHits_ = 0;
            }
        } else {
            this.raReverse_ = 0;
        }
        this.curPos_ = pos;
        if (this.curPage_ != null && this.outsideCurrentPage()) {
            this.dropCurrentPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(long startPos, byte[] buffer, int bufOffset, int length) throws IOException {
        block19: {
            Page p;
            int i;
            Inode inode;
            MapRFsInStream mapRFsInStream = this;
            synchronized (mapRFsInStream) {
                inode = this.inode_;
            }
            if (inode == null) {
                throw new IOException("File already closed");
            }
            if (startPos + (long)length > inode.eof()) {
                length = (int)(inode.eof() - startPos);
            }
            if (length <= 0) {
                return -1;
            }
            long saveStartPos = startPos;
            long firstPageId = startPos >> 13;
            int numPages = (int)((startPos + (long)length - 1L >> 13) - firstPageId + 1L);
            Page[] pages = new Page[numPages];
            int lenLeft = length;
            for (i = 0; i < numPages; ++i) {
                p = new Page(null, false, 8192);
                p.pageId = firstPageId + (long)i;
                pages[i] = p;
                p.validStart = (int)(startPos & 0x1FFFL);
                p.validLen = 8192 - p.validStart;
                if (p.validLen > lenLeft) {
                    p.validLen = lenLeft;
                }
                lenLeft -= p.validLen;
                startPos += (long)p.validLen;
            }
            try {
                int lenInPage;
                int ret = inode.readPages(pages);
                if (length > ret) {
                    length = ret;
                }
                if (length <= 0) break block19;
                startPos = saveStartPos;
                MapRFsInStream mapRFsInStream2 = this;
                synchronized (mapRFsInStream2) {
                    this.incrementStats(length);
                }
                i = 0;
                for (int lenRead = length; lenRead > 0; lenRead -= lenInPage) {
                    int start = (int)(startPos % 8192L);
                    lenInPage = 8192 - start;
                    if (lenInPage > lenRead) {
                        lenInPage = lenRead;
                    }
                    p = pages[i++];
                    p.bbuf.position(start);
                    p.bbuf.get(buffer, bufOffset, lenInPage);
                    startPos += (long)lenInPage;
                    bufOffset += lenInPage;
                }
            }
            finally {
                for (i = 0; i < numPages; ++i) {
                    pages[i].releaseStorage();
                    pages[i] = null;
                }
            }
        }
        if (length < 0) {
            throw new IOException("error during read");
        }
        return length;
    }

    public void readFully(long pos, byte[] buffer) throws IOException {
        this.readFully(pos, buffer, 0, buffer.length);
    }

    public void readFully(long pos, byte[] buffer, int bufOffset, int length) throws IOException {
        if (this.getFileLength() - pos < (long)length) {
            throw new EOFException("Not enough data to fill buffer");
        }
        this.read(pos, buffer, bufOffset, length);
    }

    public void adviseFile(FSDataInputStream.FadviseType type, long offset, long count) throws IOException {
        if (this.inode_ != null) {
            switch (type) {
                case FILE_DONTNEED: {
                    this.inode_.adviseFile(0, offset, count);
                }
            }
        }
    }

    public synchronized void close() throws IOException {
        if (this.inode_ != null) {
            this.dropCurrentPage();
            if (this.raThread_ != null) {
                this.inode_.removeFromInStreams();
                RAWorker raw = new RAWorker(this);
                this.raThread_.enq(raw);
                this.raThread_ = null;
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.inode_.close();
            this.inode_ = null;
        }
    }

    void updateReadAhead() throws IOException {
        if (!MapRClientImpl.readBuffering()) {
            int len = this.raCurrentReadLength_;
            if (len > 8192) {
                long pos;
                if (len > 2 * this.READ_SIZE) {
                    len = 2 * this.READ_SIZE;
                }
                if ((pos = this.raCurrentReadStartPos_) % 8192L != 0L) {
                    pos -= pos % 8192L;
                    if ((len += 8191) > 2 * this.READ_SIZE) {
                        len = 2 * this.READ_SIZE;
                    }
                }
                if (pos + (long)len > this.inode_.eof() && (len = (int)(this.inode_.eof() - pos)) <= 0) {
                    return;
                }
                this.raCurrentReadLength_ -= len;
                Page p = this.inode_.getDataIntoCache(pos, len, this.sfid_, null, null);
                if (p != null) {
                    this.inode_.returnPageToCache(p);
                }
            }
            return;
        }
        if (this.curPos_ >> 13 == 1L + this.prevPageOff_) {
            ++this.raHits_;
        }
        this.prevPageOff_ = this.curPos_ >> 13;
        if (this.raHits_ < 3) {
            return;
        }
        if (this.curPos_ % (long)this.READ_SIZE != 0L) {
            return;
        }
        if (this.raThread_ != null) {
            int sz;
            long chunksz;
            boolean didRA = false;
            long raDistance = this.raPos_ - this.curPos_;
            if (this.raHits_ > 10 && raDistance > (long)(2 * this.RA_SIZE)) {
                this.raPos_ = this.curPos_;
            }
            if ((chunksz = this.inode_.attrs().chunksize) > 0L && this.curPos_ % chunksz == 0L) {
                this.raPos_ = this.curPos_;
            } else if (this.raPos_ <= this.curPos_ && (chunksz > 0L && (this.curPos_ & chunksz - 1L) >= (long)(this.NUM_RA * this.RA_SIZE) || chunksz == 0L && this.curPos_ >= (long)(this.NUM_RA * this.RA_SIZE))) {
                int i = 0;
                for (i = 0; i < this.NUM_RA; ++i) {
                    Page[] pagesToFill;
                    long curChunk;
                    this.raPos_ = this.curPos_ + (long)(this.RA_SIZE * (i + 1));
                    if (this.raPos_ >= this.inode_.eof()) continue;
                    int sz2 = this.RA_SIZE;
                    if (this.raPos_ + (long)sz2 > this.inode_.eof()) {
                        sz2 = (int)(this.inode_.eof() - this.raPos_);
                    }
                    long l = curChunk = chunksz != 0L ? this.curPos_ / chunksz : 0L;
                    if (sz2 <= 0 || chunksz != 0L && (curChunk != this.raPos_ / chunksz || curChunk != (this.raPos_ + (long)sz2) / chunksz) || (pagesToFill = this.inode_.allocateReadaheadPages(this.raPos_, sz2)) == null) continue;
                    didRA = true;
                    RAWorker ra = new RAWorker(this, pagesToFill);
                    this.raThread_.enq(ra);
                }
            }
            int n = sz = didRA ? this.RA_SIZE : this.READ_SIZE;
            if (this.curPos_ + (long)sz > this.inode_.eof() && (sz = (int)(this.inode_.eof() - this.curPos_)) <= 0) {
                return;
            }
            Page p = this.inode_.getDataIntoCache(this.curPos_, sz, this.sfid_, null, null);
            if (p != null) {
                this.inode_.returnPageToCache(p);
            }
        } else {
            if (this.curPos_ % (long)this.RA_SIZE != 0L) {
                return;
            }
            long pos = this.curPos_;
            for (int i = 0; i < this.NUM_RA; ++i) {
                int sz = this.READ_SIZE;
                if (pos + (long)sz > this.inode_.eof() && (sz = (int)(this.inode_.eof() - pos)) <= 0) {
                    return;
                }
                Page p = this.inode_.getDataIntoCache(pos, sz, this.sfid_, null, null);
                if (p != null) {
                    this.inode_.returnPageToCache(p);
                }
                pos += (long)sz;
            }
        }
    }

    int incrementStats(int bytesRead) {
        if (bytesRead <= 0) {
            return -1;
        }
        if (this.stats_ != null) {
            this.stats_.incrementBytesRead((long)bytesRead);
        }
        return bytesRead;
    }

    static class RAThread
    implements Runnable {
        RAWorker head = null;
        RAWorker tail = null;
        SFid sfid_ = new SFid();

        RAThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                RAWorker runq = null;
                try {
                    block6: while (true) {
                        if (runq == null) {
                            RAThread rAThread = this;
                            synchronized (rAThread) {
                                while (this.head == null) {
                                    this.wait();
                                }
                                runq = this.head;
                                this.tail = null;
                                this.head = null;
                            }
                        }
                        while (true) {
                            if (runq == null) continue block6;
                            RAWorker rnext = runq.next;
                            runq.run(this.sfid_);
                            if (runq.pagesToFill == null) {
                                if (rnext != null) {
                                    LOG.error((Object)"rnext is non-null");
                                }
                                return;
                            }
                            runq = rnext;
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void enq(RAWorker rawork) {
            RAThread rAThread = this;
            synchronized (rAThread) {
                if (this.tail != null) {
                    this.tail.next = rawork;
                } else {
                    this.head = rawork;
                }
                this.tail = rawork;
                rawork.next = null;
                this.notify();
            }
        }
    }

    static class RAWorker {
        MapRFsInStream istr;
        Page[] pagesToFill;
        public RAWorker next;

        RAWorker(MapRFsInStream istr, Page[] pages) {
            this.istr = istr;
            this.pagesToFill = pages;
        }

        RAWorker(MapRFsInStream istr) {
            this.istr = istr;
            this.pagesToFill = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void run(SFid sfid) {
            try {
                if (this.pagesToFill == null) {
                    MapRFsInStream mapRFsInStream = this.istr;
                    synchronized (mapRFsInStream) {
                        ((Object)((Object)this.istr)).notify();
                    }
                    return;
                }
                this.istr.inode_.fillPages(this.pagesToFill, sfid, null, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

