/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.JobTrackerWatcher;
import com.mapr.fs.MapRBlockLocation;
import com.mapr.fs.MapRFileStatus;
import com.mapr.fs.MapRFsInStream;
import com.mapr.fs.MapRFsOutStream;
import com.mapr.fs.jni.Errno;
import com.mapr.fs.jni.InodeAttributes;
import com.mapr.fs.jni.JNIFsStatus;
import com.mapr.fs.jni.MapRClient;
import com.mapr.fs.jni.MapRConstants;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FidInfo;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.apache.zookeeper.KeeperException;

public class MapRClientImpl
extends MapRClient
implements MapRConstants {
    public static final Log LOG = LogFactory.getLog(MapRClient.class);
    private static boolean readBuffering_ = true;
    private long clntPtr;
    private String clusterName;
    private FileSystem.Statistics stats;
    private JobTrackerWatcher jtwatcher;
    private String zkString;

    public MapRClientImpl(String clusterName, long[] ips, String auth, FileSystem.Statistics stats, boolean disableNameCache) throws IOException {
        try {
            this.clntPtr = this.OpenClient(clusterName, ips, auth, disableNameCache);
            if (this.clntPtr == 0L) {
                throw new IOException("Could not create FileClient");
            }
        }
        catch (UnknownHostException e) {
            System.out.println("Exception occured " + e);
        }
        this.stats = stats;
        this.clusterName = clusterName;
        this.jtwatcher = null;
        this.zkString = MapRClientImpl.getZkConnectString((long)this.clntPtr, (boolean)true);
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void close() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"MapRClient closing");
        }
        long ptr = this.clntPtr;
        this.clntPtr = 0L;
        this.CloseClient(ptr);
    }

    public static void setReadBuffering(boolean v) {
        readBuffering_ = v;
    }

    public static boolean readBuffering() {
        return readBuffering_;
    }

    public MapRFsOutStream create(String name, int mask, int mode, boolean overwrite, short replication, long chunkSize, Progressable progress, MapRConstants.ErrorValue err) throws IOException {
        long filePtr;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Create: " + name + " mode = " + mode + " replication = " + replication + " chunkSize = " + ((mask & 0x80) != 0 ? Long.valueOf(chunkSize) : "default") + " overwrite = " + overwrite));
        }
        if ((filePtr = this.create(this.clntPtr, name, mask, mode, overwrite, replication, chunkSize, err)) == 0L) {
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 136) {
                return null;
            }
            throw new IOException("Create failed for file: " + name + ", error: " + Errno.toString((int)err.error) + " (" + err.error + ")");
        }
        return new MapRFsOutStream(this.clntPtr, filePtr, name, this.stats);
    }

    public MapRFsInStream open(String name, MapRConstants.ErrorValue err) throws IOException {
        InodeAttributes attr;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Open: path = " + name));
        }
        if ((attr = this.open(this.clntPtr, name, 0, err)) == null || attr.filePtr == 0L) {
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 136) {
                return null;
            }
            throw new IOException("Open failed for file: " + name + ", error: " + Errno.toString((int)err.error) + " (" + err.error + ")");
        }
        return new MapRFsInStream(this.clntPtr, attr.filePtr, name, this.stats);
    }

    public MapRFsInStream openFid2(FidInfo pfid, String file, int length) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("openFid2: fid = " + pfid + ", file = " + (file != null ? file : "") + ", length = " + length));
        }
        MapRFsInStream is = new MapRFsInStream(this.clntPtr, 0L, null, this.stats, null);
        is.openAndRead(pfid, file, length);
        return is;
    }

    public MapRFsInStream openFid(String fid, long[] ips, long chunkSize, long fileSize) throws IOException {
        MapRConstants.ErrorValue err;
        InodeAttributes attr;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("openFid: fid = " + fid + ", chunkSize = " + chunkSize + ", fileSize = " + fileSize));
        }
        if ((attr = this.openFidWithParams(this.clntPtr, fid, ips, chunkSize, fileSize, err = new MapRConstants.ErrorValue())) == null || attr.filePtr == 0L) {
            throw new IOException("openFid failed for fid: " + fid + ", error: " + Errno.toString((int)err.error) + " (" + err.error + ")");
        }
        return new MapRFsInStream(this.clntPtr, attr.filePtr, null, this.stats);
    }

    public MapRFsInStream openFid(String pfid, String file, long[] ips) throws IOException {
        MapRConstants.ErrorValue err;
        InodeAttributes attr;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("openFid: pfid = " + pfid + ", file = " + file));
        }
        if ((attr = this.openFid(this.clntPtr, pfid, file, ips, err = new MapRConstants.ErrorValue())) == null || attr.filePtr == 0L) {
            String errMsg = err.error != 0 ? ", error: " + Errno.toString((int)err.error) + " (" + err.error + ")" : "";
            throw new IOException("openFid failed for pfid: " + pfid + ", file: " + file + errMsg);
        }
        return new MapRFsInStream(this.clntPtr, attr.filePtr, null, this.stats);
    }

    public MapRFsOutStream createFid(String pfid, String file, int mask, int mode, long chunkSize) throws IOException {
        MapRConstants.ErrorValue err;
        long filePtr;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("createFid: pfid = " + pfid + ", file = " + file));
        }
        if ((filePtr = this.createFid(this.clntPtr, pfid, file, mask, mode, chunkSize, err = new MapRConstants.ErrorValue())) == 0L) {
            throw new IOException("createFid failed for pfid: " + pfid + ", file: " + file + ", error: " + Errno.toString((int)err.error) + " (" + err.error + ")");
        }
        return new MapRFsOutStream(this.clntPtr, filePtr, null, this.stats);
    }

    public int deleteFid(String pfid, String dir) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("deleteFid: pfid = " + pfid + ", dir = " + (dir != null ? dir : "")));
        }
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        return this.removeFid(this.clntPtr, pfid, dir, err);
    }

    public String mkdirsFid(String pfid, String dir, int mask, int mode, boolean compress, long chunkSize) throws IOException {
        MapRConstants.ErrorValue err;
        String fidStr;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("mkdirsFid: pfid = " + pfid + ", dir = " + dir));
        }
        if ((fidStr = this.mkdirsFid(this.clntPtr, pfid, dir, mask, mode, compress, chunkSize, err = new MapRConstants.ErrorValue())) == null) {
            throw new IOException("mkdirsFid failed, Error: " + Errno.toString((int)err.error));
        }
        return fidStr;
    }

    public MapRFsOutStream append(String name, MapRConstants.ErrorValue err) throws IOException {
        InodeAttributes attr;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Append: path = " + name));
        }
        if ((attr = this.open(this.clntPtr, name, 1, err)) == null || attr.filePtr == 0L) {
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 136) {
                return null;
            }
            throw new IOException("Append failed for file: " + name + ", error: " + Errno.toString((int)err.error) + " (" + err.error + ")");
        }
        MapRFsOutStream os = new MapRFsOutStream(this.clntPtr, attr.filePtr, name, this.stats);
        os.seekToEof();
        return os;
    }

    public int delete(String name, boolean recursive, MapRConstants.ErrorValue err) {
        return this.remove(this.clntPtr, name, recursive, err);
    }

    public MapRFileStatus getFileStatus(String name, boolean needSlashMapr, String authority, MapRConstants.ErrorValue err) {
        return MapRFileStatus.getStatus(this.getattr(this.clntPtr, name, needSlashMapr, authority, err));
    }

    public MapRFileStatus[] listStatus(String name, boolean showVols, boolean needSlashMapr, boolean showHidden, String authority, MapRConstants.ErrorValue err) {
        return MapRFileStatus.getStatus(this.readdirplus(this.clntPtr, name, showVols, needSlashMapr, showHidden, authority, err));
    }

    public int rename(String src, String dest, MapRConstants.ErrorValue err) {
        return this.rename(this.clntPtr, src, dest, err);
    }

    public int mkdirs(String name, int mask, int mode, boolean compress, long chunkSize, MapRConstants.ErrorValue err, boolean needFid) {
        return this.mkdirs(this.clntPtr, name, mask, mode, compress, chunkSize, err, needFid);
    }

    public MapRBlockLocation[] getBlockLocations(String name, long start, long len, boolean usePrimaryFid, boolean needDiskBlocks, MapRConstants.ErrorValue err) {
        return MapRBlockLocation.getLocation(this.getBlockInfo(this.clntPtr, name, start, len, usePrimaryFid, needDiskBlocks, err));
    }

    public int setattr(String name, int bitmask, String user, String group, long mtime, long atime, int mode, short repl, boolean canCompress, String compressionName, long chunkSize, MapRConstants.ErrorValue err) {
        return this.setattr(this.clntPtr, name, bitmask, user, group, mtime, atime, mode, repl, canCompress, compressionName, chunkSize, err);
    }

    public int setOwner(String name, String user, String group, MapRConstants.ErrorValue err) {
        int b = 0;
        if (user != null) {
            b |= 1;
        }
        if (group != null) {
            b |= 2;
        }
        return this.setattr(this.clntPtr, name, b, user, group, 0L, 0L, -1, (short)0, true, null, -1L, err);
    }

    public int setOwnerFid(String name, String user, String group, MapRConstants.ErrorValue err) {
        int b = 0;
        if (user != null) {
            b |= 1;
        }
        if (group != null) {
            b |= 2;
        }
        return this.setattr(this.clntPtr, name, b |= 0x400, user, group, 0L, 0L, -1, (short)0, true, null, -1L, err);
    }

    public int setTimes(String name, long mtime, long atime, MapRConstants.ErrorValue err) {
        int b = 0;
        if (mtime != -1L) {
            b |= 4;
        }
        if (atime != -1L) {
            b |= 8;
        }
        return this.setattr(this.clntPtr, name, b, null, null, mtime, atime, -1, (short)0, true, null, -1L, err);
    }

    public int setPermission(String name, int mode, MapRConstants.ErrorValue err) {
        return this.setattr(this.clntPtr, name, 16, null, null, 0L, 0L, mode, (short)0, true, null, -1L, err);
    }

    public FsStatus getStatus() {
        JNIFsStatus fs = this.getStatus(this.clntPtr);
        return new FsStatus(fs.getCapacity(), fs.getUsed(), fs.getRemaining());
    }

    public int setReplication(String name, short repl, MapRConstants.ErrorValue err) {
        return this.setattr(this.clntPtr, name, 32, null, null, 0L, 0L, -1, repl, true, null, -1L, err);
    }

    public void createSymlink(String target, String link, MapRConstants.ErrorValue linkErr) throws IOException {
        this.createSymlink(this.clntPtr, target, link, linkErr);
    }

    public Path getLinkTarget(String f, MapRConstants.ErrorValue err) {
        String link = this.readlink(this.clntPtr, f, err);
        return new Path(link);
    }

    public int setCompression(String path, boolean val, String compName, MapRConstants.ErrorValue err) {
        MapRFileStatus status = MapRFileStatus.getStatus(this.getattr(this.clntPtr, path, false, null, err));
        if (status.isDir()) {
            int mask = 64;
            if (compName != null) {
                mask |= 0x200;
            }
            return this.setattr(this.clntPtr, path, mask, null, null, 0L, 0L, -1, (short)0, val, compName, -1L, err);
        }
        return -1;
    }

    public int setChunkSize(String path, long val, MapRConstants.ErrorValue err) {
        MapRFileStatus status = MapRFileStatus.getStatus(this.getattr(this.clntPtr, path, false, null, err));
        if (err.error < 0) {
            err.error = -err.error;
        }
        if (status == null || err.error == 136) {
            return -1;
        }
        if (status.isDir()) {
            return this.setattr(this.clntPtr, path, 128, null, null, 0L, 0L, -1, (short)0, true, null, val, err);
        }
        return -1;
    }

    public FileSystem.Statistics getStatistics() {
        return this.stats;
    }

    public int mountVolume(String volName, String mountPath, String username) {
        return this.mountVolume(this.clntPtr, volName, mountPath, username);
    }

    public int unmountVolume(String volName, String mountPath, String username, int pCid, int pCinum, int pUniq) {
        return this.unmountVolume(this.clntPtr, volName, mountPath, username, pCid, pCinum, pUniq);
    }

    public String getMountPath(String username, int pCid, int pCinum, int pUniq) {
        return this.getMountPath(this.clntPtr, username, pCid, pCinum, pUniq);
    }

    public int createSnapshot(String volName, int volId, int rootCid, String snapshotName, boolean mirrorSnapshot, String username) {
        return this.createSnapshot(this.clntPtr, volName, volId, rootCid, snapshotName, mirrorSnapshot, username);
    }

    public int createVolLink(String volName, String volLink, boolean writeable, boolean hidden) {
        return this.createVolLink(this.clntPtr, volName, volLink, writeable, hidden);
    }

    public int deleteVolLink(String volLink) {
        return this.deleteVolLink(this.clntPtr, volLink);
    }

    public static int getModeBits(FsPermission permission, Configuration conf) {
        int mode = permission != null ? permission.toShort() : FsPermission.getDefault().toShort();
        short umask = FsPermission.getUMask((Configuration)conf).toShort();
        return mode &= ~umask;
    }

    public synchronized String getZkConnectString() {
        String ret = this.zkString;
        if (ret == null || ret.isEmpty()) {
            ret = MapRClientImpl.getZkConnectString((long)this.clntPtr, (boolean)false);
        }
        this.zkString = null;
        return ret;
    }

    public synchronized InetSocketAddress[] getJobTrackerAddrs() throws IOException {
        String zkConnectString;
        boolean done = false;
        int attempts = 0;
        InetSocketAddress[] jobTrackerAddrs = new InetSocketAddress[1];
        while (!done) {
            if (this.jtwatcher == null) {
                zkConnectString = this.getZkConnectString();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("zkConnectString: = " + zkConnectString));
                }
                if (zkConnectString != null && !zkConnectString.isEmpty()) {
                    this.jtwatcher = new JobTrackerWatcher(zkConnectString);
                    if (!this.jtwatcher.connect()) {
                        this.jtwatcher.close();
                        this.jtwatcher = null;
                        throw new IOException("Failed to connect to Zookeeper at " + zkConnectString + " for cluster " + this.getClusterName());
                    }
                } else {
                    throw new IOException("Failed to get Zookeeper information for cluster " + this.getClusterName());
                }
            }
            try {
                jobTrackerAddrs[0] = this.jtwatcher.findJobTrackerAddr();
                done = true;
            }
            catch (KeeperException ke) {
                if (ke instanceof KeeperException.SessionExpiredException || ke instanceof KeeperException.SessionMovedException || ke instanceof KeeperException.ConnectionLossException) {
                    this.jtwatcher.close();
                    this.jtwatcher = null;
                    LOG.error((Object)("Retrying...Fetching new Zookeeper locations from CLDB.  Attempt #" + ++attempts));
                    try {
                        if (attempts * 2 > 30) {
                            Thread.currentThread();
                            Thread.sleep(30000L);
                            continue;
                        }
                        Thread.currentThread();
                        Thread.sleep(attempts * 2 * 1000);
                    }
                    catch (InterruptedException e) {}
                    continue;
                }
                throw new IOException("Failed to get Zookeeper information for cluster " + this.getClusterName());
            }
        }
        if (jobTrackerAddrs[0] == null) {
            zkConnectString = this.jtwatcher.getZKString();
            this.jtwatcher.close();
            this.jtwatcher = null;
            throw new IOException("Failed to get jobtracker location from Zookeeper at " + zkConnectString + " for cluster " + this.getClusterName());
        }
        return jobTrackerAddrs;
    }
}

