/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.net.NetUtils;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class JobTrackerWatcher
implements Watcher {
    public static final String SERVICE_MASTER_NODE = "$master$";
    public static final Log LOG = LogFactory.getLog(JobTrackerWatcher.class);
    public static final int ZK_CONNECTION_TIMEOUT = 30000;
    public static String JT_ZK_SERVICE_PATH = "/services/jobtracker/$master$";
    public static String JT_ZK_SERVICE_PATH_OLD = "/services/jobtracker/master";
    private ZooKeeper s_zk;
    private InetSocketAddress jobTrackAddr;
    private volatile boolean isConnected = false;
    private String zkConnectString;
    private int refCount = 1;

    public JobTrackerWatcher(String zkConnectString) {
        this.zkConnectString = zkConnectString;
        this.isConnected = false;
        this.jobTrackAddr = null;
    }

    public String getZKString() {
        return this.zkConnectString;
    }

    public synchronized void incCount() {
        ++this.refCount;
    }

    public synchronized void decCount() {
        --this.refCount;
    }

    public synchronized boolean isZeroReference() {
        return this.refCount == 0;
    }

    public synchronized boolean connect() {
        if (this.zkConnectString == null) {
            LOG.error((Object)"Zookeeper credentials were not specified. Client will not be able to reconnect on Jobtracker Failover.");
            return false;
        }
        try {
            this.s_zk = new ZooKeeper(this.zkConnectString, 30000, (Watcher)this);
        }
        catch (IOException e) {
            LOG.error((Object)"Could not create ZooKeeper instance.", (Throwable)e);
            return false;
        }
        return true;
    }

    public synchronized boolean reconnect() {
        this.close();
        return this.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.s_zk == null) {
            return;
        }
        try {
            this.s_zk.close();
        }
        catch (InterruptedException e) {
            LOG.error((Object)"Unable to close ZooKeeper connection", (Throwable)e);
        }
        finally {
            this.s_zk = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetSocketAddress findJobTrackerAddr() throws KeeperException.SessionExpiredException, KeeperException.SessionMovedException, KeeperException.ConnectionLossException {
        int attempts = 0;
        boolean isInfoEnabled = LOG.isInfoEnabled();
        while (true) {
            try {
                String[] jtHostPort;
                byte[] byteData;
                String jtData;
                String[] jtDataSplit;
                String jtMasterNode = JT_ZK_SERVICE_PATH;
                Stat stat = this.s_zk.exists(JT_ZK_SERVICE_PATH, false);
                if (stat == null) {
                    stat = this.s_zk.exists(JT_ZK_SERVICE_PATH_OLD, false);
                    jtMasterNode = JT_ZK_SERVICE_PATH_OLD;
                }
                if ((jtDataSplit = (jtData = new String(byteData = this.s_zk.getData(jtMasterNode, false, stat))).split("\n")).length == 2 && jtDataSplit[1].equalsIgnoreCase("up") && (jtHostPort = jtDataSplit[0].split(":")).length == 2) {
                    JobTrackerWatcher jobTrackerWatcher = this;
                    synchronized (jobTrackerWatcher) {
                        this.jobTrackAddr = NetUtils.createSocketAddr((String)jtDataSplit[0]);
                        if (isInfoEnabled) {
                            LOG.info((Object)("Current running JobTracker is: " + this.jobTrackAddr));
                        }
                        return this.jobTrackAddr;
                    }
                }
            }
            catch (InterruptedException ie) {
                LOG.error((Object)"Interrupted Exception while waiting for ZooKeeper service to send jobtracker address", (Throwable)ie);
                return null;
            }
            catch (KeeperException.NoNodeException knne) {
                if (isInfoEnabled) {
                    LOG.info((Object)("findJobTrackerAddr: NoNodeFound, Retrying... Current ZooKeeper Server: " + this.getZKString()));
                }
            }
            catch (KeeperException.OperationTimeoutException kto) {
                if (isInfoEnabled) {
                    LOG.info((Object)("findJobTrackerAddr: TimedOut, Retrying... Current ZooKeeper Server: " + this.getZKString()));
                }
            }
            catch (KeeperException.SessionExpiredException kse) {
                if (isInfoEnabled) {
                    LOG.info((Object)("findJobTrackerAddr: SessionExpired, Reconnecting... Current ZooKeeper Server: " + this.getZKString()));
                }
                throw kse;
            }
            catch (KeeperException.SessionMovedException ksm) {
                if (isInfoEnabled) {
                    LOG.info((Object)("findJobTrackerAddr: SessionMoved, Reconnecting... Current ZooKeeper Server: " + this.getZKString()));
                }
                throw ksm;
            }
            catch (KeeperException.ConnectionLossException kcle) {
                if (isInfoEnabled) {
                    LOG.info((Object)("findJobTrackerAddr: ConnectionLost, Reconnecting... Current ZooKeeper Server: " + this.getZKString()));
                }
                throw kcle;
            }
            catch (KeeperException e) {
                LOG.error((Object)("While trying to get JobTracker address Zookeeper received " + (Object)((Object)e) + ". Can not reconnect to zookeeper service for " + this.getZKString() + ". Bailing out."));
                return null;
            }
            if (isInfoEnabled) {
                LOG.info((Object)("Retrying to connect ZooKeeper Attempt# " + attempts + " Current ZooKeeper Server: " + this.getZKString()));
            }
            ++attempts;
            try {
                if (attempts * 2 > 30) {
                    Thread.currentThread();
                    Thread.sleep(30000L);
                    continue;
                }
                Thread.currentThread();
                Thread.sleep(attempts * 2 * 1000);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void process(WatchedEvent event) {
    }
}

