/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.TestAttr;
import java.io.IOException;
import java.net.URI;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;

public class TestCreate
extends TestCase {
    private byte[] data;
    MapRFileSystem fs;
    Configuration conf;
    public static final Log LOG = LogFactory.getLog(TestAttr.class);

    protected void setUp() throws Exception {
        this.fs = new MapRFileSystem();
        this.conf = new Configuration();
        try {
            URI uri = new URI("maprfs://127.0.0.1:7222");
            this.fs.initialize(uri, this.conf);
        }
        catch (Exception e) {
            System.out.println("Exception " + e + " occurred");
            throw new Exception(e);
        }
        this.data = new byte[24576];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = (byte)(i % 10);
        }
    }

    protected void tearDown() throws Exception {
        this.fs.close();
    }

    public void testCreate() throws IOException {
        Path path = new Path("/t.txt");
        FSDataOutputStream os = this.fs.create(path);
        os.write(this.data);
        os.close();
        boolean created = false;
        try {
            os = this.fs.create(path, false);
            created = true;
            os.write(this.data);
            os.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (created) {
            throw new IOException("Incorrect overwrote existing file: " + path);
        }
        try {
            os = this.fs.create(path, true);
            created = true;
            os.write(this.data);
            os.close();
        }
        catch (IOException e) {
            throw new IOException("create w/ overwrite failed", e);
        }
        if (!created) {
            throw new IOException("create w/ overwrite failed");
        }
    }

    public void testCreate2() throws IOException {
        Path path = new Path("test_dir");
        try {
            this.fs.mkdirs(path, new FsPermission(1604));
            this.fs.create(path, true);
            throw new IOException("testCreate2 failed");
        }
        catch (IOException iOException) {
            return;
        }
    }
}

