/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.hadoop.yarn.configuration;

import com.mapr.hadoop.yarn.configuration.YarnHASiteXmlBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class YarnSiteMyriadXmlBuilder {
    private static final String RM_IP_TEMPLATE = "__RM_IP__";
    private static final String CONFIG_DEMARCATION = "  <!-- :::CAUTION::: DO NOT EDIT ANYTHING ON OR ABOVE THIS LINE -->";
    private static final String YARN_SITE_MYRIAD_TEMPLATE_FILE = "yarn-site-mapr-myriad-template.xml";
    private static final String YARN_SITE_MYRIAD_HA_TEMPLATE_FILE = "yarn-site-mapr-myriad-ha-template.xml";
    private final String rmIp;
    private final String pathToYarnSiteXml;
    private final boolean isHAEnabled;

    public YarnSiteMyriadXmlBuilder(String rmIp, String pathToYarnSiteXml, boolean isHAEnabled) {
        this.rmIp = rmIp;
        this.pathToYarnSiteXml = pathToYarnSiteXml;
        this.isHAEnabled = isHAEnabled;
    }

    public String build() throws IOException {
        String currentContents;
        String templateContent = this.buildYarnSiteXmlFromTemplate();
        String string = currentContents = new File(this.pathToYarnSiteXml).exists() ? this.readStream(new FileInputStream(this.pathToYarnSiteXml)) : "";
        if (currentContents.contains(CONFIG_DEMARCATION)) {
            return currentContents.replaceAll("(?s).*  <!-- :::CAUTION::: DO NOT EDIT ANYTHING ON OR ABOVE THIS LINE -->\r?\n", templateContent.replaceAll("(?s)</configuration>.*", ""));
        }
        currentContents = templateContent;
        return currentContents.replaceAll("(?s).*  <!-- :::CAUTION::: DO NOT EDIT ANYTHING ON OR ABOVE THIS LINE -->\r?\n", templateContent.replaceAll("(?s)</configuration>.*", ""));
    }

    private String buildYarnSiteXmlFromTemplate() throws IOException {
        String templateString = this.isHAEnabled ? YARN_SITE_MYRIAD_HA_TEMPLATE_FILE : YARN_SITE_MYRIAD_TEMPLATE_FILE;
        InputStream haTemplateStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(templateString);
        return this.readStream(haTemplateStream).replace(RM_IP_TEMPLATE, this.rmIp);
    }

    private String readStream(InputStream stream) throws IOException {
        String line;
        StringBuilder buf = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        while ((line = reader.readLine()) != null) {
            buf.append(line);
            buf.append("\n");
        }
        reader.close();
        return buf.toString();
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.err.println("Usage: YarnSiteMyriadXmlBuilder <RM_IP> <Full path To yarn-site.xml>");
            System.exit(1);
        }
        if (args[0].split(",").length > 1) {
            System.err.println("Multiple RM IPs are provided. For RM HA, use " + YarnHASiteXmlBuilder.class.getName());
            System.exit(1);
        }
        boolean isHAEnabled = false;
        if (args.length > 2) {
            isHAEnabled = Boolean.parseBoolean(args[2]);
        }
        String newYarnSiteXml = new YarnSiteMyriadXmlBuilder(args[0], args[1], isHAEnabled).build();
        System.out.println(newYarnSiteXml);
    }
}

