/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.hadoop.yarn.util;

import com.mapr.baseutils.BaseUtilsHelper;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.util.DFSLoggingHandler;
import org.apache.hadoop.yarn.util.TaskLogUtil;

public class MapRFSLoggingHandler
extends DFSLoggingHandler {
    private static final String MAPR_INSTALL_DIR = BaseUtilsHelper.getPathToMaprHome();
    private FileSystem fs;
    private Path localVolumeLogPath;
    private Path globPath;

    public MapRFSLoggingHandler() {
        try {
            this.fs = FileSystem.get((Configuration)TaskLogUtil.getConf());
        }
        catch (IOException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
        String glob = TaskLogUtil.getPropertyValue((String)"yarn.dfs-logging.dir-glob");
        this.globPath = new Path(glob);
        String hostRegex = "*";
        this.localVolumeLogPath = new Path(glob.replace("*", BaseUtilsHelper.getMapRHostName()));
    }

    public String getStdOutCommand(String filePath) {
        Path localLogDir = new Path(filePath).getParent();
        return MAPR_INSTALL_DIR + "/bin/maprcp - " + filePath + " -autoflush " + "1>/dev/null 2>/dev/null";
    }

    public String getStdErrCommand(String stderrFile) {
        return "";
    }

    public Path getLogDirForWrite(String relativeContainerLogDir) throws IOException {
        return new Path(this.localVolumeLogPath.toString() + "/" + relativeContainerLogDir);
    }

    public Path[] getLogDir(ApplicationId applicationId) throws IOException {
        return this.globSearch(applicationId.toString());
    }

    public Path getLogDir(ContainerId containerId) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(containerId.getApplicationAttemptId().getApplicationId().toString()).append("/").append(containerId.toString());
        Path[] paths = this.globSearch(sb.toString());
        if (paths == null || paths.length == 0) {
            throw new YarnRuntimeException("Log dir not present for container: " + containerId);
        }
        return paths[0];
    }

    private Path[] globSearch(String suffix) throws IOException {
        Path finalGlobPath = new Path(this.globPath, suffix);
        return FileUtil.stat2Paths((FileStatus[])this.fs.globStatus(finalGlobPath));
    }
}

