/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import com.mapr.fs.proto.Common;
import com.mapr.util.zookeeper.ZKDataRetrieval;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;

public class MapRZKRMFinderUtils {
    private static final Log LOG = LogFactory.getLog(MapRZKRMFinderUtils.class);
    private static final Map<String, ZKDataRetrieval> zkConnectionMap = new HashMap<String, ZKDataRetrieval>();
    public static final Map<String, String> propertyMapping = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Common.ServiceData mapRZkBasedRMFinder(Configuration conf, String serviceName) {
        ZKDataRetrieval zkConnection;
        String zkAddress = null;
        if (conf == null) {
            LOG.error((Object)"Can not get RM address since passed config object is null");
            throw new RuntimeException("Can not get RM address since passed config object is null");
        }
        try {
            FileSystem fs = FileSystem.get((Configuration)conf);
            zkAddress = fs.getZkConnectString();
        }
        catch (IOException e) {
            LOG.error((Object)"Zookeeper address not found from MapRFilesystem. Will try the configuration from yarn-site.xml", (Throwable)e);
        }
        if (zkAddress == null) {
            LOG.error((Object)"Zookeeper address not found from MapRFilesystem. Will try the configuration from yarn-site.xml");
            zkAddress = conf.get("yarn.resourcemanager.zk-address");
        }
        if (zkAddress == null) {
            LOG.error((Object)"Zookeeper address not configured in Yarn configuration. Please check yarn-site.xml.");
            LOG.error((Object)"Unable to determine ResourceManager service address from Zookeeper.");
            throw new RuntimeException("Zookeeper address not found from MapR Filesystem and is also not configured in Yarn configuration.");
        }
        Map<String, ZKDataRetrieval> map = zkConnectionMap;
        synchronized (map) {
            zkConnection = zkConnectionMap.get(zkAddress);
            if (zkConnection == null) {
                zkConnection = new ZKDataRetrieval(zkAddress);
                zkConnectionMap.put(zkAddress, zkConnection);
            }
        }
        Common.ServiceData hostInfo = zkConnection.getServiceMasterData(serviceName);
        if (hostInfo == null) {
            LOG.error((Object)("Unable to determine ResourceManager service address from Zookeeper at " + zkAddress));
            throw new RuntimeException("Unable to determine ResourceManager service address from Zookeeper at " + zkAddress);
        }
        return hostInfo;
    }

    static {
        propertyMapping.put("SCHEDULER_PORT", "yarn.resourcemanager.scheduler.address");
        propertyMapping.put("WEBAPP_PORT", "yarn.resourcemanager.webapp.address");
        propertyMapping.put("WEBAPP_HTTPS_PORT", "yarn.resourcemanager.webapp.https.address");
        propertyMapping.put("RESOURCETRACKER_PORT", "yarn.resourcemanager.resource-tracker.address");
        propertyMapping.put("ADMIN_PORT", "yarn.resourcemanager.admin.address");
    }
}

