/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import com.mapr.fs.proto.Common;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.client.MapRZKRMFinderUtils;
import org.apache.hadoop.yarn.conf.CustomRMAddressFinder;

public class MapRZKBasedRMAddressFinder
extends CustomRMAddressFinder {
    private static final Log LOG = LogFactory.getLog(MapRZKBasedRMAddressFinder.class);

    public String getRMAddress(Configuration conf, String address, String defaultAddr, int defaultPort) {
        Common.ServiceData hostInfo = MapRZKRMFinderUtils.mapRZkBasedRMFinder(conf, "resourcemanager");
        String hostName = hostInfo.getHost();
        int rmAddressPort = hostInfo.getPort();
        conf.set("yarn.resourcemanager.hostname", hostName);
        String currentRMAddress = hostName + ":" + rmAddressPort;
        conf.set("yarn.resourcemanager.address", currentRMAddress);
        LOG.info((Object)("Updated RM address to " + currentRMAddress));
        if ("yarn.resourcemanager.address".equals(address)) {
            return currentRMAddress;
        }
        for (Common.ExtendedInfo extInfo : hostInfo.getExtinfoList()) {
            int portNumber;
            String portPropertyName = extInfo.getKey();
            String yarnBasedProperty = MapRZKRMFinderUtils.propertyMapping.get(portPropertyName);
            try {
                portNumber = Integer.valueOf(extInfo.getValue());
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)("Unable to get portNumber from RM Warden Configuration. Property: " + portPropertyName + "will use default one"), (Throwable)e);
                portNumber = defaultPort;
            }
            if (yarnBasedProperty == null || !yarnBasedProperty.equalsIgnoreCase(address)) continue;
            currentRMAddress = hostName + ":" + portNumber;
            conf.set(address, currentRMAddress);
            return currentRMAddress;
        }
        LOG.warn((Object)("Could not find respective property: " + address + " in ZK. Returning YarnConfiguration.RM_ADDRESS"));
        return hostName + ":" + defaultPort;
    }
}

