/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import com.mapr.fs.proto.Common;
import com.mapr.util.zookeeper.ZKDataRetrieval;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.yarn.client.RMFailoverProxyProvider;
import org.apache.hadoop.yarn.client.RMProxy;
import org.apache.hadoop.yarn.conf.YarnConfiguration;

public class MapRZKBasedRMFailoverProxyProvider<T>
implements RMFailoverProxyProvider<T> {
    private static final Log LOG = LogFactory.getLog(MapRZKBasedRMFailoverProxyProvider.class);
    private RMProxy<T> rmProxy;
    private YarnConfiguration conf;
    private Class<T> protocol;
    private T currentProxy;
    private InetSocketAddress currentRMAddress;
    private ZKDataRetrieval zkConnection;
    private FileSystem fs;
    private String lastZKAddress;

    public void init(Configuration conf, RMProxy<T> proxy, Class<T> protocol) {
        this.rmProxy = proxy;
        this.protocol = protocol;
        this.rmProxy.checkAllowedProtocols(this.protocol);
        this.conf = new YarnConfiguration(conf);
        this.lastZKAddress = null;
        this.zkConnection = null;
        this.fs = null;
        conf.setInt("ipc.client.connect.max.retries", conf.getInt("yarn.client.failover-retries", 0));
        conf.setInt("ipc.client.connect.max.retries.on.timeouts", conf.getInt("yarn.client.failover-retries-on-socket-timeouts", 0));
    }

    private void updateCurrentRMAddress() {
        Common.ServiceData hostInfo;
        String zkAddress = null;
        try {
            if (this.fs == null) {
                this.fs = FileSystem.get((Configuration)this.conf);
            }
            zkAddress = this.fs.getZkConnectString();
        }
        catch (IOException e) {
            LOG.error((Object)"Zookeeper address not found from MapRFilesystem. Will try the configuration from yarn-site.xml", (Throwable)e);
        }
        if (zkAddress == null) {
            LOG.error((Object)"Zookeeper address not found from MapRFilesystem. Will try the configuration from yarn-site.xml");
            zkAddress = this.conf.get("yarn.resourcemanager.zk-address");
        }
        if (zkAddress == null) {
            LOG.error((Object)"Zookeeper address not configured in Yarn configuration. Please check yarn-site.xml.");
            LOG.error((Object)"Unable to determine ResourceManager service address from Zookeeper.");
            throw new RuntimeException("Zookeeper address not found from MapR Filesystem and is also not configured in Yarn configuration.");
        }
        if (this.zkConnection == null || zkAddress != this.lastZKAddress) {
            this.zkConnection = new ZKDataRetrieval(zkAddress);
            this.lastZKAddress = zkAddress;
        }
        if ((hostInfo = this.zkConnection.getServiceMasterData("resourcemanager")) == null) {
            LOG.error((Object)("Unable to determine ResourceManager service address from Zookeeper at " + zkAddress));
            throw new RuntimeException("Unable to determine ResourceManager service address from Zookeeper at " + zkAddress);
        }
        String hostName = hostInfo.getHost();
        int rmAddressPort = hostInfo.getPort();
        this.conf.set("yarn.resourcemanager.hostname", hostName);
        if (rmAddressPort != 8032) {
            this.conf.set("yarn.resourcemanager.address", hostName + ":" + rmAddressPort);
        }
        for (Common.ExtendedInfo extInfo : hostInfo.getExtinfoList()) {
            int portNumber;
            String portPropertyName = extInfo.getKey();
            try {
                portNumber = Integer.valueOf(extInfo.getValue());
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)("Unable to get portNumber from RM Warden Configuration. Property: " + portPropertyName), (Throwable)e);
                continue;
            }
            int defaultYarnPort = -1;
            String addressProperty = null;
            switch (portPropertyName) {
                case "SCHEDULER_PORT": {
                    defaultYarnPort = 8030;
                    addressProperty = "yarn.resourcemanager.scheduler.address";
                    break;
                }
                case "WEBAPP_PORT": {
                    defaultYarnPort = 8088;
                    addressProperty = "yarn.resourcemanager.webapp.address";
                    break;
                }
                case "WEBAPP_HTTPS_PORT": {
                    defaultYarnPort = 8090;
                    addressProperty = "yarn.resourcemanager.webapp.https.address";
                    break;
                }
                case "RESOURCETRACKER_PORT": {
                    defaultYarnPort = 8031;
                    addressProperty = "yarn.resourcemanager.resource-tracker.address";
                    break;
                }
                case "ADMIN_PORT": {
                    defaultYarnPort = 8033;
                    addressProperty = "yarn.resourcemanager.admin.address";
                }
            }
            if (defaultYarnPort == -1 || addressProperty == null || defaultYarnPort == portNumber) continue;
            this.conf.set(addressProperty, hostName + ":" + portNumber);
        }
        try {
            this.currentRMAddress = this.rmProxy.getRMAddress(this.conf, this.protocol);
        }
        catch (IOException e) {
            LOG.error((Object)("Unable to get RM address for RM at " + hostName + " and protocol " + this.protocol));
            throw new RuntimeException("Unable to get RM address for RM at " + hostName + " and protocol " + this.protocol, e);
        }
        LOG.info((Object)("Updated RM address to " + this.currentRMAddress));
    }

    public synchronized FailoverProxyProvider.ProxyInfo<T> getProxy() {
        if (this.currentProxy == null) {
            try {
                this.updateCurrentRMAddress();
                this.currentProxy = RMProxy.getProxy((Configuration)this.conf, this.protocol, (InetSocketAddress)this.currentRMAddress);
            }
            catch (Exception e) {
                LOG.error((Object)("Unable to create proxy to the ResourceManager " + this.currentRMAddress));
                throw new RuntimeException("Unable to create proxy to the ResourceManager " + this.currentRMAddress, e);
            }
        }
        return new FailoverProxyProvider.ProxyInfo(this.currentProxy, "ResourceManager at " + this.currentRMAddress);
    }

    public synchronized void performFailover(T currentProxy) {
        this.currentProxy = null;
    }

    public Class<T> getInterface() {
        return this.protocol;
    }

    public synchronized void close() throws IOException {
        if (this.currentProxy instanceof Closeable) {
            ((Closeable)this.currentProxy).close();
        } else {
            RPC.stopProxy(this.currentProxy);
        }
    }
}

