/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.marlin.listener;

import com.mapr.fs.marlin.listener.ListenerRecord;
import com.mapr.fs.marlin.listener.MarlinListenerImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.consumer.CommitType;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.ConsumerRebalanceCallback;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.mapr.AbstractConsumer;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarlinListener<K, V>
extends AbstractConsumer<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(MarlinListener.class);
    private final Deserializer<K> _keyDeserializer;
    private final Deserializer<V> _valueDeserializer;
    private final MarlinListenerImpl _listener;

    public MarlinListener(ConsumerConfig config, ConsumerRebalanceCallback callback, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        LOG.debug("Starting Marlin Listener");
        if (callback == null) {
            callback = (ConsumerRebalanceCallback)config.getConfiguredInstance("rebalance.callback.class", ConsumerRebalanceCallback.class);
        }
        this._keyDeserializer = keyDeserializer == null ? (Deserializer)config.getConfiguredInstance("key.deserializer", Deserializer.class) : keyDeserializer;
        this._valueDeserializer = valueDeserializer == null ? (Deserializer)config.getConfiguredInstance("value.deserializer", Deserializer.class) : valueDeserializer;
        this._listener = new MarlinListenerImpl(config, (Consumer)this, callback);
        LOG.debug("Marlin listener created");
    }

    public Set<TopicPartition> subscriptions() {
        return this._listener.subscriptions();
    }

    public void subscribe(String ... topics) {
        this._listener.subscribe(topics);
    }

    public void subscribe(TopicPartition ... partitions) {
        this._listener.subscribe(partitions);
    }

    public void unsubscribe(String ... topics) {
        this._listener.unsubscribe(topics);
    }

    public void unsubscribe(TopicPartition ... partitions) {
        this._listener.unsubscribe(partitions);
    }

    public ConsumerRecords<K, V> poll(long timeout) {
        Map<TopicPartition, List<ListenerRecord>> marlinRecMap = this._listener.poll(timeout);
        HashMap kafkaRecMap = new HashMap();
        Iterator<Map.Entry<TopicPartition, List<ListenerRecord>>> it = marlinRecMap.entrySet().iterator();
        while (it.hasNext()) {
            boolean feedsAdded = false;
            Map.Entry<TopicPartition, List<ListenerRecord>> entry = it.next();
            TopicPartition partition = entry.getKey();
            List<ListenerRecord> feedRecords = entry.getValue();
            ArrayList<ConsumerRecord<K, V>> partitionRecords = new ArrayList<ConsumerRecord<K, V>>();
            for (ListenerRecord feedRec : feedRecords) {
                feedsAdded = true;
                partitionRecords.add(feedRec.toKafkaConsumerRecord(this._keyDeserializer, this._valueDeserializer));
            }
            if (!feedsAdded) continue;
            kafkaRecMap.put(partition, partitionRecords);
        }
        return new ConsumerRecords(kafkaRecMap);
    }

    public void commit(Map<TopicPartition, Long> offsets, CommitType commitType) {
        this._listener.commit(offsets, commitType);
    }

    public void commit(CommitType commitType) {
        this._listener.commit(commitType);
    }

    public void seek(TopicPartition partition, long offset) {
        this._listener.seek(partition, offset);
    }

    public void seekToBeginning(TopicPartition ... partitions) {
        this._listener.seekToBeginning(partitions);
    }

    public void seekToEnd(TopicPartition ... partitions) {
        this._listener.seekToEnd(partitions);
    }

    public long position(TopicPartition partition) {
        return this._listener.position(partition);
    }

    public long committed(TopicPartition partition) {
        return this._listener.committed(partition);
    }

    public Map<MetricName, ? extends Metric> metrics() {
        return null;
    }

    public List<PartitionInfo> partitionsFor(String topic) {
        return this._listener.getTopicInfo(topic);
    }

    public void close() {
        this._listener.close();
    }

    public void wakeup() {
    }
}

