/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.marlin.listener;

import java.nio.ByteBuffer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.serialization.Deserializer;

public final class ListenerRecord {
    private final String topic;
    private final int feedId;
    private final long offset;
    private final byte[] key;
    private final byte[] value;

    public ListenerRecord(String topic, int feedId, long offset, byte[] key, byte[] value) {
        if (topic == null) {
            throw new IllegalArgumentException("Topic cannot be null");
        }
        this.topic = topic;
        this.feedId = feedId;
        this.offset = offset;
        this.key = key;
        this.value = value;
    }

    public <K, V> ConsumerRecord<K, V> toKafkaConsumerRecord(Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        Object kkey = null;
        if (this.key != null) {
            ByteBuffer keyBytes = ByteBuffer.wrap(this.key);
            kkey = keyDeserializer.deserialize(this.topic, this.key);
        }
        Object kvalue = null;
        if (this.value != null) {
            ByteBuffer valueBytes = ByteBuffer.wrap(this.value);
            kvalue = valueDeserializer.deserialize(this.topic, this.value);
        }
        return new ConsumerRecord(this.topic, this.feedId, this.offset, kkey, kvalue);
    }

    public String topic() {
        return this.topic;
    }

    public int feedId() {
        return this.feedId;
    }

    public byte[] key() throws Exception {
        return this.key;
    }

    public byte[] value() throws Exception {
        return this.value;
    }

    public long offset() {
        return this.offset;
    }

    public String toString() {
        return "ListenerRecord(topic = " + this.topic() + ", feedId = " + this.feedId() + ", offset = " + this.offset() + ", key = " + this.key + ", value = " + this.value + ")";
    }
}

