/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.marlin;

import com.mapr.db.DBDocument;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.fs.marlin.MarlinRecord;
import com.mapr.fs.proto.Marlinserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarlinRowKeyDecoder {
    static final Logger LOG = LoggerFactory.getLogger(MarlinRowKeyDecoder.class);
    private Marlinserver.MarlinInternalDefaults mdef = Marlinserver.MarlinInternalDefaults.getDefaultInstance();

    public DBDocument decodeMsgKey(String key) throws IllegalArgumentException {
        DBDocumentImpl doc = new DBDocumentImpl();
        int offset = 0;
        offset = this.decodePartition(key, offset, (DBDocument)doc);
        offset = this.decodeTopic(key, offset, (DBDocument)doc);
        offset = this.decodeTopicUniq(key, offset, (DBDocument)doc);
        offset = this.decodeSeq(key, offset, (DBDocument)doc);
        return doc;
    }

    public DBDocument decodeTopicFeedKey(String key) throws IllegalArgumentException {
        DBDocumentImpl doc = new DBDocumentImpl();
        int offset = 0;
        offset = this.decodePartition(key, offset, (DBDocument)doc);
        offset = this.decodeTopic(key, offset, (DBDocument)doc);
        offset = this.decodeTopicUniq(key, offset, (DBDocument)doc);
        return doc;
    }

    public DBDocument decodeCursorKey(String key) throws IllegalArgumentException {
        DBDocumentImpl doc = new DBDocumentImpl();
        int offset = 0;
        offset += this.matchCursorPrefix(key, offset);
        offset = this.decodeTopic(key, offset, (DBDocument)doc);
        offset = this.decodeTopicUniq(key, offset, (DBDocument)doc);
        offset = this.decodePartition(key, offset, (DBDocument)doc);
        offset = this.decodeGroup(key, offset, (DBDocument)doc);
        return doc;
    }

    public DBDocument decodeAssignKey(String key) throws IllegalArgumentException {
        DBDocumentImpl doc = new DBDocumentImpl();
        int offset = 0;
        offset = this.matchAssignPrefix(key, offset);
        offset = this.decodeTopic(key, offset, (DBDocument)doc);
        offset = this.decodeTopicUniq(key, offset, (DBDocument)doc);
        offset = this.decodeGroup(key, offset, (DBDocument)doc);
        return doc;
    }

    private int decodePartition(String key, int offset, DBDocument doc) throws IllegalArgumentException {
        String prefix = this.mdef.getKeyPrefixFeedId();
        if (!this.matchPrefix(key, offset, prefix)) {
            throw new IllegalArgumentException("Invalid partition prefix at offset " + offset + " in key " + key);
        }
        long lval = this.decodeHexBytes(key, offset += prefix.length(), this.mdef.getKeyWidthFeedId());
        if (lval < 0L) {
            throw new IllegalArgumentException("Invalid partition id at offset " + offset + " in key " + key);
        }
        doc.set(MarlinRecord.PARTITION, (int)lval);
        return offset += this.mdef.getKeyWidthFeedId();
    }

    private int decodeTopic(String key, int offset, DBDocument doc) throws IllegalArgumentException {
        String prefix = this.mdef.getKeyPrefixTopicName();
        if (!this.matchPrefix(key, offset, prefix)) {
            throw new IllegalArgumentException("Invalid topic prefix at offset " + offset + " in key " + key);
        }
        int index = key.indexOf(58, offset += prefix.length());
        if (index < -1) {
            throw new IllegalArgumentException("Topic delimiter ':' missing in key " + key);
        }
        if (index - offset == 0) {
            throw new IllegalArgumentException("Empty topic in key " + key);
        }
        doc.set(MarlinRecord.TOPIC, key.substring(offset, index));
        offset = index + 1;
        return offset;
    }

    private int decodeTopicUniq(String key, int offset, DBDocument doc) throws IllegalArgumentException {
        long lval = this.decodeHexBytes(key, offset, this.mdef.getKeyWidthTopicUniq());
        if (lval < 0L) {
            throw new IllegalArgumentException("Invalid topicUniq at offset " + offset + " in key " + key);
        }
        doc.set(MarlinRecord.TOPIC_UNIQ, (int)lval);
        return offset += this.mdef.getKeyWidthTopicUniq();
    }

    private int decodeSeq(String key, int offset, DBDocument doc) throws IllegalArgumentException {
        long lval = this.decodeHexBytes(key, offset, this.mdef.getKeyWidthSeq());
        if (lval < 0L) {
            throw new IllegalArgumentException("Invalid seq at offset " + offset + " in key " + key);
        }
        doc.set(MarlinRecord.SEQUENCE_NUMBER, lval);
        return offset;
    }

    private int decodeGroup(String key, int offset, DBDocument doc) throws IllegalArgumentException {
        String prefix = this.mdef.getKeyPrefixGroup();
        if (!this.matchPrefix(key, offset, prefix)) {
            throw new IllegalArgumentException("Invalid group prefix at offset " + offset + " in key " + key);
        }
        if ((offset += prefix.length()) == key.length()) {
            throw new IllegalArgumentException("Empty listener group id  in key " + key);
        }
        doc.set(MarlinRecord.LISTENER_GROUP, key.substring(offset));
        return key.length();
    }

    private long decodeHexBytes(String key, int offset, int width) {
        long value = 0L;
        if (offset + width > key.length()) {
            return -1L;
        }
        for (int i = 0; i < width; ++i) {
            long hval = this.isHexDigit(key.charAt(offset + i));
            if (hval < 0L) {
                return -1L;
            }
            value = value * 16L + hval;
        }
        return value;
    }

    private long isHexDigit(char c) {
        if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f') {
            return Character.digit(c, 16);
        }
        return -1L;
    }

    private boolean matchPrefix(String key, int offset, String prefix) {
        if (offset + prefix.length() > key.length()) {
            return false;
        }
        String subStr = key.substring(offset, offset + prefix.length());
        return subStr.equals(prefix);
    }

    private int matchCursorPrefix(String key, int offset) throws IllegalArgumentException {
        String prefix = this.mdef.getKeyCursorPrefix();
        if (!this.matchPrefix(key, offset, prefix)) {
            throw new IllegalArgumentException("Invalid cursor prefix at offset " + offset + " in key " + key);
        }
        return offset + prefix.length();
    }

    private int matchAssignPrefix(String key, int offset) throws IllegalArgumentException {
        String prefix = this.mdef.getKeyAssignPrefix();
        if (!this.matchPrefix(key, offset, prefix)) {
            throw new IllegalArgumentException("Invalid assign prefix at offset " + offset + " in key " + key);
        }
        return offset + prefix.length();
    }
}

