/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.marlin;

import com.mapr.db.DBDocument;
import com.mapr.fs.marlin.MarlinRecord;
import com.mapr.fs.marlin.MarlinRowKeyDecoder;
import com.mapr.fs.proto.Marlinserver;
import java.util.List;
import org.ojai.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarlinRecordTranslator {
    static final Logger LOG = LoggerFactory.getLogger(MarlinRecordTranslator.class);
    private static Marlinserver.MarlinInternalDefaults mdef;
    private MarlinRowKeyDecoder rowKeyDecoder;
    private DBDocument rowKeyDoc;
    private List<Object> rowValueDocs;
    private int indexInRow;

    public MarlinRecordTranslator(DBDocument dbRecord) throws Exception {
        mdef = Marlinserver.MarlinInternalDefaults.getDefaultInstance();
        this.rowKeyDecoder = new MarlinRowKeyDecoder();
        this.rowKeyDoc = this.rowKeyDecoder.decodeMsgKey(dbRecord.getIdString());
        this.rowValueDocs = dbRecord.getList(mdef.getFMsgsList());
        this.indexInRow = 0;
    }

    public boolean hasNext() {
        if (this.rowValueDocs == null) {
            return false;
        }
        return this.indexInRow < this.rowValueDocs.size();
    }

    public Document next() {
        int cur = this.indexInRow++;
        DBDocument valueDoc = (DBDocument)this.rowValueDocs.get(cur);
        return new MarlinRecord(this.rowKeyDoc, valueDoc, cur);
    }
}

