/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.marlin;

import com.mapr.baseutils.Errno;
import com.mapr.fs.marlin.jni.MarlinJniClient;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;

public abstract class MarlinClient
extends MarlinJniClient {
    public long _clntPtr = 0L;

    public RuntimeException jniErrToException(int errCode) {
        if (errCode < 0) {
            errCode = -errCode;
        }
        switch (errCode) {
            case 0: {
                return null;
            }
            case 1: {
                return new UnknownTopicOrPartitionException(Errno.toString((int)errCode) + " (" + errCode + ")");
            }
            case 2: {
                return new UnknownTopicOrPartitionException(Errno.toString((int)errCode) + " (" + errCode + ")");
            }
            case 116: {
                return new UnknownTopicOrPartitionException(Errno.toString((int)errCode) + " (" + errCode + ")");
            }
            case 13: {
                return new IllegalArgumentException(Errno.toString((int)errCode) + " (" + errCode + ")");
            }
            case 62: {
                return new TimeoutException(Errno.toString((int)errCode) + " (" + errCode + ")");
            }
            case 5: {
                return new CorruptRecordException(Errno.toString((int)errCode) + " (" + errCode + ")");
            }
            case 22: {
                return new IllegalArgumentException(Errno.toString((int)errCode) + " (" + errCode + ")");
            }
        }
        return new KafkaException(Errno.toString((int)errCode) + " (" + errCode + ")");
    }

    static {
        try {
            String marlinNativeLibPath = null;
            String maprHome = System.getenv("MAPR_HOME");
            if (maprHome == null) {
                maprHome = "/opt/mapr";
            }
            marlinNativeLibPath = maprHome + "/lib/libMarlinNative.so";
            System.load(marlinNativeLibPath);
        }
        catch (Throwable throwable) {
            System.err.println("Unable to load libMarlinNative.so : " + throwable.getMessage());
            System.exit(1);
        }
    }
}

