/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.hbase;

import com.mapr.fs.hbase.BufferedMutatorCallBackQueue;
import com.mapr.fs.hbase.FilterSerializer;
import com.mapr.fs.hbase.HTableImpl;
import com.mapr.fs.hbase.PutConverter;
import com.mapr.fs.hbase.RowConstraintConverter;
import com.mapr.fs.jni.MapRCallBackQueue;
import com.mapr.fs.jni.MapRPut;
import com.mapr.fs.jni.MapRRowConstraint;
import com.mapr.fs.proto.Dbfilters;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.util.Bytes;

public class HTableImpl11
extends HTableImpl {
    private static final Log LOG = LogFactory.getLog(HTableImpl11.class);
    private final BufferedMutatorCallBackQueue bfcbq_;

    public HTableImpl11(Configuration conf, byte[] tableName) throws IOException {
        super(conf, tableName);
        this.bfcbq_ = null;
    }

    public HTableImpl11(Configuration conf, byte[] tableName, BufferedMutator bm, BufferedMutator.ExceptionListener listener, ExecutorService pool) throws IOException {
        super(conf, tableName);
        if (listener != null && pool == null) {
            throw new IOException("No MapRClusterConnection provided to serve the callbacks for BufferedMutator Listener.");
        }
        this.bfcbq_ = listener != null ? new BufferedMutatorCallBackQueue(bm, listener, this.maprTable, pool) : null;
    }

    @Override
    public void close() throws IOException {
        if (this.bfcbq_ != null) {
            this.bfcbq_.shutdown();
        }
        this.maprTable.close();
    }

    @Override
    public void put(Put put) throws InterruptedIOException {
        try {
            this.checkMutation((Mutation)put);
            MapRPut mput = null;
            if (!this.autoFlush) {
                mput = PutConverter.toMapRPut(put, this.maprTable, (Object)put, (MapRCallBackQueue)this.bfcbq_);
                this.maprTable.put(mput);
            } else {
                mput = PutConverter.toMapRPut(put, this.maprTable);
                this.maprTable.syncPut(mput, true);
            }
        }
        catch (IOException e) {
            throw (InterruptedIOException)new InterruptedIOException(e.getMessage()).initCause(e);
        }
    }

    @Override
    public void put(List<Put> puts) throws InterruptedIOException {
        try {
            MapRPut[] mputs = new MapRPut[puts.size()];
            int i = 0;
            for (Put put : puts) {
                this.checkMutation((Mutation)put);
                if (!this.autoFlush) {
                    mputs[i++] = PutConverter.toMapRPut(put, this.maprTable, (Object)put, (MapRCallBackQueue)this.bfcbq_);
                    continue;
                }
                mputs[i++] = PutConverter.toMapRPut(put, this.maprTable);
            }
            if (!this.autoFlush) {
                this.maprTable.put(mputs);
            } else {
                this.maprTable.syncPut(mputs, true);
            }
        }
        catch (IOException e) {
            throw (InterruptedIOException)new InterruptedIOException(e.getMessage()).initCause(e);
        }
    }

    public MapRPut syncMutateToMapRPut(byte[] row, Mutation mut) throws IOException {
        this.checkMutation(mut);
        if (!Bytes.equals((byte[])row, (byte[])mut.getRow())) {
            throw new DoNotRetryIOException("mutation's getRow must match the passed row");
        }
        MapRPut mput = null;
        if (mut instanceof Put) {
            mput = PutConverter.toMapRPut((Put)mut, this.maprTable);
        } else if (mut instanceof Delete) {
            mput = PutConverter.toMapRPut((Delete)mut, this.maprTable);
        } else {
            throw new IOException("Mutations can only be put or delete");
        }
        return mput;
    }

    @Override
    public boolean checkAndMutateImpl(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, RowMutations rm, boolean throwerr) throws IOException {
        if (rm.getMutations().size() <= 0) {
            LOG.error((Object)"Missing mutations ");
            return false;
        }
        if (qualifier == null) {
            LOG.error((Object)"Missing qualifier ");
            return false;
        }
        if (qualifier == HConstants.EMPTY_BYTE_ARRAY) {
            LOG.error((Object)"Empty qualifier ");
            return false;
        }
        if (compareOp == CompareFilter.CompareOp.NO_OP) {
            return false;
        }
        HTableImpl.FamilyInfo fInfo = null;
        try {
            fInfo = this.getFamilyInfo(row, family);
        }
        catch (NoSuchColumnFamilyException e) {
            LOG.error((Object)("Family " + Bytes.toStringBinary((byte[])family) + " not exist :" + e.getMessage()));
            if (throwerr) {
                throw e;
            }
            return false;
        }
        if (fInfo == null) {
            LOG.error((Object)("Get family info returns null for Family " + Bytes.toStringBinary((byte[])family)));
            return false;
        }
        int i = 0;
        MapRPut[] mputs = new MapRPut[rm.getMutations().size()];
        for (Mutation m : rm.getMutations()) {
            MapRPut mput = this.syncMutateToMapRPut(row, m);
            mputs[i++] = mput;
        }
        MapRRowConstraint checkConstraint = null;
        checkConstraint = RowConstraintConverter.toRowConstraint(this.maprTable, family, qualifier);
        checkConstraint.maxVersions = 1;
        Dbfilters.FilterMsg filterMsg = null;
        boolean checkForNonExist = false;
        if (value != null) {
            checkForNonExist = false;
            BinaryComparator bcomparator = new BinaryComparator(value);
            SingleColumnValueFilter scvfilter = new SingleColumnValueFilter(family, qualifier, compareOp, (ByteArrayComparable)bcomparator);
            filterMsg = FilterSerializer.serialize((Filter)scvfilter);
        } else if (compareOp == CompareFilter.CompareOp.NOT_EQUAL) {
            checkForNonExist = false;
        } else if (compareOp == CompareFilter.CompareOp.EQUAL) {
            checkForNonExist = true;
        } else {
            checkForNonExist = true;
            LOG.info((Object)(compareOp.toString() + " is not applicable to null value, changing it to EQUAL"));
        }
        return this.maprTable.checkAndMutate(row, fInfo.useCf, checkForNonExist, checkConstraint, filterMsg, mputs, this.flushOnRead);
    }
}

