/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.hbase;

import com.mapr.fs.MapRHTable;
import com.mapr.fs.hbase.FilterSerializer;
import com.mapr.fs.hbase.RowConstraintConverter;
import com.mapr.fs.jni.MapRGet;
import com.mapr.fs.jni.MapRResult;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.util.Bytes;

public class GetConverter {
    public static MapRGet[] toMapRGets(List<Get> gets, MapRHTable htable) throws IOException {
        MapRGet[] mgets = new MapRGet[gets.size()];
        int i = 0;
        for (Get get : gets) {
            mgets[i] = GetConverter.toMapRGet(get, htable);
            mgets[i].listIndex = i++;
        }
        Arrays.sort(mgets, new Comparator<MapRGet>(){

            @Override
            public int compare(MapRGet o1, MapRGet o2) {
                return Bytes.compareTo((byte[])o1.key, (byte[])o2.key);
            }
        });
        return mgets;
    }

    public static MapRGet toMapRGet(Get get, MapRHTable htable) throws IOException {
        MapRGet mrget = new MapRGet();
        mrget.result = new MapRResult();
        mrget.key = get.getRow();
        mrget.rowConstraint = RowConstraintConverter.toRowConstraint(htable, get.getFamilyMap(), get.getMaxVersions(), get.getTimeRange().getMin(), get.getTimeRange().getMax());
        if (get.getFilter() != null) {
            mrget.setFilter(FilterSerializer.serialize(get.getFilter()).toByteArray());
        }
        mrget.setEncodedResult(false);
        return mrget;
    }
}

