/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.hbase.test;

import com.mapr.fs.hbase.HTableDescriptorProxy;
import java.net.URI;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TestMultithreadedTuncate
extends Configured
implements Tool {
    private static final byte[] F = "f".getBytes();
    private static final byte[] Q = "qual".getBytes();
    private static final byte[] ROW = "row".getBytes();
    private static final byte[] LONG = "long".getBytes();
    private final Put PUT = new Put(ROW);
    private final byte[] VALUE = new byte[32];
    private final Random RAND = new Random(System.currentTimeMillis());
    private FileSystem fs;
    private HBaseAdmin admin;
    private HTable table;
    private TableName tablePath;
    private HTableDescriptor tableDesc;
    private ExecutorService executor;
    private int numThreads;
    private Path folder = new Path("/tmp/multi/level/dir");
    private Path tableName = new Path(this.folder, "TestMultithreadedTuncate");
    private int failureCount;

    public TestMultithreadedTuncate(Configuration conf) {
        super(conf);
        this.tablePath = TableName.valueOf((String)this.tableName.toString());
        this.tableDesc = new HTableDescriptor(this.tablePath);
        HTableDescriptorProxy.addFamily((HTableDescriptor)this.tableDesc, (HColumnDescriptor)new HColumnDescriptor(F));
        this.RAND.nextBytes(this.VALUE);
        this.PUT.add(F, Q, this.VALUE);
    }

    public int run(String[] args) throws Exception {
        int code = 0;
        this.fs = FileSystem.get((URI)new URI("maprfs:///"), (Configuration)this.getConf());
        this.fs.delete(this.folder, true);
        this.fs.mkdirs(this.folder);
        this.admin = new HBaseAdmin(this.getConf());
        this.admin.createTable(this.tableDesc);
        this.table = new HTable(this.getConf(), this.tablePath);
        this.numThreads = Math.max(Runtime.getRuntime().availableProcessors(), 10);
        this.executor = Executors.newFixedThreadPool(this.numThreads);
        this.executor.submit(new TruncateTable());
        for (int i = 0; i < this.numThreads - 1; ++i) {
            this.executor.submit(new DoDBOps());
        }
        int durationInSeconds = 60;
        Timer timer = new Timer();
        timer.schedule((TimerTask)new ShutdownTask(), durationInSeconds * 1000);
        this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        if (this.failureCount > 0) {
            System.out.println(this.failureCount + " threads failed with error.");
        } else {
            System.out.println("No failures occurred.");
        }
        return code;
    }

    public static void main(String[] args) throws Exception {
        int ret = ToolRunner.run((Tool)new TestMultithreadedTuncate(HBaseConfiguration.create()), (String[])args);
        System.exit(ret);
    }

    class ShutdownTask
    extends TimerTask {
        ShutdownTask() {
        }

        @Override
        public void run() {
            TestMultithreadedTuncate.this.executor.shutdownNow();
        }
    }

    class TruncateTable
    implements Callable<Void> {
        TruncateTable() {
        }

        @Override
        public Void call() throws Exception {
            try {
                while (true) {
                    Thread.sleep(1000 + (int)(4000.0 * Math.random()));
                    if ((int)(3.0 * Math.random()) == 1) {
                        TestMultithreadedTuncate.this.admin.truncateTable(TestMultithreadedTuncate.this.tablePath, true);
                        TestMultithreadedTuncate.this.table.put(TestMultithreadedTuncate.this.PUT);
                        System.out.println("Table truncated.");
                        continue;
                    }
                    TestMultithreadedTuncate.this.fs.delete(TestMultithreadedTuncate.this.folder, true);
                    TestMultithreadedTuncate.this.fs.mkdirs(TestMultithreadedTuncate.this.folder);
                    TestMultithreadedTuncate.this.admin.createTable(TestMultithreadedTuncate.this.tableDesc);
                    TestMultithreadedTuncate.this.table.put(TestMultithreadedTuncate.this.PUT);
                    System.out.println("Table recreated.");
                }
            }
            catch (InterruptedException e) {
                System.out.println("TruncateTable shutting down");
                return null;
            }
        }
    }

    class DoDBOps
    implements Callable<Void> {
        DoDBOps() {
        }

        @Override
        public Void call() throws Exception {
            Append APPEND = new Append(ROW);
            APPEND.add(F, Q, TestMultithreadedTuncate.this.VALUE);
            Get GET = new Get(ROW);
            try {
                while (true) {
                    switch ((int)(Math.random() * 5.0)) {
                        case 0: {
                            TestMultithreadedTuncate.this.table.put(TestMultithreadedTuncate.this.PUT);
                            System.out.println("Put successful.");
                            break;
                        }
                        case 1: {
                            TestMultithreadedTuncate.this.table.incrementColumnValue(ROW, F, LONG, 1L);
                            System.out.println("Increament successful.");
                            break;
                        }
                        case 2: {
                            TestMultithreadedTuncate.this.table.append(APPEND);
                            System.out.println("Append successful.");
                            break;
                        }
                        case 3: {
                            ResultScanner scanner = TestMultithreadedTuncate.this.table.getScanner(F);
                            Result res = scanner.next();
                            scanner.close();
                            System.out.println("Scan successful. Result = " + res);
                            break;
                        }
                        default: {
                            TestMultithreadedTuncate.this.table.get(GET);
                            System.out.println("Get successful.");
                        }
                    }
                    Thread.sleep((long)(50.0 * Math.random()));
                }
            }
            catch (InterruptedException e) {
                System.out.println("DoDBOps shutting down");
            }
            catch (Throwable e) {
                TestMultithreadedTuncate.this.failureCount++;
                System.out.println("Uncaught exception " + e);
                e.printStackTrace();
                throw e;
            }
            return null;
        }
    }
}

