/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.hbase;

import com.mapr.fs.MapRHTable;
import com.mapr.fs.MapRResultScanner;
import com.mapr.fs.MapRTabletScanner;
import com.mapr.fs.hbase.FilterSerializer;
import com.mapr.fs.hbase.GetConverter;
import com.mapr.fs.hbase.HRegionConverter;
import com.mapr.fs.hbase.IncrementConverter;
import com.mapr.fs.hbase.PutConverter;
import com.mapr.fs.hbase.ResultConverter;
import com.mapr.fs.hbase.ResultScannerImpl;
import com.mapr.fs.hbase.RowConstraintConverter;
import com.mapr.fs.hbase.ScanConverter;
import com.mapr.fs.hbase.SchemaHelper;
import com.mapr.fs.jni.MapRGet;
import com.mapr.fs.jni.MapRIncrement;
import com.mapr.fs.jni.MapRPut;
import com.mapr.fs.jni.MapRRowConstraint;
import com.mapr.fs.jni.MapRScan;
import com.mapr.fs.proto.Dbfilters;
import com.mapr.fs.proto.Dbserver;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.UnmodifyableHTableDescriptor;
import org.apache.hadoop.hbase.client.mapr.AbstractHTable;
import org.apache.hadoop.hbase.client.mapr.TableMappingRulesFactory;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;

public class HTableImpl
extends AbstractHTable {
    private static final Log LOG = LogFactory.getLog(HTableImpl.class);
    public static final String CONFIG_PARAM_FLUSH_ON_READ = "fs.mapr.hbase.flushonread";
    private static final String OP_ATTRIBUTE_TTL = "_ttl";
    private boolean autoFlush;
    private boolean flushOnRead;
    private final MapRHTable maprTable;
    protected byte[] tableName;

    public HTableImpl(Configuration conf, byte[] tableName) throws IOException {
        try {
            this.maprTable = new MapRHTable();
            this.maprTable.init(conf, TableMappingRulesFactory.create((Configuration)conf).getMaprTablePath(tableName));
            this.tableName = Bytes.toBytes((String)this.maprTable.getTablePath().toUri().getPath());
            this.setFlushOnRead(conf.getBoolean(CONFIG_PARAM_FLUSH_ON_READ, false));
            this.autoFlush = true;
        }
        catch (FileNotFoundException e) {
            throw (TableNotFoundException)new TableNotFoundException().initCause((Throwable)e);
        }
        if (this.maprTable.isJson()) {
            throw new UnsupportedOperationException("HBase api's cannot be used for MapR-DB JSON tabletype tables.");
        }
    }

    public byte[] getTableName() {
        return this.tableName;
    }

    public Configuration getConfiguration() {
        return this.maprTable.getConf();
    }

    public void flushCommits() throws InterruptedIOException {
        try {
            this.maprTable.flushCommits();
        }
        catch (IOException e) {
            throw (InterruptedIOException)new InterruptedIOException(e.getMessage()).initCause(e);
        }
    }

    public void close() throws IOException {
        this.maprTable.close();
    }

    public HTableDescriptor getTableDescriptor() throws IOException {
        return new UnmodifyableHTableDescriptor(SchemaHelper.toHTableDescriptor(this.maprTable.getMapRFS(), this.maprTable.getTablePath()));
    }

    public boolean exists(Get get) throws IOException {
        Result r = this.get(get);
        return r != null && !r.isEmpty();
    }

    public Boolean[] exists(List<Get> gets) throws IOException {
        Result[] r;
        if (gets.size() == 0) {
            return new Boolean[0];
        }
        Boolean[] results = new Boolean[gets.size()];
        int i = 0;
        for (Result rElem : r = this.get(gets)) {
            results[i++] = rElem != null && !rElem.isEmpty();
        }
        return results;
    }

    /*
     * WARNING - void declaration
     */
    public void batch(List<? extends Row> actions, Object[] results) throws IOException, InterruptedException {
        int i = 0;
        HashMap<Object, Integer> resultMap = new HashMap<Object, Integer>(actions.size());
        ArrayList<Delete> deleteList = new ArrayList<Delete>(actions.size());
        ArrayList<Put> putList = new ArrayList<Put>(actions.size());
        ArrayList<Get> getList = new ArrayList<Get>(actions.size());
        for (Row row : actions) {
            if (!(row instanceof Mutation)) continue;
            this.checkMutation((Mutation)row);
        }
        for (Row row : actions) {
            if (row instanceof Delete) {
                deleteList.add((Delete)row);
                resultMap.put((Delete)row, new Integer(i));
            } else if (row instanceof Put) {
                putList.add((Put)row);
                resultMap.put((Put)row, new Integer(i));
            } else if (row instanceof Get) {
                getList.add((Get)row);
                resultMap.put((Get)row, new Integer(i));
            } else if (row instanceof Append) {
                results[i] = this.append((Append)row);
            } else if (row instanceof Increment) {
                results[i] = this.increment((Increment)row);
            } else if (row instanceof RowMutations) {
                throw new UnsupportedOperationException("No RowMutations in multi calls; use mutateRow");
            }
            ++i;
        }
        if (deleteList.size() > 0) {
            this.delete(deleteList);
            for (Delete delete : deleteList) {
                results[((Integer)resultMap.get((Object)delete)).intValue()] = new Result();
            }
        }
        if (putList.size() > 0) {
            this.put(putList);
            for (Put put : putList) {
                results[((Integer)resultMap.get((Object)put)).intValue()] = new Result();
            }
        }
        if (getList.size() > 0) {
            Result[] r = this.get(getList);
            boolean bl = false;
            for (Get g : getList) {
                void var9_17;
                results[((Integer)resultMap.get((Object)g)).intValue()] = r[var9_17];
                ++var9_17;
            }
        }
    }

    public Object[] batch(List<? extends Row> actions) throws IOException, InterruptedException {
        Object[] results = new Object[actions.size()];
        this.batch(actions, results);
        return results;
    }

    public Result get(Get get) throws IOException {
        MapRGet mget = GetConverter.toMapRGet(get, this.maprTable);
        this.maprTable.get(mget, this.flushOnRead);
        Result result = ResultConverter.createHBaseResult(mget, this.maprTable);
        if (mget.getArena() != 0L) {
            this.maprTable.freeArena(mget.getArena());
        }
        return result;
    }

    public Result[] get(List<Get> gets) throws IOException {
        if (gets.size() > 0) {
            MapRGet[] mgets = GetConverter.toMapRGets(gets, this.maprTable);
            this.maprTable.get(mgets, this.flushOnRead);
            Result[] results = ResultConverter.createHBaseResult(mgets, this.maprTable);
            if (mgets[0].getArena() != 0L) {
                this.maprTable.freeArena(mgets[0].getArena());
            }
            return results;
        }
        return null;
    }

    public Result getRowOrBefore(byte[] row, byte[] family) throws IOException {
        throw new UnsupportedOperationException("This is not supported for MapR table");
    }

    public ResultScanner getScanner(Scan scan) throws IOException {
        if (scan.isReversed()) {
            throw new UnsupportedOperationException("Reverse scan is not currently supported for MapR-DB table");
        }
        if (scan.isRaw()) {
            throw new UnsupportedOperationException("Raw scan is not currently supported for MapR-DB table");
        }
        MapRScan maprscan = ScanConverter.toMapRScan(scan, this.maprTable);
        maprscan.setFlushOnRead(this.flushOnRead);
        long id = this.maprTable.getScanner(maprscan);
        ResultScannerImpl scanner = new ResultScannerImpl(maprscan, this.maprTable, id);
        this.maprTable.addScanner((MapRResultScanner)scanner);
        return scanner;
    }

    public void put(Put put) throws InterruptedIOException {
        try {
            this.checkMutation((Mutation)put);
            MapRPut mput = PutConverter.toMapRPut(put, this.maprTable);
            if (!this.autoFlush) {
                this.maprTable.put(mput);
            } else {
                this.maprTable.syncPut(mput, true);
            }
        }
        catch (IOException e) {
            throw (InterruptedIOException)new InterruptedIOException(e.getMessage()).initCause(e);
        }
    }

    public void put(List<Put> puts) throws InterruptedIOException {
        try {
            MapRPut[] mputs = new MapRPut[puts.size()];
            int i = 0;
            for (Put put : puts) {
                this.checkMutation((Mutation)put);
                mputs[i++] = PutConverter.toMapRPut(put, this.maprTable);
            }
            if (!this.autoFlush) {
                this.maprTable.put(mputs);
            } else {
                this.maprTable.syncPut(mputs, true);
            }
        }
        catch (IOException e) {
            throw (InterruptedIOException)new InterruptedIOException(e.getMessage()).initCause(e);
        }
    }

    public FamilyInfo getFamilyInfo(byte[] row, byte[] family) throws NoSuchColumnFamilyException, IOException {
        FamilyInfo fInfo = new FamilyInfo();
        fInfo.useCf = true;
        if (family != null) {
            try {
                fInfo.familyId = this.maprTable.getFamilyId(Bytes.toString((byte[])family));
            }
            catch (IOException ioe) {
                throw (NoSuchColumnFamilyException)new NoSuchColumnFamilyException(ioe.toString()).initCause((Throwable)ioe);
            }
        } else {
            fInfo.useCf = false;
        }
        return fInfo;
    }

    public MapRPut MutateToMapRPut(byte[] row, Mutation mut) throws IOException {
        this.checkMutation(mut);
        if (!Bytes.equals((byte[])row, (byte[])mut.getRow())) {
            throw new DoNotRetryIOException("mutation's getRow must match the passed row");
        }
        MapRPut mput = null;
        if (mut instanceof Put) {
            mput = PutConverter.toMapRPut((Put)mut, this.maprTable);
        } else if (mut instanceof Delete) {
            mput = PutConverter.toMapRPut((Delete)mut, this.maprTable);
        } else {
            throw new IOException("Mutations can only be put or delete");
        }
        return mput;
    }

    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put) throws NoSuchColumnFamilyException, IOException {
        return this.checkAndPut(row, family, qualifier, CompareFilter.CompareOp.EQUAL, value, put);
    }

    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Put put) throws IOException {
        RowMutations rm = null;
        if (put != null) {
            rm = new RowMutations(put.getRow());
            rm.add(put);
        }
        return this.checkAndMutateImpl(row, family, qualifier, compareOp, value, rm, true);
    }

    public void delete(Delete delete) throws IOException {
        MapRPut mput = PutConverter.toMapRPut(delete, this.maprTable);
        this.maprTable.delete(mput);
    }

    public void delete(List<Delete> deletes) throws IOException {
        MapRPut[] mputs = new MapRPut[deletes.size()];
        int i = 0;
        for (Delete delete : deletes) {
            mputs[i++] = PutConverter.toMapRPut(delete, this.maprTable);
        }
        this.maprTable.delete(mputs);
    }

    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws NoSuchColumnFamilyException, IOException {
        return this.checkAndDelete(row, family, qualifier, CompareFilter.CompareOp.EQUAL, value, delete);
    }

    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Delete delete) throws IOException {
        RowMutations rm = null;
        if (delete != null) {
            rm = new RowMutations(delete.getRow());
            rm.add(delete);
        }
        return this.checkAndMutateImpl(row, family, qualifier, compareOp, value, rm, true);
    }

    public void mutateRow(RowMutations rm) throws IOException {
        if (rm.getMutations().size() > 0) {
            int i = 0;
            MapRPut[] mputs = new MapRPut[rm.getMutations().size()];
            for (Mutation m : rm.getMutations()) {
                MapRPut mput;
                this.checkMutation(m);
                if (m instanceof Put) {
                    mput = PutConverter.toMapRPut((Put)m, this.maprTable);
                    mputs[i++] = mput;
                    continue;
                }
                if (m instanceof Delete) {
                    mput = PutConverter.toMapRPut((Delete)m, this.maprTable);
                    mputs[i++] = mput;
                    continue;
                }
                throw new IOException("Mutations can only be put or delete");
            }
            this.maprTable.syncPut(mputs, true, true);
        }
    }

    public Result append(Append append) throws IOException {
        if (append.numFamilies() == 0) {
            throw new IOException("Invalid arguments to append, no columns specified");
        }
        this.checkMutation((Mutation)append);
        MapRPut mput = PutConverter.toMapRPut(append, this.maprTable);
        boolean isJson = this.maprTable.isJson();
        if (isJson) {
            this.maprTable.append(mput, false, this.flushOnRead);
            return null;
        }
        boolean retRes = append.isReturnResults();
        this.maprTable.append(mput, retRes, this.flushOnRead);
        if (retRes) {
            return ResultConverter.toHBaseResult(mput, this.maprTable);
        }
        return null;
    }

    public Result increment(Increment increment) throws IOException {
        if (!increment.hasFamilies()) {
            throw new IOException("Invalid arguments to increment, no columns specified");
        }
        this.checkMutation((Mutation)increment);
        MapRIncrement mincr = IncrementConverter.toMapRIncrement(increment, this.maprTable);
        this.maprTable.increment(mincr, this.flushOnRead);
        return ResultConverter.createHBaseResult(mincr, this.maprTable);
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
        NullPointerException npe = null;
        if (row == null) {
            npe = new NullPointerException("row is null");
        } else if (family == null) {
            npe = new NullPointerException("column is null");
        }
        if (npe != null) {
            throw new IOException("Invalid arguments to incrementColumnValue", npe);
        }
        MapRIncrement mincr = IncrementConverter.toMapRIncrement(row, family, qualifier, amount, this.maprTable);
        this.maprTable.increment(mincr, this.flushOnRead);
        return mincr.newValues[0];
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL) throws IOException {
        return this.incrementColumnValue(row, family, qualifier, amount);
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, Durability durability) throws IOException {
        return this.incrementColumnValue(row, family, qualifier, amount);
    }

    public void setFlushOnRead(boolean val) {
        this.flushOnRead = val;
    }

    public boolean shouldFlushOnRead() {
        return this.flushOnRead;
    }

    public void setAutoFlush(boolean autoFlush) {
        this.autoFlush = autoFlush;
    }

    public void setAutoFlush(boolean autoFlush, boolean clearBufferOnFail) {
        this.setAutoFlush(autoFlush);
    }

    public boolean isAutoFlush() {
        return this.autoFlush;
    }

    public HRegionLocation getRegionLocation(byte[] row) throws IOException {
        MapRTabletScanner scanner = this.maprTable.getTabletScanner(row);
        Dbserver.TabletDesc tablet = scanner.next();
        if (tablet != null) {
            return HRegionConverter.toHRegionLocation(tablet, this.maprTable);
        }
        return null;
    }

    public Pair<byte[][], byte[][]> getStartEndKeys() throws IOException {
        List nextSet;
        LinkedList<byte[]> startKeyList = new LinkedList<byte[]>();
        LinkedList<byte[]> endKeyList = new LinkedList<byte[]>();
        MapRTabletScanner scanner = this.maprTable.getTabletScanner();
        while ((nextSet = scanner.nextSet()) != null) {
            for (Dbserver.TabletDesc tablet : nextSet) {
                startKeyList.add(tablet.getStartKey().toByteArray());
                endKeyList.add(tablet.getEndKey().toByteArray());
            }
        }
        return new Pair(startKeyList.toArray((T[])new byte[startKeyList.size()][]), endKeyList.toArray((T[])new byte[endKeyList.size()][]));
    }

    public NavigableMap<HRegionInfo, ServerName> getRegionLocations() throws IOException {
        List nextSet;
        TreeMap<HRegionInfo, ServerName> regions = new TreeMap<HRegionInfo, ServerName>();
        MapRTabletScanner scanner = this.maprTable.getTabletScanner();
        while ((nextSet = scanner.nextSet()) != null) {
            for (Dbserver.TabletDesc tablet : nextSet) {
                HRegionInfo info = HRegionConverter.toHRegionInfo(tablet, this.maprTable.getName());
                ServerName sn = HRegionConverter.toServerName(tablet, this.maprTable);
                regions.put(info, sn);
            }
        }
        return regions;
    }

    private void checkMutation(Mutation m) throws IOException {
        try {
            if (m.getCellVisibility() != null) {
                throw new UnsupportedOperationException("CellVisibility tags are not supported for MapR-DB tables.");
            }
            if (m.getAttribute(OP_ATTRIBUTE_TTL) != null) {
                throw new UnsupportedOperationException("Per Cell TTL is currently not supported for MapR-DB tables.");
            }
            if (m.getACL() != null) {
                throw new UnsupportedOperationException("Per Cell ACL is currently not supported for MapR-DB tables.");
            }
        }
        catch (DeserializationException e) {
            throw new IOException(e);
        }
    }

    public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, RowMutations rm) throws IOException {
        return this.checkAndMutateImpl(row, family, qualifier, compareOp, value, rm, false);
    }

    public boolean checkAndMutateImpl(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, RowMutations rm, boolean throwerr) throws IOException {
        if (rm.getMutations().size() <= 0) {
            LOG.error((Object)"Missing mutations ");
            return false;
        }
        if (qualifier == null) {
            LOG.error((Object)"Missing qualifier ");
            return false;
        }
        if (qualifier == HConstants.EMPTY_BYTE_ARRAY) {
            LOG.error((Object)"Empty qualifier ");
            return false;
        }
        if (compareOp == CompareFilter.CompareOp.NO_OP) {
            return false;
        }
        FamilyInfo fInfo = null;
        try {
            fInfo = this.getFamilyInfo(row, family);
        }
        catch (NoSuchColumnFamilyException e) {
            LOG.error((Object)("Family " + Bytes.toStringBinary((byte[])family) + " not exist :" + e.getMessage()));
            if (throwerr) {
                throw e;
            }
            return false;
        }
        if (fInfo == null) {
            LOG.error((Object)("Get family info returns null for Family " + Bytes.toStringBinary((byte[])family)));
            return false;
        }
        int i = 0;
        MapRPut[] mputs = new MapRPut[rm.getMutations().size()];
        for (Mutation m : rm.getMutations()) {
            MapRPut mput = this.MutateToMapRPut(row, m);
            mputs[i++] = mput;
        }
        MapRRowConstraint checkConstraint = null;
        checkConstraint = RowConstraintConverter.toRowConstraint(this.maprTable, family, qualifier);
        checkConstraint.maxVersions = 1;
        Dbfilters.FilterMsg filterMsg = null;
        boolean checkForNonExist = false;
        if (value != null) {
            checkForNonExist = false;
            BinaryComparator bcomparator = new BinaryComparator(value);
            SingleColumnValueFilter scvfilter = new SingleColumnValueFilter(family, qualifier, compareOp, (ByteArrayComparable)bcomparator);
            filterMsg = FilterSerializer.serialize((Filter)scvfilter);
        } else if (compareOp == CompareFilter.CompareOp.NOT_EQUAL) {
            checkForNonExist = false;
        } else if (compareOp == CompareFilter.CompareOp.EQUAL) {
            checkForNonExist = true;
        } else {
            checkForNonExist = true;
            LOG.info((Object)(compareOp.toString() + " is not applicable to null value, changing it to EQUAL"));
        }
        return this.maprTable.checkAndMutate(row, fInfo.useCf, checkForNonExist, checkConstraint, filterMsg, mputs, this.flushOnRead);
    }

    public class FamilyInfo {
        public boolean useCf;
        public int familyId;
    }
}

