/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.hbase;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import com.mapr.fs.AceHelper;
import com.mapr.fs.MapRFileStatus;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.MapRTabletScanner;
import com.mapr.fs.ShimLoader;
import com.mapr.fs.hbase.CFPermissions;
import com.mapr.fs.hbase.HRegionConverter;
import com.mapr.fs.hbase.MapRDBConstants;
import com.mapr.fs.hbase.SchemaHelper;
import com.mapr.fs.hbase.TableProperties;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Dbserver;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.InvalidFamilyOperationException;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.mapr.AbstractHBaseAdmin;
import org.apache.hadoop.hbase.client.mapr.BaseTableMappingRules;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.log4j.Logger;

public class HBaseAdminImpl
extends AbstractHBaseAdmin
implements MapRDBConstants {
    private static final Log LOG;
    private volatile MapRFileSystem maprfilesystem_;
    private final BaseTableMappingRules tableMappingRule_;
    private final Configuration configuration_;
    private User user_ = null;

    public HBaseAdminImpl(Configuration c, BaseTableMappingRules tableMappingRule) {
        this.configuration_ = c;
        this.tableMappingRule_ = tableMappingRule;
    }

    public synchronized void close() throws IOException {
        if (this.maprfilesystem_ != null) {
            this.maprfilesystem_.close();
            this.maprfilesystem_ = null;
        }
    }

    public void setUser(User user) {
        this.user_ = user;
    }

    public boolean tableExists(String tablePath) throws IOException {
        return this.maprfs().isTable(this.getTablePath(tablePath));
    }

    public HTableDescriptor[] listTables() throws IOException {
        return this.listTables(null);
    }

    public HTableDescriptor[] listTables(String lookupPattern) throws IOException {
        ArrayList<HTableDescriptor> descriptors = new ArrayList<HTableDescriptor>();
        FileStatus[] status = this.doListTables(lookupPattern);
        if (status != null && status.length > 0) {
            for (int i = 0; i < status.length; ++i) {
                descriptors.add(SchemaHelper.toHTableDescriptor(this.maprfs(), status[i].getPath(), lookupPattern == null || !lookupPattern.contains("/")));
            }
        }
        return descriptors.toArray(new HTableDescriptor[descriptors.size()]);
    }

    public TableName[] listTableNames() throws IOException {
        return this.listTableNames(null);
    }

    public TableName[] listTableNames(String lookupPattern) throws IOException {
        ArrayList<TableName> tableNames = new ArrayList<TableName>();
        FileStatus[] status = this.doListTables(lookupPattern);
        if (status != null && status.length > 0) {
            for (int i = 0; i < status.length; ++i) {
                if (lookupPattern == null || !lookupPattern.contains("/")) {
                    tableNames.add(TableName.valueOf((String)status[i].getPath().getName()));
                    continue;
                }
                tableNames.add(TableName.valueOf((String)status[i].getPath().toUri().getPath()));
            }
        }
        return tableNames.toArray(new TableName[tableNames.size()]);
    }

    protected FileStatus[] doListTables(String lookupPath) throws IOException {
        String name;
        Path path = null;
        String checkPattern = null;
        if (lookupPath == null || lookupPath.length() == 0 || lookupPath.equals(".*")) {
            path = this.tableMappingRule_.getDefaultTablePath();
            if (!this.maprfs().exists(path)) {
                throw new IOException("doListTables() called for default path(" + path.toUri().getPath() + "), but it does not exists.");
            }
        } else {
            int lio_slash = lookupPath.lastIndexOf("/");
            String origLookup = lookupPath;
            boolean isDir = false;
            try {
                path = this.getTablePath(lookupPath);
                isDir = this.maprfs().getMapRFileStatus(path).isDir();
            }
            catch (FileNotFoundException e) {
                path = null;
            }
            if (!isDir) {
                if (lio_slash != -1) {
                    lookupPath = lookupPath.substring(0, lio_slash + 1);
                    checkPattern = origLookup.substring(lio_slash + 1);
                }
                path = this.getTablePath(lookupPath);
            }
        }
        if (this.maprfs().isTable(path)) {
            return new FileStatus[]{this.maprfs().getFileStatus(path)};
        }
        String string = name = checkPattern != null ? checkPattern : ".*";
        if (!this.maprfs().exists(path)) {
            Path parent = path.getParent();
            if (!this.maprfs().exists(parent)) {
                throw new IOException("Path '" + path.toString() + "' or its parent " + "does not exist.");
            }
            name = path.getName();
            path = parent;
        }
        final Pattern filter = Pattern.compile(name);
        return this.maprfs().listStatus(path, new PathFilter(){

            public boolean accept(Path path) {
                try {
                    return filter.matcher(path.getName()).matches() && HBaseAdminImpl.this.maprfs().isTable(path);
                }
                catch (IOException e) {
                    return false;
                }
            }
        });
    }

    public HTableDescriptor getTableDescriptor(String tableName) throws TableNotFoundException, IOException {
        if (tableName == null || tableName.length() == 0) {
            return null;
        }
        return this.getTableDescriptor(this.getTablePath(tableName));
    }

    protected HTableDescriptor getTableDescriptor(Path tablePath) throws TableNotFoundException, IOException {
        this.checkTable(tablePath);
        return SchemaHelper.toHTableDescriptor(this.maprfs(), tablePath);
    }

    public void createTable(HTableDescriptor desc, byte[][] splitKeys) throws IOException {
        if (desc == null || desc.getName() == null) {
            throw new IllegalArgumentException("Table descriptor or name can not be null: " + desc);
        }
        this.checkTableDesc(desc);
        try {
            Path path = this.getTablePath(desc.getName());
            if (this.maprfs().exists(path)) {
                throw new TableExistsException(path.toString());
            }
            Dbserver.TableAttr.Builder attrBuilder = Dbserver.TableAttr.newBuilder();
            this.toTableAttr(desc, attrBuilder);
            this.maprfs().createTable(path, null, attrBuilder.build(), Dbserver.TableAces.getDefaultInstance(), splitKeys, false, -1);
            for (HColumnDescriptor cf : desc.getFamilies()) {
                String name = cf.getNameAsString();
                this.maprfs().createColumnFamily(path, name, SchemaHelper.toColumnFamilyAttr(cf, false));
            }
            TableProperties.setTableProperties(path, desc.getValues());
            LOG.debug((Object)("Created table " + path));
        }
        catch (IOException e) {
            LOG.debug((Object)("Error creating table '" + desc.getNameAsString() + "': " + e.getMessage()));
            throw e;
        }
    }

    public void deleteTable(String tablePath) throws IOException {
        this.deleteTable(this.getTablePath(tablePath));
    }

    public void deleteTable(Path tablePath) throws IOException {
        this.checkTable(tablePath);
        MapRFileStatus status = this.maprfs().getMapRFileStatus(tablePath);
        if (!status.isTable()) {
            throw new IOException("Path '" + tablePath.toString() + "' is not a table");
        }
        this.maprfs().delete(tablePath, false);
        TableProperties.removeProperties(tablePath);
        LOG.debug((Object)("Deleted table " + tablePath));
    }

    public HTableDescriptor[] deleteTables(String lookupPath) throws IOException {
        LinkedList<HTableDescriptor> failed = new LinkedList<HTableDescriptor>();
        FileStatus[] tables = this.doListTables(lookupPath);
        if (tables != null && tables.length > 0) {
            for (FileStatus table : tables) {
                Path path = table.getPath();
                try {
                    this.deleteTable(path);
                }
                catch (IOException ex) {
                    LOG.info((Object)("Failed to delete table " + path.getName()), (Throwable)ex);
                    failed.add(SchemaHelper.toHTableDescriptor(this.maprfs(), path));
                }
            }
        }
        return failed.toArray(new HTableDescriptor[failed.size()]);
    }

    public void addColumn(String tableName, HColumnDescriptor cf) throws IOException {
        this.addColumn(this.getTablePath(tableName), cf);
    }

    public void addColumn(Path tablePath, HColumnDescriptor cf) throws IOException {
        this.checkTable(tablePath);
        this.checkColumnDesc(cf);
        String name = cf.getNameAsString();
        try {
            this.maprfs().createColumnFamily(this.maprfs().resolveTablePath(tablePath), name, SchemaHelper.toColumnFamilyAttr(cf, false));
        }
        catch (IOException e) {
            LOG.error((Object)("Exception while adding column familiy '" + name + "' for table '" + tablePath + "'"));
            throw e;
        }
    }

    public void modifyColumn(String tableName, HColumnDescriptor cf) throws IOException {
        this.modifyColumn(this.getTablePath(tableName), cf);
    }

    public void modifyColumn(Path tablePath, HColumnDescriptor cf) throws IOException {
        this.checkColumnDesc(cf);
        HTableDescriptor desc = this.getTableDescriptor(tablePath);
        if (!desc.hasFamily(cf.getName())) {
            throw new InvalidFamilyOperationException("Column family '" + cf.getNameAsString() + "' does not exist");
        }
        HColumnDescriptor oldcf = desc.getFamily(cf.getName());
        try {
            this.maprfs().modifyColumnFamily(this.maprfs().resolveTablePath(tablePath), cf.getNameAsString(), SchemaHelper.toColumnFamilyAttr(oldcf, cf, false));
        }
        catch (IOException e) {
            LOG.error((Object)("Exception while modifying column familiy '" + cf.getNameAsString() + "' for table '" + tablePath + "'"));
            throw e;
        }
    }

    public void deleteColumn(String tableName, String columnName) throws IOException {
        Path path = this.getTablePath(tableName);
        this.checkTable(path);
        try {
            this.maprfs().deleteColumnFamily(this.maprfs().resolveTablePath(path), columnName);
        }
        catch (IOException e) {
            LOG.error((Object)("Exception while deleting column familiy '" + columnName + "' for table '" + tableName + "'"));
            throw e;
        }
    }

    public void modifyTable(String tableName, HTableDescriptor htd) throws IOException {
        Path path = this.getTablePath(tableName);
        this.checkTable(path);
        this.checkTableDesc(htd);
        String blStr = htd.getValue("BULKLOAD");
        if (blStr != null && blStr.equals("true")) {
            throw new IOException("Cannot alter bulkload attribute to true.");
        }
        MapRFileSystem.TableProperties tableProp = this.maprfs().getTableAttr(path);
        Dbserver.TableAces aces = tableProp.getAces();
        Dbserver.TableAttr.Builder attrBuilder = tableProp.getAttr().toBuilder();
        this.toTableAttr(htd, attrBuilder);
        this.maprfs().modifyTableAttr(path, attrBuilder.build(), aces);
        TableProperties.setTableProperties(path, htd.getValues());
    }

    public void enableTable(String tableName) throws IOException {
        Path path = this.getTablePath(tableName);
        this.checkTable(path);
        TableProperties.setTableProperty(path, "DISABLED", TableProperties.FALSE);
    }

    public HTableDescriptor[] enableTables(String regex) throws IOException {
        return this.setTableDisabledStatus(regex, false);
    }

    public void disableTable(String tableName) throws IOException {
        Path path = this.getTablePath(tableName);
        this.checkTable(path);
        TableProperties.setTableProperty(path, "DISABLED", TableProperties.TRUE);
    }

    public HTableDescriptor[] disableTables(String regex) throws IOException {
        return this.setTableDisabledStatus(regex, true);
    }

    public boolean isTableEnabled(String tableName) throws IOException {
        return !this.isTableDisabled(tableName);
    }

    public boolean isTableDisabled(String tableName) throws IOException {
        Path path = this.getTablePath(tableName);
        this.checkTable(path);
        return Boolean.parseBoolean(TableProperties.getTableProperty(path, "DISABLED"));
    }

    public boolean isTableAvailable(String tableName) throws IOException {
        return this.tableExists(tableName);
    }

    public boolean isTableAvailable(String tableName, byte[][] splitKeys) throws IOException {
        throw new UnsupportedOperationException("isTableAvailable with splitkeys is currently not supported for MapR tables.");
    }

    public List<HRegionInfo> getTableRegions(byte[] tableName) throws IOException {
        List nextSet;
        ArrayList<HRegionInfo> tableRegions = new ArrayList<HRegionInfo>();
        String tablePath = Bytes.toString((byte[])tableName);
        MapRTabletScanner scanner = this.maprfs().getTabletScanner(new Path(tablePath));
        while ((nextSet = scanner.nextSet()) != null) {
            for (Dbserver.TabletDesc tablet : nextSet) {
                tableRegions.add(HRegionConverter.toHRegionInfo(tablet, tableName));
            }
        }
        return tableRegions;
    }

    public void split(byte[] tableNameOrRegionName, byte[] splitPoint) throws IOException {
        List nextSet;
        String fidString;
        if (splitPoint != null) {
            throw new UnsupportedOperationException("Region split with 'splitPoint' is currently not supported for MapR tables.");
        }
        String tableNameOrRegionStr = Bytes.toString((byte[])tableNameOrRegionName);
        int fidOffset = tableNameOrRegionStr.lastIndexOf(",");
        if (fidOffset != -1 && MapRFileSystem.isFidString((String)(fidString = tableNameOrRegionStr.substring(fidOffset + 1)))) {
            Path tablePath = this.getTablePath(tableNameOrRegionStr.substring(0, fidOffset));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Splitting table %s, tablet %s.", tablePath.toString(), fidString));
            }
            this.maprfs().splitTableRegion(tablePath, fidString, true);
            return;
        }
        Path tablePath = this.getTablePath(tableNameOrRegionStr);
        MapRTabletScanner scanner = this.maprfs().getTabletScanner(tablePath);
        while ((nextSet = scanner.nextSet()) != null) {
            for (Dbserver.TabletDesc tablet : nextSet) {
                String fidString2 = MapRFileSystem.fidToString((Common.FidMsg)tablet.getFid());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("Splitting table %s, tablet %s.", tablePath.toString(), fidString2));
                }
                this.maprfs().splitTableRegion(tablePath, fidString2, true);
            }
        }
    }

    public void setTablePermissions(String tablePath, final Map<String, String> permissions) throws IOException {
        this.maprfs().modifyTableAttr(this.getTablePath(tablePath), Dbserver.TableAttr.newBuilder().build(), new AceHelper.DBPermission(){

            public String getCliParam(String key) throws IOException {
                return (String)permissions.get(key);
            }
        });
    }

    public Map<String, String> getTablePermissions(String tablePath) throws IOException {
        String expr;
        HashMap<String, String> permissions = new HashMap<String, String>();
        Path table = this.getTablePath(tablePath);
        MapRFileSystem.TableProperties tableProp = this.maprfs().getTableAttr(table);
        Dbserver.TableAces aces = tableProp.getAces();
        for (Dbserver.AccessControlExpression ace : aces.getAcesList()) {
            expr = AceHelper.toInfix((String)ace.getBooleanExpression().toStringUtf8());
            permissions.put((String)AceHelper.tblPermissionMap.get(ace.getAccessType()), expr);
        }
        for (Dbserver.AccessControlExpression ace : aces.getDefaultColumnFamilyAcesList()) {
            expr = AceHelper.toInfix((String)ace.getBooleanExpression().toStringUtf8());
            permissions.put((String)AceHelper.cfDefPermissionMap.get(ace.getAccessType()), expr);
        }
        return permissions;
    }

    public void deleteTablePermission(String tablePath, String permission) throws IOException {
        Map<String, String> permissions = this.getTablePermissions(tablePath);
        if (!permissions.containsKey(permission)) {
            throw new IllegalArgumentException(String.format("Permission '%s' is not set on table '%s'.", permission, tablePath));
        }
        permissions.put(permission, "");
        this.setTablePermissions(tablePath, permissions);
    }

    public void setFamilyPermissions(String tablePath, String family, CFPermissions cfPermissions) throws IOException {
        Path table = this.getTablePath(tablePath);
        Dbserver.ColumnFamilyAttr familyAttr = this.getColumnFamily(table, family, true);
        Dbserver.ColumnFamilyAttr.Builder cfAttrBuilder = familyAttr.toBuilder();
        cfAttrBuilder.clearSchFamily();
        final Map<String, String> cfPerms = cfPermissions.getCfPermissions();
        if (cfPerms.size() > 0) {
            ArrayList cfAces = AceHelper.getCfPermission((AceHelper.DBPermission)new AceHelper.DBPermission(){

                public String getCliParam(String key) throws IOException {
                    return (String)cfPerms.get(key);
                }
            });
            Collection<Dbserver.AccessControlExpression> mergedAces = this.mergeAces(cfAttrBuilder.getAcesList(), cfAces);
            cfAttrBuilder.clearAces().addAllAces(mergedAces);
        }
        if (cfPermissions.getColumnNames().size() > 0) {
            List columnAttrs = familyAttr.getColumnAttrList();
            for (String columnName : cfPermissions.getColumnNames()) {
                final Map<String, String> colPerms = cfPermissions.getColPermission(columnName);
                ArrayList colAces = AceHelper.getColumnPermission((AceHelper.DBPermission)new AceHelper.DBPermission(){

                    public String getCliParam(String key) throws IOException {
                        return (String)colPerms.get(key);
                    }
                });
                ByteString colByteName = ByteString.copyFrom((byte[])Bytes.toBytesBinary((String)columnName));
                int index = this.getColumnAttrIndex(colByteName, columnAttrs);
                if (index == -1) {
                    Dbserver.ColumnAttr.Builder builder = Dbserver.ColumnAttr.newBuilder().setQualifier(colByteName).addAllAces((Iterable)colAces);
                    cfAttrBuilder.addColumnAttr(builder.build());
                    continue;
                }
                Dbserver.ColumnAttr columnAttr = (Dbserver.ColumnAttr)columnAttrs.get(index);
                Collection<Dbserver.AccessControlExpression> mergedAces = this.mergeAces(columnAttr.getAcesList(), colAces);
                Dbserver.ColumnAttr.Builder builder = columnAttr.toBuilder().clearAces().addAllAces(mergedAces);
                cfAttrBuilder.setColumnAttr(index, builder);
            }
        }
        this.maprfs().modifyColumnFamily(table, family, cfAttrBuilder.build());
    }

    public List<CFPermissions> getFamilyPermissions(String tablePath) throws IOException {
        ArrayList<CFPermissions> cfPermissions = new ArrayList<CFPermissions>();
        Path table = this.getTablePath(tablePath);
        for (Dbserver.ColumnFamilyAttr cfa : this.maprfs().listColumnFamily(table, true)) {
            CFPermissions familyPerm = new CFPermissions(cfa.getSchFamily().getName());
            cfPermissions.add(familyPerm);
            for (Dbserver.AccessControlExpression ace : cfa.getAcesList()) {
                String expr = AceHelper.toInfix((String)ace.getBooleanExpression().toStringUtf8());
                familyPerm.addCFPermission((String)AceHelper.cfPermissionMap.get(ace.getAccessType()), expr);
            }
            for (int i = 0; i < cfa.getColumnAttrCount(); ++i) {
                Dbserver.ColumnAttr col = cfa.getColumnAttr(i);
                for (Dbserver.AccessControlExpression ace : col.getAcesList()) {
                    String expr = AceHelper.toInfix((String)ace.getBooleanExpression().toStringUtf8());
                    familyPerm.addColPermission(Bytes.toStringBinary((byte[])col.getQualifier().toByteArray()), (String)AceHelper.colPermissionMap.get(ace.getAccessType()), expr);
                }
            }
        }
        return cfPermissions;
    }

    public void deleteColumnPermission(String tablePath, String column, String permission) throws IOException {
        Dbserver.DBAccessType accessType;
        String family = column;
        String qualifier = null;
        if (column.contains(":")) {
            String[] parts = column.split(":");
            family = parts[0];
            qualifier = parts[1];
        }
        Path table = this.getTablePath(tablePath);
        Dbserver.ColumnFamilyAttr familyAttr = this.getColumnFamily(table, family, true);
        Dbserver.ColumnFamilyAttr.Builder cfAttrBuilder = familyAttr.toBuilder().clearSchFamily();
        if (qualifier != null) {
            accessType = (Dbserver.DBAccessType)AceHelper.colAccessTypeMap.get(permission);
            List columnAttrs = familyAttr.getColumnAttrList();
            ByteString colByteName = ByteString.copyFrom((byte[])Bytes.toBytesBinary((String)qualifier));
            int index = this.getColumnAttrIndex(colByteName, columnAttrs);
            if (index == -1) {
                throw new IllegalArgumentException(String.format("No permission is set on column '%s' of table '%s'.", column, tablePath));
            }
            Dbserver.ColumnAttr columnAttr = (Dbserver.ColumnAttr)columnAttrs.get(index);
            Collection<Dbserver.AccessControlExpression> newAces = this.removeAce(columnAttr.getAcesList(), accessType, true);
            Dbserver.ColumnAttr.Builder builder = columnAttr.toBuilder().clearAces().addAllAces(newAces);
            cfAttrBuilder.setColumnAttr(index, builder);
        } else {
            accessType = (Dbserver.DBAccessType)AceHelper.cfAccessTypeMap.get(permission);
            Collection<Dbserver.AccessControlExpression> newAces = this.removeAce(cfAttrBuilder.getAcesList(), accessType, false);
            cfAttrBuilder.clearAces().addAllAces(newAces);
        }
        this.maprfs().modifyColumnFamily(table, family, cfAttrBuilder.build());
    }

    protected Dbserver.ColumnFamilyAttr getColumnFamily(Path table, String cfName, boolean wantAce) throws IOException {
        List families = this.maprfs().listColumnFamily(table, wantAce);
        if (families != null && families.size() > 0) {
            for (Dbserver.ColumnFamilyAttr cf : families) {
                if (!cf.getSchFamily().getName().equals(cfName)) continue;
                return cf;
            }
        }
        throw new InvalidFamilyOperationException("Column family '" + cfName + "' does not exist for table '" + table + "'");
    }

    protected Collection<Dbserver.AccessControlExpression> removeAce(List<Dbserver.AccessControlExpression> originalAces, Dbserver.DBAccessType accessType, boolean isForColumn) {
        ArrayList<Dbserver.AccessControlExpression> newAces = new ArrayList<Dbserver.AccessControlExpression>();
        for (Dbserver.AccessControlExpression ace : originalAces) {
            if (ace.getAccessType() != accessType) {
                newAces.add(ace);
                continue;
            }
            if (isForColumn) continue;
            newAces.add(Dbserver.AccessControlExpression.newBuilder().setAccessType(accessType).setBooleanExpression(ByteString.copyFromUtf8((String)"")).build());
        }
        return newAces;
    }

    protected Collection<Dbserver.AccessControlExpression> mergeAces(List<Dbserver.AccessControlExpression> originalAces, List<Dbserver.AccessControlExpression> overrideAces) {
        HashMap<Dbserver.DBAccessType, Dbserver.AccessControlExpression> aceMap = new HashMap<Dbserver.DBAccessType, Dbserver.AccessControlExpression>();
        for (Dbserver.AccessControlExpression a : originalAces) {
            aceMap.put(a.getAccessType(), a);
        }
        for (Dbserver.AccessControlExpression a : overrideAces) {
            aceMap.put(a.getAccessType(), a);
        }
        return aceMap.values();
    }

    protected int getColumnAttrIndex(ByteString colByteName, List<Dbserver.ColumnAttr> columnAttrs) {
        if (columnAttrs != null) {
            for (int index = 0; index < columnAttrs.size(); ++index) {
                Dbserver.ColumnAttr columnAttr = columnAttrs.get(index);
                if (!columnAttr.getQualifier().equals((Object)colByteName)) continue;
                return index;
            }
        }
        return -1;
    }

    protected synchronized MapRFileSystem maprfs() throws IOException {
        if (this.maprfilesystem_ == null) {
            try {
                this.maprfilesystem_ = this.user_ != null ? (MapRFileSystem)this.user_.getUGI().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<MapRFileSystem>(){

                    @Override
                    public MapRFileSystem run() throws Exception {
                        return HBaseAdminImpl.this.createMaprFS();
                    }
                }) : this.createMaprFS();
            }
            catch (IOException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new IOException(t);
            }
        }
        return this.maprfilesystem_;
    }

    private synchronized MapRFileSystem createMaprFS() throws IOException, URISyntaxException {
        MapRFileSystem maprfs = new MapRFileSystem();
        maprfs.initialize(new URI("maprfs:///"), this.configuration_);
        return maprfs;
    }

    protected HTableDescriptor[] setTableDisabledStatus(String regex, Boolean disabled) throws IOException {
        if (regex == null) {
            return null;
        }
        FileStatus[] tables = this.doListTables(regex);
        if (tables != null && tables.length > 0) {
            for (FileStatus table : tables) {
                TableProperties.setTableProperty(table.getPath(), "DISABLED", disabled.toString());
            }
        }
        return new HTableDescriptor[0];
    }

    protected Path getTablePath(String tableName) throws IOException {
        return this.tableMappingRule_.getMaprTablePath(tableName);
    }

    protected Path getTablePath(byte[] tableName) throws IOException {
        return this.tableMappingRule_.getMaprTablePath(tableName);
    }

    protected void unSupportedOperation(String operation) {
        throw new UnsupportedOperationException(operation + " called on MapR HBaseAdminImpl");
    }

    protected void checkTable(Path path) throws IOException, TableNotFoundException {
        if (!this.maprfs().exists(path)) {
            throw new TableNotFoundException("Table '" + path + "' does not exist.");
        }
        if (!this.maprfs().isTable(path)) {
            throw new TableNotFoundException("Path '" + path + "' is a not a table.");
        }
    }

    private void toTableAttr(HTableDescriptor desc, Dbserver.TableAttr.Builder attrBuilder) {
        Map htdMap = desc.getValues();
        for (Map.Entry pairs : htdMap.entrySet()) {
            String key = Bytes.toString((byte[])((ImmutableBytesWritable)pairs.getKey()).get());
            String value = Bytes.toString((byte[])((ImmutableBytesWritable)pairs.getValue()).get());
            if (key.equals("BULKLOAD")) {
                attrBuilder.setBulkLoad(Boolean.parseBoolean(value));
                continue;
            }
            if (key.equals("MAX_FILESIZE")) {
                long regionSize = Long.parseLong(value, 10);
                attrBuilder.setRegionSizeMB(regionSize / 0x100000L);
                continue;
            }
            if (key.equals("AUTOSPLIT")) {
                attrBuilder.setAutoSplit(Boolean.parseBoolean(value));
                continue;
            }
            if (key.equals("MAX_VALUE_SIZE_IN_MEM")) {
                attrBuilder.setMaxValueSzInMemIndex(Integer.parseInt(value));
                continue;
            }
            if (key.equals("RECLAIM_THRESH_PCNT_FOR_PACK")) {
                attrBuilder.setReclaimThreshPcntForPack(Integer.parseInt(value));
                continue;
            }
            if (key.equals("MAXSPILLS")) {
                attrBuilder.setMaxSpills(Integer.parseInt(value));
                continue;
            }
            if (key.equals("MINIPACK")) {
                attrBuilder.setMiniPack(Boolean.parseBoolean(value));
                continue;
            }
            if (key.equals("SIZE_THRESH_PCNT_FOR_PACK")) {
                attrBuilder.setSizeThreshPcntForPack(Integer.parseInt(value));
                continue;
            }
            if (!key.equals("DELETE_TTL")) continue;
            attrBuilder.setDeleteTTL(Long.parseLong(value));
        }
    }

    public int getNumRows(String path) throws Exception {
        Path tablePath = new Path(path);
        int numRows = 0;
        this.checkTable(tablePath);
        try {
            MapRFileSystem mfs = this.maprfs();
            if (mfs.getMapRFileStatus(tablePath).isTable()) {
                TabletStats tabletStats = new TabletStats(path);
                int i = 0;
                while (true) {
                    List<Dbserver.TabletDesc> tablets;
                    if ((tablets = tabletStats.getTablets(i, 50)) == null) {
                        return -1;
                    }
                    if (tablets.isEmpty()) break;
                    for (Dbserver.TabletDesc tablet : tablets) {
                        try {
                            Dbserver.TabletStatResponse tsr = tabletStats.getTabletStatResponse(tablet);
                            if (tsr == null || !tsr.hasUsage()) continue;
                            Dbserver.SpaceUsage su = tsr.getUsage();
                            numRows = (int)((long)numRows + su.getNumRows());
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Error fetching tablet stats");
                        }
                    }
                    i += 50;
                }
            }
            return numRows;
        }
        catch (Exception e) {
            LOG.error((Object)"Error accessing the maprfs");
            return numRows;
        }
    }

    private void checkTableDesc(HTableDescriptor htd) {
        for (HColumnDescriptor family : htd.getColumnFamilies()) {
            this.checkColumnDesc(family);
        }
    }

    private void checkColumnDesc(HColumnDescriptor hcd) {
        String value = hcd.getValue("KEEP_DELETED_CELLS");
        if (value != null && !"false".equalsIgnoreCase(value)) {
            throw new UnsupportedOperationException("'KEEP_DELETED_CELLS' flag on the column family is not supported with MapR-DB tables.");
        }
        if (hcd.getValue("ENCRYPTION") != null) {
            throw new UnsupportedOperationException("Encryption of MapR-DB tables is currently not supported.");
        }
    }

    public void truncateTable(TableName tableName, boolean preserveSplits) throws IOException {
        byte[][] splitKeys = null;
        if (preserveSplits) {
            List<HRegionInfo> regions = this.getTableRegions(tableName.getQualifier());
            Collections.sort(regions);
            ArrayList<byte[]> splitKeyList = new ArrayList<byte[]>(regions.size());
            for (HRegionInfo region : regions) {
                if (region.getEndKey() == null || region.getEndKey().length == 0) continue;
                splitKeyList.add(region.getEndKey());
            }
            splitKeys = (byte[][])splitKeyList.toArray((T[])new byte[splitKeyList.size()][]);
        }
        String tablePath = tableName.getAliasAsString();
        HTableDescriptor htd = this.getTableDescriptor(tablePath);
        Map<String, String> tablePerms = this.getTablePermissions(tablePath);
        List<CFPermissions> cfPerms = this.getFamilyPermissions(tablePath);
        this.deleteTable(tablePath);
        htd.remove(HTableDescriptor.MAPR_UUID_KEY);
        htd.remove("DISABLED");
        this.createTable(htd, splitKeys);
        this.setTablePermissions(tablePath, tablePerms);
        for (CFPermissions cfp : cfPerms) {
            this.setFamilyPermissions(tablePath, cfp.getFamily(), cfp);
        }
    }

    static {
        ShimLoader.load();
        LOG = LogFactory.getLog(HBaseAdminImpl.class);
    }

    private class TabletStats {
        private final Logger LOG = Logger.getLogger(TabletStats.class);
        private ExecutorService tabletStatRpcService = Executors.newFixedThreadPool(10);
        private Map<Dbserver.TabletDesc, Future<Dbserver.TabletStatResponse>> futureResponses;
        private String path;

        public TabletStats(String path) {
            this.path = path;
        }

        public List<Dbserver.TabletDesc> getTablets(int start, int limit) {
            ArrayList tablets = Lists.newArrayList();
            try {
                Dbserver.TabletDesc nextTablet;
                final MapRFileSystem mfs = HBaseAdminImpl.this.maprfs();
                MapRTabletScanner scanner = mfs.getTabletScanner(new Path(this.path));
                while ((nextTablet = scanner.next()) != null) {
                    if (start > 0) {
                        --start;
                        continue;
                    }
                    if (start == 0 && limit > 0) {
                        tablets.add(nextTablet);
                        --limit;
                        continue;
                    }
                    if (limit != 0) continue;
                }
                this.futureResponses = Maps.newHashMap();
                for (final Dbserver.TabletDesc tablet : tablets) {
                    this.futureResponses.put(tablet, this.tabletStatRpcService.submit(new Callable<Dbserver.TabletStatResponse>(){

                        @Override
                        public Dbserver.TabletStatResponse call() {
                            try {
                                if (TabletStats.this.LOG.isDebugEnabled()) {
                                    TabletStats.this.LOG.debug((Object)("Fetching tablet stats for fid: " + tablet.getFid()));
                                }
                                return mfs.getTabletStat(new Path(TabletStats.this.path), tablet.getFid());
                            }
                            catch (Exception ioe) {
                                TabletStats.this.LOG.error((Object)("Error fetching tablet stats for fid: " + tablet.getFid()), (Throwable)ioe);
                                return null;
                            }
                        }
                    }));
                }
            }
            catch (IOException e) {
                return null;
            }
            return tablets;
        }

        public Dbserver.TabletStatResponse getTabletStatResponse(Dbserver.TabletDesc tablet) throws InterruptedException, ExecutionException {
            return this.futureResponses.get(tablet).get();
        }
    }
}

