/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.hbase.tools.mapreduce;

import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.hbase.filter.KeySamplingFilter;
import com.mapr.fs.proto.Common;
import com.mapr.util.zookeeper.ZKDataRetrieval;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class SegKeyRangeUtil
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(SegKeyRangeUtil.class);
    public static final String CLUSTERPREFIX = "maprfs:///mapr/";
    public static final String CLUSTERPREFIX2 = "/mapr/";
    public static final String KEYPREFIX = "k_";
    public static final String FIRSTKEYNAME = "neginf";
    public static final String LASTKEYNAME = "inf";
    public static final String SucceedFileName = "_SUCCESS";
    static String tableFileName = null;
    static String segKeyRangeFileName = null;
    static String segKeyRangeDirName = null;
    static Operation operation = Operation.READ;

    static boolean checkPathExists(Configuration conf, String pathName) throws IOException {
        Path path = new Path(pathName);
        FileSystem fs = path.getFileSystem(conf);
        return fs.exists(path);
    }

    static String getTmpDirName(Configuration conf) {
        return conf.get("hadoop.tmp.dir");
    }

    static String getTabletKeyFileName(String tblName) {
        return tblName.replace("/", "").replace(":", "") + ".regionkeys";
    }

    static String getReSplitedTabletKeyFileName(String tblName) {
        return tblName.replace("/", "").replace(":", "") + ".resplitedregionkeys";
    }

    static String getSegKeyFileName(String tblName) {
        return tblName.replace("/", "").replace(":", "") + ".segmentkeys";
    }

    static String getSegKeyDirName(String tblName) {
        return tblName.replace("/", "").replace(":", "") + ".startkeys";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getServiceAddress(Configuration conf, String clusterUri, String serviceName) throws IOException, URISyntaxException {
        String zkAddress = null;
        try (MapRFileSystem mfs = null;){
            mfs = new MapRFileSystem();
            mfs.initialize(new URI(clusterUri), conf);
            zkAddress = mfs.getZkConnectString();
            LOG.info((Object)("zkAddress(" + zkAddress + ")"));
        }
        if (zkAddress == null) {
            LOG.error((Object)("Zookeeper address is null from MapRFilesystem from cluster " + clusterUri));
            return null;
        }
        ZKDataRetrieval zkConnection = new ZKDataRetrieval(zkAddress);
        Common.ServiceData hostInfo = zkConnection.getServiceMasterData(serviceName);
        if (hostInfo == null) {
            LOG.error((Object)("Unable to determine service " + serviceName + " address from Zookeeper at " + zkAddress + " from cluster " + clusterUri));
            return null;
        }
        String hostName = hostInfo.getHost();
        int servicePort = hostInfo.getPort();
        LOG.info((Object)(serviceName + " address: host name(" + hostName + "), port(" + servicePort + ")"));
        if (servicePort > 0) {
            return hostName + ":" + servicePort;
        }
        return hostName;
    }

    static String removeClusterPrefix(String tablePathName) {
        String ret = null;
        if (tablePathName.startsWith(CLUSTERPREFIX)) {
            String sub = tablePathName.substring(CLUSTERPREFIX.length());
            String[] splits = sub.split("/", 2);
            ret = "/" + splits[1];
        } else if (tablePathName.startsWith(CLUSTERPREFIX2)) {
            String sub = tablePathName.substring(CLUSTERPREFIX2.length());
            String[] splits = sub.split("/", 2);
            ret = "/" + splits[1];
        } else {
            ret = tablePathName;
        }
        LOG.debug((Object)("Extract table path " + ret + " from table name " + tablePathName));
        return ret;
    }

    static String getClusterPrefix(String tablePathName) {
        String ret = null;
        if (tablePathName.startsWith(CLUSTERPREFIX)) {
            String sub = tablePathName.substring(CLUSTERPREFIX.length());
            String[] splits = sub.split("/", 2);
            ret = CLUSTERPREFIX + splits[0];
        } else if (tablePathName.startsWith(CLUSTERPREFIX2)) {
            String sub = tablePathName.substring(CLUSTERPREFIX2.length());
            String[] splits = sub.split("/", 2);
            ret = CLUSTERPREFIX2 + splits[0];
        }
        LOG.debug((Object)("Extract cluster " + ret + " from table name " + tablePathName));
        return ret;
    }

    static String getClusterPrefixFull(String tablePathName) {
        String ret = null;
        if (tablePathName.startsWith(CLUSTERPREFIX)) {
            String sub = tablePathName.substring(CLUSTERPREFIX.length());
            String[] splits = sub.split("/", 2);
            ret = CLUSTERPREFIX + splits[0];
        } else if (tablePathName.startsWith(CLUSTERPREFIX2)) {
            String sub = tablePathName.substring(CLUSTERPREFIX2.length());
            String[] splits = sub.split("/", 2);
            ret = CLUSTERPREFIX + splits[0];
        }
        LOG.debug((Object)("Extract cluster " + ret + " from table name " + tablePathName));
        return ret;
    }

    static boolean isTable(Configuration conf, String tableName) throws IOException, URISyntaxException {
        return SegKeyRangeUtil.isTable(conf, new Path(tableName));
    }

    static boolean isTable(Configuration conf, Path tablePath) throws IOException, URISyntaxException {
        MapRFileSystem mfs = (MapRFileSystem)MapRFileSystem.get((Configuration)conf);
        return mfs.isTable(tablePath);
    }

    static boolean tablesAreSame(Configuration conf, String table1, String table2) throws IOException, URISyntaxException {
        String table2pathwithincluster;
        String cluster2;
        MapRFileSystem mfs = (MapRFileSystem)MapRFileSystem.get((Configuration)conf);
        String cluster1 = mfs.getClusterName(new URI(table1));
        if (!cluster1.equals(cluster2 = mfs.getClusterName(new URI(table2)))) {
            LOG.debug((Object)(table1 + "'s cluster(" + cluster1 + ") is different from " + table2 + "'s cluster(" + cluster2 + ")"));
            return false;
        }
        Path table1path = mfs.makeAbsolute(new Path(table1));
        Path table2path = mfs.makeAbsolute(new Path(table2));
        String table1pathwithincluster = SegKeyRangeUtil.removeClusterPrefix(table1path.toString());
        if (!table1pathwithincluster.equals(table2pathwithincluster = SegKeyRangeUtil.removeClusterPrefix(table2path.toString()))) {
            LOG.debug((Object)("In cluster " + cluster1 + " " + table1 + "'s path(" + table1pathwithincluster + ") is different from " + table2 + "'s path(" + table2pathwithincluster + ")"));
            return false;
        }
        LOG.info((Object)(cluster1 + ":" + table1pathwithincluster + " is same as " + cluster2 + ":" + table2pathwithincluster));
        return true;
    }

    static List<ImmutableBytesWritable> getRegionStartKeys(HTable table) throws IOException {
        byte[][] byteKeys = table.getStartKeys();
        ArrayList<ImmutableBytesWritable> ret = new ArrayList<ImmutableBytesWritable>(byteKeys.length);
        for (byte[] byteKey : byteKeys) {
            ret.add(new ImmutableBytesWritable(byteKey));
        }
        return ret;
    }

    public static Scan buildScan(String jobname, Configuration conf) {
        Scan scan = new Scan();
        long startTime = conf.getLong(jobname + ".startTime", 0L);
        long endTime = conf.getLong(jobname + ".endTime", Long.MAX_VALUE);
        String columnSpec = conf.get(jobname + ".columnSpec", null);
        if (columnSpec != null) {
            String[] cols;
            for (String col : cols = columnSpec.split(",")) {
                if (col.contains(":")) {
                    String[] names = col.split(":");
                    scan.addColumn(Bytes.toBytes((String)names[0]), Bytes.toBytes((String)names[1]));
                    continue;
                }
                scan.addFamily(Bytes.toBytes((String)col));
            }
        }
        try {
            scan.setTimeRange(startTime, endTime);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        scan.setMaxVersions(conf.getInt(jobname + ".maxVersions", Integer.MAX_VALUE));
        return scan;
    }

    static void writeTabletKeyRange(String tblKeyPathName, String tblName) throws IOException {
        Configuration conf = new Configuration();
        HTable table = new HTable(conf, tblName);
        List<ImmutableBytesWritable> tblKeys = SegKeyRangeUtil.getRegionStartKeys(table);
        TreeSet<ImmutableBytesWritable> sortedTblKeys = new TreeSet<ImmutableBytesWritable>(tblKeys);
        ImmutableBytesWritable first = sortedTblKeys.first();
        if (!first.equals((Object)HConstants.EMPTY_BYTE_ARRAY)) {
            throw new IllegalArgumentException("First region of table should have empty start key. Instead has: " + Bytes.toStringBinary((byte[])first.get()));
        }
        ImmutableBytesWritable[] sortedList = sortedTblKeys.toArray(new ImmutableBytesWritable[sortedTblKeys.size()]);
        LOG.info((Object)("write region start keys to " + tblKeyPathName + " for table " + tblName));
        SegKeyRangeUtil.writeKeyRange(conf, tblKeyPathName, Arrays.asList(sortedList));
    }

    static void splitSubRegionKeysbyRegionKeys(String inputRegionKeyFileName, String inputSubRegionKeyFileName, String outputSplitKeyFileName, String outputSubRegionKeyDir) throws IOException {
        Configuration conf = new Configuration();
        List<ImmutableBytesWritable> tblKeys = SegKeyRangeUtil.readKeyRange(conf, inputRegionKeyFileName);
        SegKeyRangeUtil.splitSubRegionKeysbyRegionKeys(tblKeys, inputSubRegionKeyFileName, outputSplitKeyFileName, outputSubRegionKeyDir);
    }

    static void splitSubRegionKeysbyRegionKeys(List<ImmutableBytesWritable> tblKeys, String inputSubRegionKeyFileName, String outputSplitKeyFileName, String outputSubRegionKeyDir) throws IOException {
        String tblSegKeysFileName;
        byte[] rKey1;
        Configuration conf = new Configuration();
        Iterator<ImmutableBytesWritable> itTblKeys = tblKeys.iterator();
        ImmutableBytesWritable curTblStartKey = itTblKeys.next();
        Object curTblEndKey = null;
        if (itTblKeys.hasNext()) {
            curTblEndKey = itTblKeys.next();
        }
        ArrayList<ImmutableBytesWritable> curTblSegKeys = new ArrayList<ImmutableBytesWritable>();
        ArrayList<ImmutableBytesWritable> tblSplitKeys = new ArrayList<ImmutableBytesWritable>();
        Path partitionsPath = new Path(inputSubRegionKeyFileName);
        FileSystem fs = partitionsPath.getFileSystem(conf);
        SequenceFile.Reader reader = new SequenceFile.Reader(fs, partitionsPath, conf);
        ImmutableBytesWritable iKey = new ImmutableBytesWritable();
        NullWritable value = NullWritable.get();
        LOG.info((Object)("readSegKeyRange: " + partitionsPath.toString()));
        if (!reader.next((Writable)iKey, (Writable)value)) {
            reader.close();
            throw new IOException("No  key in sub-region file " + inputSubRegionKeyFileName);
        }
        byte[] rKey2 = rKey1 = iKey.get();
        if (!iKey.equals((Object)HConstants.EMPTY_BYTE_ARRAY)) {
            reader.close();
            throw new IOException("First segment of the table should have empty start key. Instead has: " + Bytes.toStringBinary((byte[])iKey.get()));
        }
        curTblSegKeys.add(new ImmutableBytesWritable(iKey));
        int cnt = 1;
        while (reader.next((Writable)iKey, (Writable)value)) {
            rKey1 = rKey2;
            if (Bytes.compareTo((byte[])rKey1, (byte[])(rKey2 = iKey.get())) >= 0) {
                reader.close();
                throw new IOException("Current keyrange startky(" + Bytes.toStringBinary((byte[])rKey2) + ") should be larger than the previous keyrange startkey(" + Bytes.toStringBinary((byte[])rKey1) + ")");
            }
            if (curTblEndKey == null || Bytes.compareTo((byte[])rKey2, (byte[])curTblEndKey.get()) < 0) {
                curTblSegKeys.add(new ImmutableBytesWritable(rKey2));
            } else {
                tblSegKeysFileName = KEYPREFIX + Bytes.toStringBinary((byte[])((ImmutableBytesWritable)curTblSegKeys.get(0)).get());
                if (((ImmutableBytesWritable)curTblSegKeys.get(0)).equals((Object)HConstants.EMPTY_BYTE_ARRAY)) {
                    tblSegKeysFileName = FIRSTKEYNAME;
                }
                LOG.info((Object)(Integer.toString(curTblSegKeys.size()) + " segments to write."));
                SegKeyRangeUtil.writeKeyRange(conf, outputSubRegionKeyDir + "/" + tblSegKeysFileName, curTblSegKeys);
                tblSplitKeys.add(new ImmutableBytesWritable(curTblSegKeys.get(0)));
                curTblSegKeys.clear();
                curTblStartKey = curTblEndKey;
                curTblEndKey = itTblKeys.hasNext() ? itTblKeys.next() : null;
                curTblSegKeys.add(new ImmutableBytesWritable(rKey2));
            }
            ++cnt;
        }
        if (curTblSegKeys.size() > 0) {
            tblSegKeysFileName = KEYPREFIX + Bytes.toStringBinary((byte[])((ImmutableBytesWritable)curTblSegKeys.get(0)).get());
            if (((ImmutableBytesWritable)curTblSegKeys.get(0)).equals((Object)HConstants.EMPTY_BYTE_ARRAY)) {
                tblSegKeysFileName = FIRSTKEYNAME;
            }
            SegKeyRangeUtil.writeKeyRange(conf, outputSubRegionKeyDir + "/" + tblSegKeysFileName, curTblSegKeys);
            tblSplitKeys.add(new ImmutableBytesWritable(curTblSegKeys.get(0)));
        }
        reader.close();
        SegKeyRangeUtil.writeKeyRange(conf, outputSplitKeyFileName, tblSplitKeys);
        LOG.info((Object)("Total " + cnt + " segement startKey written into " + tblSplitKeys.size() + " tablet key range files."));
    }

    static List<ImmutableBytesWritable> getSegmentStartKeys(HTable table) throws IOException {
        Scan scan = new Scan();
        scan.setFilter((Filter)new KeySamplingFilter());
        ResultScanner scanner = table.getScanner(scan);
        ArrayList<ImmutableBytesWritable> ret = new ArrayList<ImmutableBytesWritable>();
        Result res = scanner.next();
        int cnt = 0;
        while (res != null) {
            byte[] rowKey = res.getRow();
            ret.add(new ImmutableBytesWritable(rowKey));
            res = scanner.next();
            ++cnt;
        }
        LOG.info((Object)("Total segement count(" + cnt + ")"));
        table.close();
        return ret;
    }

    static Pair<byte[][], byte[][]> GenStartEndKeys(List<ImmutableBytesWritable> startKeys) throws IOException {
        if (startKeys.isEmpty()) {
            throw new IllegalArgumentException("No regions passed");
        }
        ArrayList<byte[]> sklist = new ArrayList<byte[]>(startKeys.size());
        ArrayList<byte[]> eklist = new ArrayList<byte[]>(startKeys.size());
        for (ImmutableBytesWritable k : startKeys) {
            sklist.add(k.get());
        }
        if (startKeys.size() > 0) {
            ListIterator<ImmutableBytesWritable> iter = startKeys.listIterator(1);
            while (iter.hasNext()) {
                ImmutableBytesWritable k;
                k = iter.next();
                eklist.add(k.get());
            }
            byte[] lastEndKey = HConstants.EMPTY_BYTE_ARRAY;
            eklist.add(lastEndKey);
        }
        return new Pair(sklist.toArray((T[])new byte[sklist.size()][]), eklist.toArray((T[])new byte[eklist.size()][]));
    }

    static Pair<byte[][], byte[][]> PickRangeByStartKey(List<ImmutableBytesWritable> startKeys, Pair<byte[][], byte[][]> origRange) throws IOException {
        if (startKeys.isEmpty()) {
            throw new IllegalArgumentException("No regions passed");
        }
        ArrayList<byte[]> sklist = new ArrayList<byte[]>(startKeys.size());
        ArrayList<byte[]> eklist = new ArrayList<byte[]>(startKeys.size());
        byte[][] origSKeyArray = (byte[][])origRange.getFirst();
        byte[][] origEKeyArray = (byte[][])origRange.getSecond();
        int i = 0;
        int j = 0;
        while (i < startKeys.size() && j < origSKeyArray.length) {
            if (Bytes.compareTo((byte[])startKeys.get(i).get(), (byte[])origSKeyArray[j]) > 0) {
                ++j;
                continue;
            }
            if (Bytes.compareTo((byte[])startKeys.get(i).get(), (byte[])origSKeyArray[j]) < 0) {
                LOG.error((Object)("Start key " + Bytes.toStringBinary((byte[])startKeys.get(i).get()) + "does not exist in input key range. " + "The close start key found is " + Bytes.toStringBinary((byte[])origSKeyArray[j])));
                ++i;
                continue;
            }
            sklist.add(startKeys.get(i).get());
            eklist.add(origEKeyArray[j]);
            LOG.error((Object)("Pick Range Start key " + Bytes.toStringBinary((byte[])startKeys.get(i).get()) + "End key " + Bytes.toStringBinary((byte[])origEKeyArray[j])));
            ++i;
            ++j;
        }
        return new Pair(sklist.toArray((T[])new byte[sklist.size()][]), eklist.toArray((T[])new byte[eklist.size()][]));
    }

    static void writeSegKeyRange(String segKeyPathName, String tblName) throws IOException {
        byte[] rKey1;
        Configuration conf = new Configuration();
        LOG.info((Object)("writeSegKeyRange to file " + segKeyPathName + " for table " + tblName));
        Path partitionsPath = new Path(segKeyPathName);
        FileSystem fs = partitionsPath.getFileSystem(conf);
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)partitionsPath, ImmutableBytesWritable.class, NullWritable.class);
        HTable table = new HTable(conf, tblName);
        Scan scan = new Scan();
        scan.setFilter((Filter)new KeySamplingFilter());
        ResultScanner scanner = table.getScanner(scan);
        Result res = scanner.next();
        if (res == null) {
            table.close();
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("No segment key range returned from server. Write only -INF(EMPTY_BYTE_ARRAY) segment start key to " + partitionsPath.toString() + " for empty table " + tblName));
            }
            LOG.debug((Object)("\t (" + Bytes.toStringBinary((byte[])HConstants.EMPTY_BYTE_ARRAY) + ")"));
            writer.append((Writable)new ImmutableBytesWritable(HConstants.EMPTY_BYTE_ARRAY), (Writable)NullWritable.get());
            writer.close();
            return;
        }
        byte[] rKey2 = rKey1 = res.getRow();
        ImmutableBytesWritable iKey = new ImmutableBytesWritable(rKey1);
        if (!iKey.equals((Object)HConstants.EMPTY_BYTE_ARRAY)) {
            table.close();
            throw new IOException("First region of table should have empty start key. Instead has: " + Bytes.toStringBinary((byte[])iKey.get()));
        }
        LOG.info((Object)("write segment start keys to " + partitionsPath.toString() + " for table " + tblName));
        LOG.debug((Object)("\t (" + Bytes.toStringBinary((byte[])iKey.get()) + ")"));
        writer.append((Writable)iKey, (Writable)NullWritable.get());
        int cnt = 1;
        res = scanner.next();
        while (res != null) {
            rKey1 = rKey2;
            if (Bytes.compareTo((byte[])rKey1, (byte[])(rKey2 = res.getRow())) >= 0) {
                table.close();
                writer.close();
                throw new IOException("Current keyrange startky(" + Bytes.toStringBinary((byte[])rKey2) + ") should be larger than the previous keyrange startkey(" + Bytes.toStringBinary((byte[])rKey1) + ")");
            }
            iKey = new ImmutableBytesWritable(rKey2);
            LOG.debug((Object)("\t (" + Bytes.toStringBinary((byte[])rKey2) + ")"));
            writer.append((Writable)iKey, (Writable)NullWritable.get());
            res = scanner.next();
            ++cnt;
        }
        table.close();
        writer.close();
        LOG.info((Object)("Total " + cnt + " segement startKey written."));
    }

    static void writeKeyRange(Configuration conf, String partitionsPathName, List<ImmutableBytesWritable> startKeys) throws IOException {
        SegKeyRangeUtil.writeKeyRange(conf, new Path(partitionsPathName), startKeys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeKeyRange(Configuration conf, Path partitionsPath, List<ImmutableBytesWritable> startKeys) throws IOException {
        if (startKeys.isEmpty()) {
            throw new IllegalArgumentException("No regions passed");
        }
        Path parentPath = partitionsPath.getParent();
        FileSystem fs = partitionsPath.getFileSystem(conf);
        if (!fs.exists(parentPath)) {
            LOG.debug((Object)("create directory " + parentPath.toString()));
            fs.mkdirs(parentPath);
        }
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)partitionsPath, ImmutableBytesWritable.class, NullWritable.class);
        LOG.info((Object)("writeSegKeyRange to file " + partitionsPath.toString()));
        ImmutableBytesWritable prevKey = null;
        try {
            for (ImmutableBytesWritable startKey : startKeys) {
                if (prevKey != null && Bytes.compareTo((byte[])prevKey.get(), (byte[])startKey.get()) >= 0) {
                    throw new IOException("Current startky(" + Bytes.toStringBinary((byte[])startKey.get()) + ") should be larger than the previous startkey(" + Bytes.toStringBinary((byte[])prevKey.get()) + ")");
                }
                LOG.debug((Object)("\t (" + Bytes.toStringBinary((byte[])startKey.get()) + ")"));
                writer.append((Writable)startKey, (Writable)NullWritable.get());
                prevKey = startKey;
            }
        }
        finally {
            writer.close();
        }
    }

    static List<ImmutableBytesWritable> readKeyRange(Configuration conf, String partitionsPathName) throws IOException {
        return SegKeyRangeUtil.readKeyRange(conf, new Path(partitionsPathName));
    }

    static List<ImmutableBytesWritable> readKeyRange(Configuration conf, Path partitionsPath) throws IOException {
        ArrayList<ImmutableBytesWritable> ret = new ArrayList<ImmutableBytesWritable>();
        FileSystem fs = partitionsPath.getFileSystem(conf);
        SequenceFile.Reader reader = new SequenceFile.Reader(fs, partitionsPath, conf);
        byte[] key1 = null;
        byte[] key2 = null;
        ImmutableBytesWritable iKey = new ImmutableBytesWritable();
        NullWritable value = NullWritable.get();
        LOG.info((Object)("readSegKeyRange: " + partitionsPath.toString()));
        int i = 0;
        while (reader.next((Writable)iKey, (Writable)value)) {
            key1 = key2;
            key2 = iKey.get();
            if (i > 0 && Bytes.compareTo((byte[])key1, (byte[])key2) >= 0) {
                reader.close();
                throw new IOException("Current keyrange startky(" + Bytes.toStringBinary((byte[])key2) + ") should be larger than the previous keyrange startkey(" + Bytes.toStringBinary((byte[])key1) + ")");
            }
            LOG.debug((Object)("\t (" + Bytes.toStringBinary((byte[])key2) + ")"));
            ret.add(new ImmutableBytesWritable(iKey));
            ++i;
        }
        LOG.info((Object)("Done readSegKeyRange: " + partitionsPath.toString() + ", list length=" + Integer.toString(i)));
        reader.close();
        return ret;
    }

    public static boolean copyFileWithPrefix(FileSystem fs, Path srcDir, Path dstDir, Configuration conf, String prefix) throws IOException {
        if (!fs.exists(srcDir)) {
            LOG.error((Object)("Source " + srcDir + " doesn't exist."));
            return false;
        }
        if (!fs.getFileStatus(srcDir).isDirectory()) {
            LOG.error((Object)("Source " + srcDir + " is not a directory."));
            return false;
        }
        if (fs.exists(dstDir)) {
            LOG.warn((Object)("Files in destination directory " + dstDir + " will be overwritten."));
            if (!fs.delete(dstDir, true)) {
                LOG.error((Object)("Fail to replace " + dstDir));
                return false;
            }
        }
        if (!fs.mkdirs(dstDir)) {
            LOG.error((Object)("Fail to create " + dstDir));
            return false;
        }
        boolean moved = false;
        Object[] contents = fs.listStatus(srcDir);
        Arrays.sort(contents);
        for (int i = 0; i < contents.length; ++i) {
            Path srcPath = contents[i].getPath();
            if (!contents[i].isFile() || !srcPath.getName().startsWith(prefix)) continue;
            Path dstPath = new Path(dstDir + "/" + srcPath.getName());
            if (!fs.rename(srcPath, dstPath)) {
                LOG.error((Object)("Fail to move " + srcPath.toString() + " to " + dstPath.toString()));
                return false;
            }
            moved = true;
            LOG.debug((Object)("Moved " + srcPath.toString() + " to " + dstPath.toString()));
        }
        if (!moved && !fs.delete(dstDir, true)) {
            LOG.error((Object)("Fail to cleanup empty " + dstDir));
            return false;
        }
        return true;
    }

    static void copyKeyRangeFile(Configuration srcConf, String srcPathName, Configuration dstConf, String dstPathName) throws IOException {
        List<ImmutableBytesWritable> startKeys = SegKeyRangeUtil.readKeyRange(srcConf, srcPathName);
        SegKeyRangeUtil.writeKeyRange(dstConf, dstPathName, startKeys);
    }

    static void copyKeyRangeFile(Configuration srcConf, Path srcPath, Configuration dstConf, Path dstPath) throws IOException {
        List<ImmutableBytesWritable> startKeys = SegKeyRangeUtil.readKeyRange(srcConf, srcPath);
        SegKeyRangeUtil.writeKeyRange(dstConf, dstPath, startKeys);
    }

    static void printKeyRange(List<ImmutableBytesWritable> startKeys) {
        System.out.println("printKeyRange:");
        if (startKeys == null || startKeys.isEmpty()) {
            System.err.println("Input key list is empty\n");
        } else {
            int i = 0;
            for (ImmutableBytesWritable key : startKeys) {
                System.out.println("StartKey of Range " + i + " : (" + Bytes.toStringBinary((byte[])key.get()) + ")");
                ++i;
            }
        }
    }

    static void logKeyRange(List<ImmutableBytesWritable> startKeys) {
        LOG.info((Object)"KeyRange:");
        if (startKeys == null || startKeys.isEmpty()) {
            LOG.error((Object)"Input key list is empty\n");
        } else {
            int i = 0;
            for (ImmutableBytesWritable key : startKeys) {
                LOG.info((Object)("StartKey of Range " + i + " : (" + Bytes.toStringBinary((byte[])key.get()) + ")"));
                ++i;
            }
        }
    }

    static void printStartEndKeys(Pair<byte[][], byte[][]> sekeys) {
        System.out.println("printStartEndKeys:");
        int i = 0;
        for (byte[] key : (byte[][])sekeys.getFirst()) {
            System.out.println("StartKey of Range " + i + " : (" + Bytes.toStringBinary((byte[])key) + ")");
            ++i;
        }
        i = 0;
        for (byte[] key : (byte[][])sekeys.getSecond()) {
            System.out.println("EndKey of Range " + i + " : (" + Bytes.toStringBinary((byte[])key) + ")");
            ++i;
        }
    }

    static void logStartEndKeys(Pair<byte[][], byte[][]> sekeys) {
        LOG.info((Object)"StartEndKeys");
        int i = 0;
        for (byte[] key : (byte[][])sekeys.getFirst()) {
            LOG.info((Object)("StartKey of Range " + i + " : (" + Bytes.toStringBinary((byte[])key) + ")"));
            ++i;
        }
        i = 0;
        for (byte[] key : (byte[][])sekeys.getSecond()) {
            LOG.info((Object)("EndKey of Range " + i + " : (" + Bytes.toStringBinary((byte[])key) + ")"));
            ++i;
        }
    }

    static void writeStringToFile(Configuration conf, String msg, String filePathName) throws IOException {
        Path filePath = new Path(filePathName);
        FileSystem fs = FileSystem.get((Configuration)conf);
        BufferedWriter br = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(filePath, true)));
        LOG.debug((Object)("Write " + msg + " to file " + filePathName));
        br.write(msg);
        br.close();
    }

    static String resultToString(Result res) {
        String ret = "";
        for (Cell c : res.rawCells()) {
            ret = ret + Bytes.toStringBinary((byte[])c.getRowArray(), (int)c.getRowOffset(), (int)c.getRowLength());
            ret = ret + " column=" + Bytes.toStringBinary((byte[])c.getFamilyArray(), (int)c.getFamilyOffset(), (int)c.getFamilyLength());
            if (c.getQualifierLength() > 0) {
                ret = ret + ":" + Bytes.toStringBinary((byte[])c.getQualifierArray(), (int)c.getQualifierOffset(), (int)c.getQualifierLength());
            }
            Long ts = c.getTimestamp();
            ret = ret + " timestamp=" + Long.toString(ts);
            ret = ret + " type=" + KeyValue.Type.codeToType((byte)c.getTypeByte());
            ret = ret + " vlen=" + Integer.toString(c.getValueLength());
            ret = ret + " value=" + Bytes.toStringBinary((byte[])c.getValueArray(), (int)c.getValueOffset(), (int)c.getValueLength()) + "\n";
        }
        return ret.trim();
    }

    private static void printUsage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        System.err.println("This utility is used to read and write segment key ranges.\nUsage:To print this message:\n   hbase com.mapr.fs.hbase.tools.mapreduce.SegKeyRangeUtil [-h, --help]\nTo write the segment key range file for a table:\n   hbase com.mapr.fs.hbase.tools.mapreduce.SegKeyRangeUtil [-w, --write] tablename segkeyfilename\nTo read the segment key range from a file:\n   hbase com.mapr.fs.hbase.tools.mapreduce.SegKeyRangeUtil [-r, --read] segkeyfilename\nTo dump the segment key ranges (first write then read keyrange) from a table:\n   hbase com.mapr.fs.hbase.tools.mapreduce.SegKeyRangeUtil [-d, --dump] tablename segkeyfilename\nTo split the segment key ranges by tablet (each table's keys will be written to a seperate file ):\n   hbase com.mapr.fs.hbase.tools.mapreduce.SegKeyRangeUtil [-s, --split] tablename segkeyoutdir\n");
    }

    private static boolean doCommandLine(String[] args) {
        if (args.length < 1) {
            SegKeyRangeUtil.printUsage(null);
            return false;
        }
        try {
            String cmd = args[0];
            if (cmd.equals("-h") || cmd.startsWith("--h")) {
                SegKeyRangeUtil.printUsage(null);
                return false;
            }
            if (cmd.equals("-w") || cmd.startsWith("--write")) {
                if (args.length < 3) {
                    SegKeyRangeUtil.printUsage(null);
                    return false;
                }
                operation = Operation.WRITE;
                tableFileName = args[1];
                segKeyRangeFileName = args[2];
                return true;
            }
            if (cmd.equals("-r") || cmd.startsWith("--read")) {
                if (args.length < 2) {
                    SegKeyRangeUtil.printUsage(null);
                    return false;
                }
                operation = Operation.READ;
                segKeyRangeFileName = args[1];
                return true;
            }
            if (cmd.equals("-d") || cmd.startsWith("--dump")) {
                if (args.length < 3) {
                    SegKeyRangeUtil.printUsage(null);
                    return false;
                }
                operation = Operation.DUMP;
                tableFileName = args[1];
                segKeyRangeFileName = args[2];
                return true;
            }
            if (cmd.equals("-s") || cmd.startsWith("--split")) {
                if (args.length < 3) {
                    SegKeyRangeUtil.printUsage(null);
                    return false;
                }
                operation = Operation.SPLIT;
                tableFileName = args[1];
                segKeyRangeDirName = args[2];
                return true;
            }
            SegKeyRangeUtil.printUsage(null);
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            SegKeyRangeUtil.printUsage("Can't start because " + e.getMessage());
            return false;
        }
    }

    public int run(String[] args) throws Exception {
        if (!SegKeyRangeUtil.doCommandLine(args)) {
            return 1;
        }
        Configuration conf = this.getConf();
        try {
            if (operation == Operation.READ) {
                LOG.info((Object)("Read segment key ranges from file" + segKeyRangeFileName.toString()));
                List<ImmutableBytesWritable> startKeys = SegKeyRangeUtil.readKeyRange(conf, segKeyRangeFileName);
                SegKeyRangeUtil.printKeyRange(startKeys);
            } else if (operation == Operation.WRITE) {
                LOG.info((Object)("Write segment key ranges of table " + tableFileName + " to file " + segKeyRangeFileName.toString()));
                HTable table = new HTable(conf, tableFileName);
                List<ImmutableBytesWritable> startKeys = SegKeyRangeUtil.getSegmentStartKeys(table);
                SegKeyRangeUtil.writeKeyRange(conf, segKeyRangeFileName, startKeys);
            } else if (operation == Operation.DUMP) {
                LOG.info((Object)("Get segment key ranges of table " + tableFileName + ", outputfile is " + segKeyRangeFileName.toString()));
                HTable table = new HTable(conf, tableFileName);
                SegKeyRangeUtil.writeSegKeyRange(segKeyRangeFileName, tableFileName);
                List<ImmutableBytesWritable> startKeys2 = SegKeyRangeUtil.readKeyRange(conf, segKeyRangeFileName);
                System.out.println("\nStartKeys read back from file " + segKeyRangeFileName + " :\n");
                SegKeyRangeUtil.printKeyRange(startKeys2);
                System.out.println("\nStart End Keys from the table");
                Pair sekeys = table.getStartEndKeys();
                table.close();
                SegKeyRangeUtil.printStartEndKeys((Pair<byte[][], byte[][]>)sekeys);
                System.out.println("\nStart End Keys generated from start keys");
                Pair<byte[][], byte[][]> gensekeys = SegKeyRangeUtil.GenStartEndKeys(startKeys2);
                SegKeyRangeUtil.printStartEndKeys(gensekeys);
            } else if (operation == Operation.SPLIT) {
                LOG.info((Object)("segKeyRangeDirName = (" + segKeyRangeDirName + ")"));
                SegKeyRangeUtil.writeSegKeyRange(segKeyRangeDirName + "/" + SegKeyRangeUtil.getSegKeyFileName(tableFileName), tableFileName);
                SegKeyRangeUtil.writeTabletKeyRange(segKeyRangeDirName + "/" + SegKeyRangeUtil.getTabletKeyFileName(tableFileName), tableFileName);
                SegKeyRangeUtil.splitSubRegionKeysbyRegionKeys(segKeyRangeDirName + "/" + SegKeyRangeUtil.getTabletKeyFileName(tableFileName), segKeyRangeDirName + "/" + SegKeyRangeUtil.getSegKeyFileName(tableFileName), segKeyRangeDirName + "/" + SegKeyRangeUtil.getReSplitedTabletKeyFileName(tableFileName), segKeyRangeDirName + "/" + SegKeyRangeUtil.getSegKeyDirName(tableFileName));
            } else {
                System.err.println("Operation is not Recognized.");
                return 1;
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    public static void main(String[] args) {
        int ret = 0;
        try {
            ret = ToolRunner.run((Configuration)new Configuration(), (Tool)new SegKeyRangeUtil(), (String[])args);
        }
        catch (Exception e) {
            ret = 1;
            e.printStackTrace();
        }
        System.exit(ret);
    }

    public class ServiceName {
        public static final String HISTORYSERVERNAME = "historyserver";
        public static final String RESOURCEMANAGERNAME = "resourcemanager";
    }

    static enum Operation {
        READ,
        WRITE,
        DUMP,
        SPLIT;

    }
}

