/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.MapRHTable;
import com.mapr.fs.jni.MapRKeyValue;
import com.mapr.fs.jni.MapRPut;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;

public class PutConverter {
    public static MapRPut toMapRPut(Delete delete, MapRHTable htable) throws IOException {
        Map familyMap = delete.getFamilyMap();
        if (familyMap.size() == 0) {
            return PutConverter.createMapRPut(delete.getRow(), familyMap, (byte)17, delete.getTimeStamp(), htable, false);
        }
        return PutConverter.createMapRPut(delete.getRow(), familyMap, (byte)20, delete.getTimeStamp(), htable, true);
    }

    public static MapRPut toMapRPut(Append append, MapRHTable htable) throws IOException {
        return PutConverter.createMapRPut(append.getRow(), append.getFamilyMap(), (byte)0, append.getTimeStamp(), htable, false);
    }

    public static MapRPut toMapRPut(Put put, MapRHTable htable) throws IOException {
        return PutConverter.createMapRPut(put.getRow(), put.getFamilyMap(), (byte)0, put.getTimeStamp(), htable, false);
    }

    public static MapRPut createMapRPut(byte[] key, Map<byte[], List<KeyValue>> familyMap, byte type, long rowTimeStamp, MapRHTable htable, boolean deleteCell) throws IOException {
        int id = 0;
        MapRPut mrput = new MapRPut();
        mrput.numFamilies = 0;
        mrput.numCells = 0;
        mrput.type = type;
        mrput.rowTimeStamp = rowTimeStamp;
        TreeMap<Integer, List<KeyValue>> familyIdMap = new TreeMap<Integer, List<KeyValue>>();
        for (Map.Entry<byte[], List<KeyValue>> entry : familyMap.entrySet()) {
            List<KeyValue> cells = entry.getValue();
            if (cells.size() <= 0) continue;
            try {
                id = htable.getFamilyId(Bytes.toString((byte[])entry.getKey()));
            }
            catch (IOException ioe) {
                throw new IOException("Invalid column family " + Bytes.toString((byte[])entry.getKey()), ioe);
            }
            Collections.sort(cells, KeyValue.COMPARATOR);
            familyIdMap.put(id, cells);
            ++mrput.numFamilies;
            mrput.numCells += cells.size();
        }
        mrput.key = key;
        mrput.rowTotalBytes += (long)(mrput.key.length + 8);
        if (mrput.numCells > 0) {
            mrput.families = new int[mrput.numFamilies];
            mrput.keyvals = new MapRKeyValue[mrput.numCells];
            mrput.cellsPerFamily = new int[mrput.numFamilies];
            int ccount = 0;
            int fcount = 0;
            for (Map.Entry entry : familyIdMap.entrySet()) {
                mrput.families[fcount] = (Integer)entry.getKey();
                mrput.cellsPerFamily[fcount] = 0;
                List cells = (List)entry.getValue();
                int lb = 0;
                while (lb < cells.size()) {
                    int i;
                    int ub;
                    for (ub = lb; ub < cells.size() && ub != cells.size() - 1 && Bytes.compareTo((byte[])((KeyValue)cells.get(ub)).getQualifier(), (byte[])((KeyValue)cells.get(ub + 1)).getQualifier()) == 0; ++ub) {
                    }
                    TreeMap<Long, KeyValue> cellTreeMap = new TreeMap<Long, KeyValue>();
                    for (i = lb; i <= ub; ++i) {
                        KeyValue cell = (KeyValue)cells.get(i);
                        cellTreeMap.put(cell.getTimestamp(), cell);
                    }
                    i = 0;
                    for (KeyValue kv : cellTreeMap.descendingMap().values()) {
                        boolean deleteColumn = false;
                        if (deleteCell && kv.isDeleteType()) {
                            deleteColumn = true;
                        }
                        mrput.keyvals[ccount] = new MapRKeyValue(kv.getBuffer(), kv.getQualifierOffset(), kv.getQualifierLength(), kv.getValueOffset(), kv.getValueLength(), kv.getTimestamp(), i == 0, i == cellTreeMap.size() - 1, deleteColumn);
                        mrput.rowTotalBytes += (long)(kv.getQualifierLength() + kv.getValueLength() + 8);
                        int n = fcount;
                        mrput.cellsPerFamily[n] = mrput.cellsPerFamily[n] + 1;
                        ++ccount;
                        ++i;
                    }
                    lb = ub + 1;
                }
                ++fcount;
            }
        }
        return mrput;
    }
}

