/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.mapr.BaseTableMappingRules;
import org.apache.hadoop.hbase.client.mapr.TableMappingRulesFactory;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TableMappingRuleTest {
    static Configuration conf_;
    static FileSystem fs_;
    private static String home_;

    @BeforeClass
    public static void setup() throws IOException {
        conf_ = HBaseConfiguration.create();
        fs_ = FileSystem.get((Configuration)conf_);
        home_ = fs_.getHomeDirectory().toString();
    }

    @Test
    public void testNoPathMapping() throws IOException {
        conf_.set("hbase.table.namespace.mappings", "");
        BaseTableMappingRules tableMappingRule = TableMappingRulesFactory.create((Configuration)conf_);
        this.checkAlwaysMaprTables(tableMappingRule);
        Assert.assertFalse((boolean)tableMappingRule.isMapRTable("hbasetable"));
        Assert.assertNull((Object)tableMappingRule.getMaprTablePath("hbasetable"));
    }

    @Test
    public void testAbsoluteMappings() throws IOException {
        conf_.set("hbase.table.namespace.mappings", "table1:/root/t1,table2:/user/abc/r/,table1*:/p/q,table*:/x/y,aditya1:maprfs:/mapr/cluster1/user/aditya/default,aditya2:maprfs://mapr/cluster2/user/aditya/default,aditya*:maprfs:///mapr/cluster3/user/aditya");
        BaseTableMappingRules tableMappingRule = TableMappingRulesFactory.create((Configuration)conf_);
        this.checkAlwaysMaprTables(tableMappingRule);
        Assert.assertTrue((boolean)tableMappingRule.isMapRTable("table1"));
        Assert.assertEquals((Object)tableMappingRule.getMaprTablePath("table1"), (Object)new Path("/root/t1"));
        Assert.assertTrue((boolean)tableMappingRule.isMapRTable("table2"));
        Assert.assertEquals((Object)tableMappingRule.getMaprTablePath("table2"), (Object)new Path("/user/abc/r/table2"));
        Assert.assertTrue((boolean)tableMappingRule.isMapRTable("table123"));
        Assert.assertEquals((Object)tableMappingRule.getMaprTablePath("table123"), (Object)new Path("/p/q/table123"));
        Assert.assertTrue((boolean)tableMappingRule.isMapRTable("table23"));
        Assert.assertEquals((Object)tableMappingRule.getMaprTablePath("table23"), (Object)new Path("/x/y/table23"));
        Assert.assertTrue((boolean)tableMappingRule.isMapRTable("aditya1"));
        Assert.assertEquals((Object)tableMappingRule.getMaprTablePath("aditya1"), (Object)new Path("maprfs:/mapr/cluster1/user/aditya/default"));
        Assert.assertTrue((boolean)tableMappingRule.isMapRTable("aditya2"));
        Assert.assertEquals((Object)tableMappingRule.getMaprTablePath("aditya2"), (Object)new Path("maprfs:/mapr/cluster2/user/aditya/default"));
        Assert.assertTrue((boolean)tableMappingRule.isMapRTable("aditya"));
        Assert.assertEquals((Object)tableMappingRule.getMaprTablePath("aditya"), (Object)new Path("maprfs:/mapr/cluster3/user/aditya/aditya"));
        Assert.assertFalse((boolean)tableMappingRule.isMapRTable("tabl1"));
        Assert.assertNull((Object)tableMappingRule.getMaprTablePath("tabl1"));
    }

    @Test
    public void testDirectMappings() throws IOException {
        conf_.set("hbase.table.namespace.mappings", "table1:a/b, table2:/user/abc/r/s, table1*:p/q, table*:/x/y");
        BaseTableMappingRules tableMappingRule = TableMappingRulesFactory.create((Configuration)conf_);
        this.checkAlwaysMaprTables(tableMappingRule);
        Assert.assertTrue((boolean)tableMappingRule.isMapRTable("table1"));
        Assert.assertEquals((Object)tableMappingRule.getMaprTablePath("table1"), (Object)new Path(home_, "a/b"));
        Assert.assertTrue((boolean)tableMappingRule.isMapRTable("table2"));
        Assert.assertEquals((Object)tableMappingRule.getMaprTablePath("table2"), (Object)new Path("/user/abc/r/s"));
        Assert.assertTrue((boolean)tableMappingRule.isMapRTable("table123"));
        Assert.assertEquals((Object)tableMappingRule.getMaprTablePath("table123"), (Object)new Path(home_, "p/q/table123"));
        Assert.assertTrue((boolean)tableMappingRule.isMapRTable("table23"));
        Assert.assertEquals((Object)tableMappingRule.getMaprTablePath("table23"), (Object)new Path("/x/y/table23"));
        Assert.assertFalse((boolean)tableMappingRule.isMapRTable("tabl1"));
        Assert.assertNull((Object)tableMappingRule.getMaprTablePath("tabl1"));
    }

    @Test
    public void testMappedRelativePaths() throws IOException {
        conf_.set("hbase.table.namespace.mappings", "table1:a/b/v/, table1*:p/q/r/, table*:x/y/");
        BaseTableMappingRules tableMappingRule = TableMappingRulesFactory.create((Configuration)conf_);
        this.checkAlwaysMaprTables(tableMappingRule);
        Assert.assertTrue((boolean)tableMappingRule.isMapRTable("table1"));
        Assert.assertEquals((Object)tableMappingRule.getMaprTablePath("table1"), (Object)new Path(home_, "a/b/v/table1"));
        Assert.assertTrue((boolean)tableMappingRule.isMapRTable("table123"));
        Assert.assertEquals((Object)tableMappingRule.getMaprTablePath("table123"), (Object)new Path(home_, "p/q/r/table123"));
        Assert.assertTrue((boolean)tableMappingRule.isMapRTable("table23"));
        Assert.assertEquals((Object)tableMappingRule.getMaprTablePath("table23"), (Object)new Path(home_, "x/y/table23"));
        Assert.assertFalse((boolean)tableMappingRule.isMapRTable("atable1"));
        Assert.assertNull((Object)tableMappingRule.getMaprTablePath("atable1"));
    }

    protected void checkAlwaysMaprTables(BaseTableMappingRules tableMappingRule) throws IOException {
        Assert.assertTrue((boolean)tableMappingRule.isMapRTable("/a/b/c/d"));
        Assert.assertEquals((Object)tableMappingRule.getMaprTablePath("/a/b/c/d"), (Object)new Path("/a/b/c/d"));
        Assert.assertTrue((boolean)tableMappingRule.isMapRTable("b/c/d"));
        Assert.assertEquals((Object)tableMappingRule.getMaprTablePath("b/c/d"), (Object)new Path(home_, "b/c/d"));
        Assert.assertTrue((boolean)tableMappingRule.isMapRTable("maprfs:///x/y/z"));
        Assert.assertEquals((Object)tableMappingRule.getMaprTablePath("maprfs:///x/y/z"), (Object)new Path("maprfs:///x/y/z"));
    }
}

