/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.HRegionConverter;
import com.mapr.fs.MapRDBConstants;
import com.mapr.fs.MapRFileStatus;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.MapRTabletScanner;
import com.mapr.fs.SchemaHelper;
import com.mapr.fs.TableProperties;
import com.mapr.fs.proto.Dbserver;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.InvalidFamilyOperationException;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.mapr.AbstractHBaseAdmin;
import org.apache.hadoop.hbase.client.mapr.BaseTableMappingRules;
import org.apache.hadoop.hbase.util.Bytes;

public class HBaseAdminImpl
extends AbstractHBaseAdmin
implements MapRDBConstants {
    private static final Log LOG = LogFactory.getLog(HBaseAdminImpl.class);
    private volatile MapRFileSystem maprfs_;
    private final BaseTableMappingRules tableMappingRule_;

    public HBaseAdminImpl(Configuration c, BaseTableMappingRules tableMappingRule) {
        try {
            this.tableMappingRule_ = tableMappingRule;
            this.maprfs_ = (MapRFileSystem)FileSystem.get((URI)new URI("maprfs:///"), (Configuration)c);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while instantiating HBaseAdminImpl", e);
        }
    }

    public void close() throws IOException {
        this.maprfs_.close();
    }

    public boolean tableExists(String tablePath) throws IOException {
        return this.maprfs_.isTable(this.getTablePath(tablePath));
    }

    public HTableDescriptor[] listTables() throws IOException {
        return this.listTables(null);
    }

    public HTableDescriptor[] listTables(String lookupPattern) throws IOException {
        ArrayList<HTableDescriptor> descriptors = new ArrayList<HTableDescriptor>();
        FileStatus[] status = this.doListTables(lookupPattern);
        if (status != null && status.length > 0) {
            for (int i = 0; i < status.length; ++i) {
                descriptors.add(SchemaHelper.toHTableDescriptor(this.maprfs_, status[i].getPath(), lookupPattern == null || !lookupPattern.contains("/")));
            }
        }
        return descriptors.toArray(new HTableDescriptor[descriptors.size()]);
    }

    protected FileStatus[] doListTables(String lookupPath) throws IOException {
        Path path = null;
        if (lookupPath == null || lookupPath.length() == 0 || lookupPath.equals(".*")) {
            path = this.tableMappingRule_.getDefaultTablePath();
            if (!this.maprfs_.exists(path)) {
                throw new IOException("doListTables() called for default path(" + path.toUri().getPath() + "), but it does not exists.");
            }
        } else {
            path = this.getTablePath(lookupPath);
        }
        if (this.maprfs_.isTable(path)) {
            return new FileStatus[]{this.maprfs_.getFileStatus(path)};
        }
        String name = ".*";
        if (!this.maprfs_.exists(path)) {
            Path parent = path.getParent();
            if (!this.maprfs_.exists(parent)) {
                throw new IOException("Path '" + path.toString() + "' or its parent does not exist.");
            }
            name = path.getName();
            path = parent;
        }
        final Pattern filter = Pattern.compile(name);
        return this.maprfs_.listStatus(path, new PathFilter(){

            public boolean accept(Path path) {
                return filter.matcher(path.getName()).matches() && HBaseAdminImpl.this.maprfs_.isTable(path);
            }
        });
    }

    public HTableDescriptor getTableDescriptor(String tableName) throws TableNotFoundException, IOException {
        if (tableName == null || tableName.length() == 0) {
            return null;
        }
        return this.getTableDescriptor(this.getTablePath(tableName));
    }

    protected HTableDescriptor getTableDescriptor(Path tablePath) throws TableNotFoundException, IOException {
        this.checkTable(tablePath);
        return SchemaHelper.toHTableDescriptor(this.maprfs_, tablePath);
    }

    public void createTable(HTableDescriptor desc, byte[][] splitKeys) throws IOException {
        if (desc == null || desc.getName() == null) {
            throw new IllegalArgumentException("Table descriptor or name can not be null: " + desc);
        }
        try {
            Path path = this.getTablePath(desc.getName());
            if (this.maprfs_.exists(path)) {
                throw new TableExistsException(path.toString());
            }
            this.maprfs_.createTable(path, splitKeys);
            for (HColumnDescriptor cf : desc.getFamilies()) {
                String name = cf.getNameAsString();
                this.maprfs_.createColumnFamily(path, name, SchemaHelper.toSchemaFamily(cf, false));
            }
            TableProperties.setTableProperties(path, desc.getValues());
            LOG.debug((Object)("Created table " + path));
        }
        catch (IOException e) {
            LOG.debug((Object)("Error creating table '" + desc.getNameAsString() + "': " + e.getMessage()));
            throw e;
        }
    }

    public void deleteTable(String tablePath) throws IOException {
        this.deleteTable(this.getTablePath(tablePath));
    }

    public void deleteTable(Path tablePath) throws IOException {
        this.checkTable(tablePath);
        MapRFileStatus status = this.maprfs_.getMapRFileStatus(tablePath);
        if (!status.isTable()) {
            throw new IOException("Path '" + tablePath.toString() + "' is not a table");
        }
        this.maprfs_.delete(tablePath, false);
        TableProperties.removeProperties(tablePath);
        LOG.debug((Object)("Deleted table " + tablePath));
    }

    public HTableDescriptor[] deleteTables(String lookupPath) throws IOException {
        LinkedList<HTableDescriptor> failed = new LinkedList<HTableDescriptor>();
        FileStatus[] tables = this.doListTables(lookupPath);
        if (tables != null && tables.length > 0) {
            for (FileStatus table : tables) {
                Path path = table.getPath();
                try {
                    this.deleteTable(path);
                }
                catch (IOException ex) {
                    LOG.info((Object)("Failed to delete table " + path.getName()), (Throwable)ex);
                    failed.add(SchemaHelper.toHTableDescriptor(this.maprfs_, path));
                }
            }
        }
        return failed.toArray(new HTableDescriptor[failed.size()]);
    }

    public void addColumn(String tableName, HColumnDescriptor cf) throws IOException {
        this.addColumn(this.getTablePath(tableName), cf);
    }

    public void addColumn(Path tablePath, HColumnDescriptor cf) throws IOException {
        this.checkTable(tablePath);
        String name = cf.getNameAsString();
        try {
            this.maprfs_.createColumnFamily(this.maprfs_.resolveTablePath(tablePath), name, SchemaHelper.toSchemaFamily(cf, false));
        }
        catch (IOException e) {
            LOG.error((Object)("Exception while adding column familiy '" + name + "' for table '" + tablePath + "'"));
            throw e;
        }
    }

    public void modifyColumn(String tableName, HColumnDescriptor cf) throws IOException {
        this.modifyColumn(this.getTablePath(tableName), cf);
    }

    public void modifyColumn(Path tablePath, HColumnDescriptor cf) throws IOException {
        HTableDescriptor desc = this.getTableDescriptor(tablePath);
        if (!desc.hasFamily(cf.getName())) {
            throw new InvalidFamilyOperationException("Column family '" + cf.getNameAsString() + "' does not exist");
        }
        try {
            this.maprfs_.modifyColumnFamily(this.maprfs_.resolveTablePath(tablePath), cf.getNameAsString(), SchemaHelper.toSchemaFamily(cf, false));
        }
        catch (IOException e) {
            LOG.error((Object)("Exception while modifying column familiy '" + cf.getNameAsString() + "' for table '" + tablePath + "'"));
            throw e;
        }
    }

    public void deleteColumn(String tableName, String columnName) throws IOException {
        Path path = this.getTablePath(tableName);
        this.checkTable(path);
        try {
            this.maprfs_.deleteColumnFamily(this.maprfs_.resolveTablePath(path), columnName);
        }
        catch (IOException e) {
            LOG.error((Object)("Exception while deleting column familiy '" + columnName + "' for table '" + tableName + "'"));
            throw e;
        }
    }

    public void modifyTable(String tableName, HTableDescriptor htd) throws IOException {
        Path path = this.getTablePath(tableName);
        this.checkTable(path);
        TableProperties.setTableProperties(path, htd.getValues());
    }

    public void enableTable(String tableName) throws IOException {
        Path path = this.getTablePath(tableName);
        this.checkTable(path);
        TableProperties.setTableProperty(path, "DISABLED", TableProperties.FALSE);
    }

    public HTableDescriptor[] enableTables(String regex) throws IOException {
        return this.setTableDisabledStatus(regex, false);
    }

    public void disableTable(String tableName) throws IOException {
        Path path = this.getTablePath(tableName);
        this.checkTable(path);
        TableProperties.setTableProperty(path, "DISABLED", TableProperties.TRUE);
    }

    public HTableDescriptor[] disableTables(String regex) throws IOException {
        return this.setTableDisabledStatus(regex, true);
    }

    public boolean isTableEnabled(String tableName) throws IOException {
        return !this.isTableDisabled(tableName);
    }

    public boolean isTableDisabled(String tableName) throws IOException {
        Path path = this.getTablePath(tableName);
        this.checkTable(path);
        return Boolean.parseBoolean(TableProperties.getTableProperty(path, "DISABLED"));
    }

    public boolean isTableAvailable(String tableName) throws IOException {
        return this.tableExists(tableName) && this.isTableEnabled(tableName);
    }

    public List<HRegionInfo> getTableRegions(byte[] tableName) throws IOException {
        List nextSet;
        ArrayList<HRegionInfo> tableRegions = new ArrayList<HRegionInfo>();
        String tablePath = Bytes.toString((byte[])tableName);
        MapRTabletScanner scanner = this.maprfs_.getTabletScanner(new Path(tablePath));
        while ((nextSet = scanner.nextSet()) != null) {
            for (Dbserver.TabletDesc tablet : nextSet) {
                tableRegions.add(HRegionConverter.toHRegionInfo(tablet, tableName));
            }
        }
        return tableRegions;
    }

    protected HTableDescriptor[] setTableDisabledStatus(String regex, Boolean disabled) throws IOException {
        if (regex == null) {
            return null;
        }
        FileStatus[] tables = this.doListTables(regex);
        if (tables != null && tables.length > 0) {
            for (FileStatus table : tables) {
                TableProperties.setTableProperty(table.getPath(), "DISABLED", disabled.toString());
            }
        }
        return new HTableDescriptor[0];
    }

    protected Path getTablePath(String tableName) throws IOException {
        return this.tableMappingRule_.getMaprTablePath(tableName);
    }

    protected Path getTablePath(byte[] tableName) throws IOException {
        return this.tableMappingRule_.getMaprTablePath(tableName);
    }

    protected void unSupportedOperation(String operation) {
        throw new UnsupportedOperationException(operation + " called on MapR HBaseAdminImpl");
    }

    protected void checkTable(Path path) throws IOException, TableNotFoundException {
        if (!this.maprfs_.exists(path)) {
            throw new TableNotFoundException("Table '" + path + "' does not exist.");
        }
        if (!this.maprfs_.isTable(path)) {
            throw new TableNotFoundException("Path '" + path + "' is a not a table.");
        }
    }
}

